/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.NameTokenization;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.CrossProductAlphabetIndex;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.HashedAlphabetIndex;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.InfiniteCrossProductAlphabet;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.LinearAlphabetIndex;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleAtomicSymbol;
import org.biojava.bio.symbol.SimpleBasisSymbol;
import org.biojava.bio.symbol.SimpleCrossProductAlphabet;
import org.biojava.bio.symbol.SimpleSymbol;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.SparseCrossProductAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.OverlayMap;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class AlphabetManager {
    private static AlphabetManager am;
    private static Map nameToAlphabet;
    private static Map nameToSymbol;
    private static Map crossProductAlphabets;
    private static Map ambiguitySymbols;
    private static GapSymbol gapSymbol;
    private static Map gapBySize;
    private static Map alphabetToIndex;
    static /* synthetic */ Class class$org$biojava$bio$symbol$AlphabetManager;

    public static Symbol getAllAmbiguitySymbol(FiniteAlphabet alpha) {
        HashSet allSymbols = new HashSet();
        Iterator i = alpha.iterator();
        while (i.hasNext()) {
            allSymbols.add(i.next());
        }
        try {
            return alpha.getAmbiguity(allSymbols);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex, "Assertion failure: coudn't recover all-ambiguity symbol");
        }
    }

    public static Set getAllSymbols(FiniteAlphabet alpha) {
        HashSet<Symbol> allSymbols = new HashSet<Symbol>();
        ArrayList orderedAlpha = new ArrayList(alpha.size());
        Iterator i = alpha.iterator();
        while (i.hasNext()) {
            orderedAlpha.add(i.next());
        }
        int atomicSyms = alpha.size();
        int totalSyms = 1 << atomicSyms;
        int cnt = 0;
        while (cnt < totalSyms) {
            HashSet matchSet = new HashSet();
            int atom = 0;
            while (atom < atomicSyms) {
                if ((cnt & 1 << atom) != 0) {
                    matchSet.add(orderedAlpha.get(atom));
                }
                ++atom;
            }
            try {
                allSymbols.add(alpha.getAmbiguity(matchSet));
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex, "Assertion failed: couldn't get ambiguity symbol");
            }
            ++cnt;
        }
        return allSymbols;
    }

    public static AlphabetManager instance() {
        if (am == null) {
            am = new AlphabetManager();
        }
        return am;
    }

    public static Alphabet alphabetForName(String name) throws NoSuchElementException {
        Alphabet alpha = (Alphabet)nameToAlphabet.get(name);
        if (alpha == null) {
            if (name.startsWith("(") && name.endsWith(")")) {
                alpha = AlphabetManager.generateCrossProductAlphaFromName(name);
            } else {
                throw new NoSuchElementException("No alphabet for name " + name + " could be found");
            }
        }
        return alpha;
    }

    public static Symbol symbolForName(String name) throws NoSuchElementException {
        Symbol s = (Symbol)nameToSymbol.get(name);
        if (s == null) {
            throw new NoSuchElementException("Could not find symbol under the name " + name);
        }
        return s;
    }

    public static void registerAlphabet(String name, Alphabet alphabet) {
        nameToAlphabet.put(name, alphabet);
    }

    public static boolean registered(String name) {
        return nameToAlphabet.containsKey(name);
    }

    public static Iterator alphabets() {
        return nameToAlphabet.values().iterator();
    }

    public static Symbol getGapSymbol() {
        return gapSymbol;
    }

    public static Symbol getGapSymbol(List alphas) {
        SizeQueen sq = new SizeQueen(alphas);
        Symbol s = (Symbol)gapBySize.get(sq);
        if (s == null) {
            if (alphas.size() == 0) {
                s = gapSymbol;
            } else if (alphas.size() == 1) {
                Alphabet a = (Alphabet)alphas.get(0);
                s = AlphabetManager.getGapSymbol(a.getAlphabets());
            } else {
                ArrayList<Symbol> symList = new ArrayList<Symbol>(alphas.size());
                Iterator i = alphas.iterator();
                while (i.hasNext()) {
                    Alphabet a = (Alphabet)i.next();
                    symList.add(AlphabetManager.getGapSymbol(a.getAlphabets()));
                }
                try {
                    s = new SimpleBasisSymbol(Annotation.EMPTY_ANNOTATION, symList, Alphabet.EMPTY_ALPHABET);
                }
                catch (IllegalSymbolException ise) {
                    throw new BioError(ise, "Assertion Failure: Should be able to make gap basis");
                }
            }
            gapBySize.put(sq, s);
        }
        return s;
    }

    public static AtomicSymbol createSymbol(String name, Annotation annotation) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, annotation);
        return as;
    }

    public static AtomicSymbol createSymbol(String name) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, Annotation.EMPTY_ANNOTATION);
        return as;
    }

    public static AtomicSymbol createSymbol(char token, String name, Annotation annotation) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, annotation);
        return as;
    }

    public static Symbol createSymbol(char token, Annotation annotation, List symList, Alphabet alpha) throws IllegalSymbolException {
        return AlphabetManager.createSymbol(annotation, symList, alpha);
    }

    public static Symbol createSymbol(Annotation annotation, List symList, Alphabet alpha) throws IllegalSymbolException {
        Iterator i = symList.iterator();
        int basis = 0;
        int atomC = 0;
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (!(s instanceof BasisSymbol)) continue;
            ++basis;
            if (!(s instanceof AtomicSymbol)) continue;
            ++atomC;
        }
        try {
            if (atomC == symList.size()) {
                return new SimpleAtomicSymbol(annotation, symList);
            }
            if (basis == symList.size()) {
                return new SimpleBasisSymbol(annotation, symList, new SimpleAlphabet(AlphabetManager.expandMatches(alpha, symList, new ArrayList())));
            }
            return new SimpleSymbol(annotation, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, symList, new ArrayList())));
        }
        catch (IllegalSymbolException ise) {
            throw new IllegalSymbolException(ise, "Could not create a new symbol with: " + annotation + "\t" + symList + "\t" + alpha);
        }
    }

    private static Set expandBasis(Alphabet alpha, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            Symbol s = (Symbol)symList.get(indx);
            if (s instanceof AtomicSymbol) {
                built.add(s);
                return AlphabetManager.expandBasis(alpha, symList, built);
            }
            HashSet res = new HashSet();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)i.next();
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add(as);
                res.addAll(AlphabetManager.expandBasis(alpha, symList, built2));
            }
            return res;
        }
        try {
            return Collections.singleton(alpha.getSymbol(built));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should just have legal AtomicSymbol instances.");
        }
    }

    public static Symbol createSymbol(char token, Annotation annotation, Set symSet, Alphabet alpha) throws IllegalSymbolException {
        return AlphabetManager.createSymbol(annotation, symSet, alpha);
    }

    public static Symbol createSymbol(Annotation annotation, Set symSet, Alphabet alpha) throws IllegalSymbolException {
        if (symSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        HashSet<AtomicSymbol> asSet = new HashSet<AtomicSymbol>();
        int len = -1;
        Iterator i = symSet.iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (s instanceof AtomicSymbol) {
                AtomicSymbol as = (AtomicSymbol)s;
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
                continue;
            }
            Iterator j = ((FiniteAlphabet)s.getMatches()).iterator();
            while (j.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)j.next();
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
            }
        }
        if (asSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        if (asSet.size() == 1) {
            return (Symbol)asSet.iterator().next();
        }
        if (len == 1) {
            return new SimpleBasisSymbol(annotation, new SimpleAlphabet(asSet));
        }
        List fs = AlphabetManager.factorize(alpha, asSet);
        if (fs == null) {
            return new SimpleSymbol(annotation, new SimpleAlphabet(asSet));
        }
        return new SimpleBasisSymbol(annotation, fs, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, fs, new ArrayList())));
    }

    public static Alphabet generateCrossProductAlphaFromName(String name) {
        if (!name.startsWith("(") || !name.endsWith(")")) {
            throw new BioError("Can't parse " + name + " into a cross-product alphabet as it is not bracketed");
        }
        name = name.substring(1, name.length() - 1).trim();
        ArrayList<Alphabet> aList = new ArrayList<Alphabet>();
        int i = 0;
        while (i < name.length()) {
            Object alpha = null;
            if (name.charAt(i) == '(') {
                int depth = 1;
                int j = i + 1;
                while (j < name.length() && depth > 0) {
                    char c = name.charAt(j);
                    if (c == '(') {
                        ++depth;
                    } else if (c == ')') {
                        --depth;
                    }
                    ++j;
                }
                if (depth == 0) {
                    aList.add(AlphabetManager.alphabetForName(name.substring(i, j)));
                    i = j;
                    continue;
                }
                throw new BioError("Error parsing alphabet name: could not find matching bracket\n" + name.substring(i));
            }
            int j = name.indexOf(" x ", i);
            if (j < 0) {
                aList.add(AlphabetManager.alphabetForName(name.substring(i).trim()));
                i = name.length();
                continue;
            }
            if (i != j) {
                aList.add(AlphabetManager.alphabetForName(name.substring(i, j).trim()));
            }
            i = j + " x ".length();
        }
        return AlphabetManager.getCrossProductAlphabet(aList);
    }

    public static Alphabet getCrossProductAlphabet(List aList) {
        return AlphabetManager.getCrossProductAlphabet(aList, (Alphabet)null);
    }

    public static Alphabet getCrossProductAlphabet(List aList, String name) throws IllegalAlphabetException {
        Alphabet currentAlpha = (Alphabet)nameToAlphabet.get(name);
        if (currentAlpha != null) {
            if (currentAlpha.getAlphabets().equals(aList)) {
                return currentAlpha;
            }
            throw new IllegalAlphabetException(name + " already registered");
        }
        Alphabet alpha = AlphabetManager.getCrossProductAlphabet(aList);
        AlphabetManager.registerAlphabet(name, alpha);
        return alpha;
    }

    public static Alphabet getCrossProductAlphabet(List aList, Alphabet parent) {
        if (aList.size() == 0) {
            return Alphabet.EMPTY_ALPHABET;
        }
        if (aList.size() == 1) {
            return (Alphabet)aList.get(0);
        }
        if (crossProductAlphabets == null) {
            crossProductAlphabets = new HashMap();
        }
        Alphabet cpa = (Alphabet)crossProductAlphabets.get(aList);
        int size = 1;
        if (cpa == null) {
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                Alphabet aa = (Alphabet)i.next();
                if (!(aa instanceof FiniteAlphabet)) {
                    cpa = new InfiniteCrossProductAlphabet(aList);
                    break;
                }
                if (size > 1000) continue;
                size *= ((FiniteAlphabet)aa).size();
            }
            if (cpa == null) {
                try {
                    cpa = size > 0 && size < 1000 ? new SimpleCrossProductAlphabet(aList, parent) : new SparseCrossProductAlphabet(aList);
                }
                catch (IllegalAlphabetException iae) {
                    throw new BioError("Could not create SimpleCrossProductAlphabet for " + aList + " even though we should be able to. No idea what is wrong.");
                }
            }
            crossProductAlphabets.put(new ArrayList(aList), cpa);
            AlphabetManager.registerAlphabet(cpa.getName(), cpa);
        }
        return cpa;
    }

    private static Set expandMatches(Alphabet parent, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            BasisSymbol bs = (BasisSymbol)symList.get(indx);
            if (bs instanceof AtomicSymbol) {
                built.add(bs);
                return AlphabetManager.expandMatches(parent, symList, built);
            }
            HashSet syms = new HashSet();
            Iterator i = ((FiniteAlphabet)bs.getMatches()).iterator();
            while (i.hasNext()) {
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add((AtomicSymbol)i.next());
                syms.addAll(AlphabetManager.expandMatches(parent, symList, built2));
            }
            return syms;
        }
        try {
            Symbol s = parent.getSymbol(built);
            if (s instanceof AtomicSymbol) {
                return Collections.singleton((AtomicSymbol)s);
            }
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)i.next());
            }
            return syms;
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Couldn't create symbol.");
        }
    }

    public static List factorize(Alphabet alpha, Set symSet) throws IllegalSymbolException {
        List alphas = alpha.getAlphabets();
        ArrayList<Symbol> facts = new ArrayList<Symbol>();
        int size = symSet.size();
        HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
        int col = 0;
        while (col < alphas.size()) {
            Alphabet a = (Alphabet)alphas.get(col);
            Iterator i = symSet.iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)((AtomicSymbol)i.next()).getSymbols().get(col));
            }
            int s = syms.size();
            if (size % s != 0) {
                return null;
            }
            size /= s;
            facts.add(a.getAmbiguity(syms));
            syms.clear();
            ++col;
        }
        if (size != 1) {
            return null;
        }
        return facts;
    }

    public static void loadAlphabets(InputSource is) throws SAXException, IOException, BioException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader parser = spf.newSAXParser().getXMLReader();
            parser.setContentHandler(new SAX2StAXAdaptor(new AlphabetManagerHandler()));
            parser.parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new BioException(ex, "Unable to create XML parser");
        }
    }

    public static AlphabetIndex getAlphabetIndex(FiniteAlphabet alpha) {
        int generateIndexSize = 160;
        Changeable ai = (AlphabetIndex)alphabetToIndex.get(alpha);
        if (ai == null) {
            int size = alpha.size();
            ai = size <= 160 ? new LinearAlphabetIndex(alpha) : (alpha.getAlphabets().size() > 1 ? new CrossProductAlphabetIndex(alpha) : new HashedAlphabetIndex(alpha));
            alphabetToIndex.put(alpha, ai);
        }
        return ai;
    }

    public static AlphabetIndex getAlphabetIndex(Symbol[] syms) throws IllegalSymbolException, BioException {
        return new LinearAlphabetIndex(syms);
    }

    private static Symbol getWellKnownAmbiguitySymbol(Set s) {
        Symbol sym = (Symbol)ambiguitySymbols.get(s);
        if (sym == null) {
            WellKnownAlphabet matchAlpha = new WellKnownAlphabet(s);
            sym = new WellKnownBasisSymbol(new SimpleBasisSymbol(Annotation.EMPTY_ANNOTATION, matchAlpha));
            ambiguitySymbols.put(new HashSet(s), sym);
        }
        return sym;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        alphabetToIndex = new HashMap();
        nameToAlphabet = new HashMap();
        nameToSymbol = new HashMap();
        ambiguitySymbols = new HashMap();
        gapSymbol = new GapSymbol();
        gapBySize = new HashMap();
        gapBySize.put(new SizeQueen(new ArrayList()), gapSymbol);
        nameToAlphabet.put("INTEGER", IntegerAlphabet.getInstance());
        nameToAlphabet.put("DOUBLE", DoubleAlphabet.getInstance());
        try {
            gapBySize.put(new SizeQueen(Arrays.asList(DoubleAlphabet.getInstance())), new SimpleBasisSymbol(Annotation.EMPTY_ANNOTATION, Arrays.asList(gapSymbol), Alphabet.EMPTY_ALPHABET));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should be able to make gap basis");
        }
        ambiguitySymbols.put(new HashSet(), gapSymbol);
        try {
            InputStream alphabetStream = (class$org$biojava$bio$symbol$AlphabetManager == null ? (class$org$biojava$bio$symbol$AlphabetManager = AlphabetManager.class$("org.biojava.bio.symbol.AlphabetManager")) : class$org$biojava$bio$symbol$AlphabetManager).getClassLoader().getResourceAsStream("org/biojava/bio/symbol/AlphabetManager.xml");
            if (alphabetStream == null) {
                throw new BioError("Couldn't locate AlphabetManager.xml.  This probably means that your biojava.jar file is corrupt or incorrectly built.");
            }
            InputSource is = new InputSource(alphabetStream);
            AlphabetManager.loadAlphabets(is);
        }
        catch (Exception t) {
            throw new BioError(t, "Unable to initialize AlphabetManager");
        }
    }

    private static final class SizeQueen
    extends AbstractList {
        private final List alphas;

        public SizeQueen(List alphas) {
            this.alphas = alphas;
        }

        public int size() {
            return this.alphas.size();
        }

        public Object get(int pos) {
            Alphabet a = (Alphabet)this.alphas.get(pos);
            List al = a.getAlphabets();
            int size = al.size();
            if (size > 1) {
                return new SizeQueen(al);
            }
            return new Integer(size);
        }
    }

    private static class GapSymbol
    extends Unchangeable
    implements Symbol,
    Serializable {
        public String getName() {
            return "gap";
        }

        public char getToken() {
            return '-';
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public Alphabet getMatches() {
            return Alphabet.EMPTY_ALPHABET;
        }
    }

    private static class WellKnownBasisSymbol
    extends Unchangeable
    implements BasisSymbol,
    Serializable {
        protected BasisSymbol symbol;
        private Set matches;

        WellKnownBasisSymbol(BasisSymbol symbol) {
            symbol.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
            this.symbol = symbol;
            this.matches = new HashSet();
            Iterator i = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (i.hasNext()) {
                this.matches.add(i.next());
            }
        }

        Symbol getSymbol() {
            return this.symbol;
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof WellKnownBasisSymbol) {
                return this.symbol.equals(((WellKnownBasisSymbol)o).getSymbol());
            }
            return false;
        }

        public String getName() {
            return this.symbol.getName();
        }

        public Alphabet getMatches() {
            return this.symbol.getMatches();
        }

        public List getSymbols() {
            return Collections.singletonList(this);
        }

        public Annotation getAnnotation() {
            return this.symbol.getAnnotation();
        }

        private Object writeReplace() {
            return new OPH(this.matches);
        }

        private static class OPH
        implements Serializable {
            private Set matches;

            public OPH(Set matches) {
                this.matches = matches;
            }

            private Object readResolve() {
                return AlphabetManager.getWellKnownAmbiguitySymbol(this.matches);
            }
        }
    }

    private static class WellKnownAtomicSymbol
    extends WellKnownBasisSymbol
    implements AtomicSymbol {
        WellKnownAtomicSymbol(AtomicSymbol symbol) {
            super(symbol);
        }

        public Alphabet getMatches() {
            return new SingletonAlphabet(this);
        }

        private Object writeReplace() {
            return new OPH(this.getName());
        }

        private static class OPH
        implements Serializable {
            private String name;

            public OPH(String name) {
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    return AlphabetManager.symbolForName(this.name);
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve symbol:" + this.name);
                }
            }
        }
    }

    private static class ImmutableWellKnownAlphabetWrapper
    extends Unchangeable
    implements FiniteAlphabet,
    Serializable {
        private FiniteAlphabet alpha;
        private Map tokenizationsByName = new HashMap();

        public ImmutableWellKnownAlphabetWrapper(FiniteAlphabet alpha) {
            this.alpha = alpha;
        }

        private Object writeReplace() {
            return new OPH(this.getName());
        }

        public SymbolTokenization getTokenization(String name) throws BioException {
            SymbolTokenization toke = (SymbolTokenization)this.tokenizationsByName.get(name);
            if (toke == null) {
                toke = "name".equals(name) ? new NameTokenization(this) : new WellKnownTokenizationWrapper(this, this.alpha.getTokenization(name), name);
                this.tokenizationsByName.put(name, toke);
            }
            return toke;
        }

        public boolean contains(Symbol s) {
            return this.alpha.contains(s);
        }

        public List getAlphabets() {
            return Collections.singletonList(this);
        }

        public Symbol getAmbiguity(Set s) throws IllegalSymbolException {
            return this.alpha.getAmbiguity(s);
        }

        public Symbol getGapSymbol() {
            return this.alpha.getGapSymbol();
        }

        public String getName() {
            return this.alpha.getName();
        }

        public Symbol getSymbol(List l) throws IllegalSymbolException {
            return this.alpha.getSymbol(l);
        }

        public void validate(Symbol s) throws IllegalSymbolException {
            this.alpha.validate(s);
        }

        public void addSymbol(Symbol s) throws ChangeVetoException {
            throw new ChangeVetoException("Can't add symbols to Well Known Alphabets");
        }

        public void removeSymbol(Symbol s) throws ChangeVetoException {
            throw new ChangeVetoException("Can't remove symbols from Well Known Alphabets");
        }

        public Iterator iterator() {
            return this.alpha.iterator();
        }

        public int size() {
            return this.alpha.size();
        }

        public Annotation getAnnotation() {
            return this.alpha.getAnnotation();
        }

        private static class OPH
        implements Serializable {
            private String name;

            public OPH(String name) {
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    Alphabet a = AlphabetManager.alphabetForName(this.name);
                    return a;
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve alphabet " + this.name);
                }
            }
        }
    }

    private static class WellKnownAlphabet
    extends SimpleAlphabet {
        public WellKnownAlphabet() {
        }

        public WellKnownAlphabet(Set s) {
            super(s);
        }

        protected Symbol getAmbiguityImpl(Set s) throws IllegalSymbolException {
            return AlphabetManager.getWellKnownAmbiguitySymbol(s);
        }
    }

    private static class WellKnownTokenizationWrapper
    extends Unchangeable
    implements SymbolTokenization,
    Serializable {
        private String name;
        private Alphabet alphabet;
        private SymbolTokenization toke;

        WellKnownTokenizationWrapper(Alphabet alpha, SymbolTokenization toke, String name) {
            this.alphabet = alpha;
            this.name = name;
            this.toke = toke;
        }

        public Alphabet getAlphabet() {
            return this.alphabet;
        }

        public SymbolTokenization.TokenType getTokenType() {
            return this.toke.getTokenType();
        }

        public StreamParser parseStream(SeqIOListener listener) {
            return this.toke.parseStream(listener);
        }

        public Symbol parseToken(String s) throws IllegalSymbolException {
            return this.toke.parseToken(s);
        }

        public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
            return this.toke.tokenizeSymbol(s);
        }

        public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException, IllegalSymbolException {
            return this.toke.tokenizeSymbolList(sl);
        }

        public Annotation getAnnotation() {
            return this.toke.getAnnotation();
        }

        public Object writeReplace() {
            return new OPH(this.getAlphabet().getName(), this.name);
        }

        private static class OPH
        implements Serializable {
            private String alphaName;
            private String name;

            OPH(String alphaName, String name) {
                this.alphaName = alphaName;
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    Alphabet alphabet = AlphabetManager.alphabetForName(this.alphaName);
                    return alphabet.getTokenization(this.name);
                }
                catch (Exception ex) {
                    throw new InvalidObjectException("Couldn't resolve tokenization " + this.name + " in alphabet " + this.alphaName);
                }
            }
        }
    }

    private static class AlphabetManagerHandler
    extends StAXContentHandlerBase {
        private AlphabetManagerHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (!localName.equals("alphabetManager")) {
                if (localName.equals("symbol")) {
                    String name = attrs.getValue("name");
                    dm.delegate(new SymbolHandler(name));
                } else if (localName.equals("alphabet")) {
                    String name = attrs.getValue("name");
                    String parent = attrs.getValue("parent");
                    FiniteAlphabet parentAlpha = null;
                    if (parent != null && parent.length() > 0) {
                        parentAlpha = (FiniteAlphabet)nameToAlphabet.get(parent);
                    }
                    dm.delegate(new AlphabetHandler(name, parentAlpha));
                } else {
                    throw new SAXException("Unknown element in alphabetManager: " + localName);
                }
            }
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
            if (delegate instanceof SymbolHandler) {
                SymbolHandler sh = (SymbolHandler)delegate;
                String name = sh.getName();
                Symbol symbol = sh.getSymbol();
                if (nameToSymbol.containsKey("name")) {
                    throw new SAXException("There is already a top-level symbol named " + name);
                }
                nameToSymbol.put(name, symbol);
            } else if (delegate instanceof AlphabetHandler) {
                AlphabetHandler ah = (AlphabetHandler)delegate;
                String name = ah.getName();
                FiniteAlphabet alpha = ah.getAlphabet();
                AlphabetManager.registerAlphabet(name, alpha);
            }
        }

        private class CharacterTokenizationHandler
        extends StAXContentHandlerBase {
            private String name;
            private Map localSymbols;
            private CharacterTokenization toke;

            String getName() {
                return this.name;
            }

            SymbolTokenization getTokenization() {
                return this.toke;
            }

            public CharacterTokenizationHandler(String name, FiniteAlphabet alpha, Map localSymbols, boolean caseSensitive) {
                this.name = name;
                this.localSymbols = new HashMap();
                Iterator i = alpha.iterator();
                while (i.hasNext()) {
                    Symbol sym = (Symbol)i.next();
                    this.localSymbols.put(sym.getName(), sym);
                }
                this.toke = new CharacterTokenization(alpha, caseSensitive);
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("characterTokenization")) {
                    if (localName.equals("atomicMapping")) {
                        dm.delegate(new MappingHandler(true));
                    } else if (localName.equals("ambiguityMapping")) {
                        dm.delegate(new MappingHandler(false));
                    } else {
                        throw new SAXException("Unknown element in characterTokenization: " + localName);
                    }
                }
            }

            private class MappingHandler
            extends StAXContentHandlerBase {
                boolean isAtomic;
                Set symbols = new HashSet();
                char c = '\u0000';
                int level = 0;

                public MappingHandler(boolean isAtomic) {
                    this.isAtomic = isAtomic;
                }

                public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                    if (this.level == 0) {
                        this.c = attrs.getValue("token").charAt(0);
                    } else if (localName.equals("symbolref")) {
                        String name = attrs.getValue("name");
                        Symbol sym = (Symbol)CharacterTokenizationHandler.this.localSymbols.get(name);
                        if (sym == null) {
                            throw new SAXException("Reference to non-existent symbol " + name);
                        }
                        this.symbols.add(sym);
                    } else {
                        throw new SAXException("Unknown element in mapping: " + localName);
                    }
                    ++this.level;
                }

                public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                    --this.level;
                }

                public void endTree() throws SAXException {
                    try {
                        Symbol ambiSym = CharacterTokenizationHandler.this.toke.getAlphabet().getAmbiguity(this.symbols);
                        CharacterTokenizationHandler.this.toke.bindSymbol(ambiSym, this.c);
                    }
                    catch (IllegalSymbolException ex) {
                        ex.printStackTrace();
                        throw new SAXException("IllegalSymbolException binding mapping for " + this.c);
                    }
                }
            }
        }

        private class AlphabetHandler
        extends StAXContentHandlerBase {
            private String name;
            private Map localSymbols;
            private WellKnownAlphabet alpha;
            private ImmutableWellKnownAlphabetWrapper alphaWrapper;

            String getName() {
                return this.name;
            }

            FiniteAlphabet getAlphabet() {
                return this.alphaWrapper;
            }

            public void endTree() {
                this.alpha.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
            }

            public AlphabetHandler(String name, FiniteAlphabet parent) {
                this.name = name;
                this.localSymbols = new OverlayMap(nameToSymbol);
                this.alpha = new WellKnownAlphabet();
                this.alpha.setName(name);
                this.alphaWrapper = new ImmutableWellKnownAlphabetWrapper(this.alpha);
                if (parent != null) {
                    Iterator i = parent.iterator();
                    while (i.hasNext()) {
                        Symbol sym = (Symbol)i.next();
                        try {
                            this.alpha.addSymbol(sym);
                        }
                        catch (Exception ex) {
                            throw new BioError(ex, "Couldn't initialize alphabet from parent");
                        }
                        this.localSymbols.put(sym.getName(), sym);
                    }
                }
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("alphabet")) {
                    if (localName.equals("symbol")) {
                        String name = attrs.getValue("name");
                        dm.delegate(new SymbolHandler(name));
                    } else if (localName.equals("symbolref")) {
                        String name = attrs.getValue("name");
                        Symbol sym = (Symbol)this.localSymbols.get(name);
                        if (sym == null) {
                            throw new SAXException("Reference to non-existent symbol " + name);
                        }
                        this.addSymbol(sym);
                    } else if (localName.equals("characterTokenization")) {
                        String name = attrs.getValue("name");
                        boolean caseSensitive = "true".equals(attrs.getValue("caseSensitive"));
                        dm.delegate(new CharacterTokenizationHandler(name, this.alphaWrapper, this.localSymbols, caseSensitive));
                    } else if (localName.equals("description")) {
                        dm.delegate(new StringElementHandlerBase(this){
                            private final /* synthetic */ AlphabetHandler this$1;
                            {
                                this.this$1 = this$1;
                            }

                            protected void setStringValue(String s) {
                                try {
                                    AlphabetHandler.access$400(this.this$1).getAnnotation().setProperty("description", s);
                                }
                                catch (ChangeVetoException ex) {
                                    throw new BioError(ex, "Assertion failure: veto while modifying new Annotation");
                                }
                            }
                        });
                    } else {
                        throw new SAXException("Unknown element in alphabetl: " + localName);
                    }
                }
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof SymbolHandler) {
                    SymbolHandler sh = (SymbolHandler)delegate;
                    String name = sh.getName();
                    Symbol symbol = sh.getSymbol();
                    this.localSymbols.put(name, symbol);
                    this.addSymbol(symbol);
                } else if (delegate instanceof CharacterTokenizationHandler) {
                    CharacterTokenizationHandler cth = (CharacterTokenizationHandler)delegate;
                    String name = cth.getName();
                    SymbolTokenization toke = cth.getTokenization();
                    this.alpha.putTokenization(name, toke);
                }
            }

            private void addSymbol(Symbol sym) throws SAXException {
                try {
                    this.alpha.addSymbol(sym);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve, "Assertion failure: veto while modifying new Alphabet");
                }
                catch (IllegalSymbolException ex) {
                    throw new SAXException("IllegalSymbolException adding symbol to alphabet");
                }
            }

            static /* synthetic */ WellKnownAlphabet access$400(AlphabetHandler x0) {
                return x0.alpha;
            }
        }

        private class SymbolHandler
        extends StAXContentHandlerBase {
            private String name;
            private Symbol symbol;
            private Annotation annotation = new SmallAnnotation();

            public SymbolHandler(String name) {
                this.name = name;
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("symbol")) {
                    if (localName.equals("description")) {
                        dm.delegate(new StringElementHandlerBase(){

                            protected void setStringValue(String s) {
                                try {
                                    annotation.setProperty("description", s);
                                }
                                catch (ChangeVetoException ex) {
                                    throw new BioError(ex, "Assertion failure: veto while modifying new Annotation");
                                }
                            }
                        });
                    } else {
                        throw new SAXException("Unknown element in symbol: " + localName);
                    }
                }
            }

            public void endTree() {
                this.symbol = new WellKnownAtomicSymbol(new FundamentalAtomicSymbol(this.name, this.annotation));
            }

            Symbol getSymbol() {
                return this.symbol;
            }

            String getName() {
                return this.name;
            }
        }
    }
}

