/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.components.EntryEdit;

public class EntryGroupDisplay
extends JPanel
implements EntryGroupChangeListener,
EntryChangeListener {
    private static final Color background_colour = new Color(200, 200, 200);
    private EntryEdit owning_component;
    private EntryGroup entry_group;
    private Vector entry_components = new Vector();
    private JLabel label;

    public EntryGroupDisplay(EntryEdit owning_component) {
        this.owning_component = owning_component;
        this.entry_group = owning_component.getEntryGroup();
        this.entry_group.addEntryGroupChangeListener(this);
        this.entry_group.addEntryChangeListener(this);
        FlowLayout flow_layout = new FlowLayout(0);
        this.label = new JLabel("Entry: ");
        this.setLayout(flow_layout);
        this.refreshButtons();
        this.setBackground(background_colour);
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: {
                this.refreshButtons();
                break;
            }
            case 3: 
            case 4: {
                this.updateActive();
                break;
            }
            case 5: {
                this.highlightDefaultEntry(event);
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        if (event.getType() == 3) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        this.removeAll();
        this.add(this.label);
        this.entry_components = new Vector();
        if (this.entry_group == null) {
            return;
        }
        for (int i = 0; i < this.entry_group.size(); ++i) {
            this.add(this.entry_group.elementAt(i));
        }
        this.doLayout();
    }

    private void updateActive() {
        for (int i = 0; i < this.entry_group.size(); ++i) {
            JCheckBox menu_item = (JCheckBox)this.entry_components.elementAt(i);
            menu_item.setSelected(this.entry_group.isActive(this.entry_group.elementAt(i)));
        }
    }

    private void add(final Entry entry) {
        String entry_name = entry.getName();
        if (entry_name == null) {
            entry_name = "no name";
        }
        JCheckBox new_component = new JCheckBox(entry_name, this.entry_group.isActive(entry));
        this.setEntryHighlight(entry, new_component);
        new_component.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                int button_index = EntryGroupDisplay.this.entry_components.indexOf(event.getSource());
                if (event.getStateChange() == 1) {
                    EntryGroupDisplay.this.entry_group.setIsActive(button_index, true);
                } else {
                    EntryGroupDisplay.this.entry_group.setIsActive(button_index, false);
                }
            }
        });
        new_component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    EntryGroupDisplay.this.entry_group.setDefaultEntry(entry);
                }
            }
        });
        this.entry_components.addElement(new_component);
        this.add(new_component);
    }

    private void highlightDefaultEntry(EntryGroupChangeEvent event) {
        EntryGroup entry_group = this.owning_component.getEntryGroup();
        for (int i = 0; i < entry_group.size(); ++i) {
            JCheckBox check_box = (JCheckBox)this.entry_components.elementAt(i);
            this.setEntryHighlight(entry_group.elementAt(i), check_box);
        }
    }

    private void setEntryHighlight(Entry entry, JCheckBox component) {
        String label = component.getText();
        if (this.entry_group.getDefaultEntry() == entry) {
            component.setBackground(Color.yellow);
        } else {
            component.setBackground(background_colour);
        }
    }
}

