/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.emboss.jemboss.editor.AlignJFrame;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.FileNode;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.SwingWorker;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class FileTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
ActionListener,
Autoscroll {
    private File root;
    private Vector openNode;
    private String fs = new String(System.getProperty("file.separator"));
    private JPopupMenu popup;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private static final int AUTOSCROLL_MARGIN = 45;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);
    private FileFilter filter = null;

    public FileTree(File rt, final JFrame f, FileFilter filter) {
        this.root = rt;
        this.filter = filter;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        DefaultTreeModel model = this.createTreeModel(this.root);
        this.setModel(model);
        this.createTreeModelListener();
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        JMenu openMenu = new JMenu("Open With");
        this.popup.add(openMenu);
        menuItem = new JMenuItem("Jemboss Alignment Editor");
        menuItem.addActionListener(this);
        openMenu.add(menuItem);
        menuItem = new JMenuItem("Artemis");
        menuItem.addActionListener(this);
        openMenu.add(menuItem);
        menuItem = new JMenuItem("Rename...");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("New Folder...");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Delete...");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        menuItem = new JMenuItem("De-select All");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2 && FileTree.this.isFileSelection() && !me.isPopupTrigger()) {
                    f.setCursor(FileTree.this.cbusy);
                    FileNode node = FileTree.this.getSelectedNode();
                    String selected = node.getFile().getAbsolutePath();
                    FileTree.this.showFilePane(selected);
                    f.setCursor(FileTree.this.cdone);
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                FileNode node;
                TreePath path = e.getPath();
                if (path != null && !(node = (FileNode)path.getLastPathComponent()).isExplored()) {
                    f.setCursor(FileTree.this.cbusy);
                    FileTree.this.exploreNode(node);
                    f.setCursor(FileTree.this.cdone);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        block15: {
            String inputValue;
            File f;
            FileNode node;
            JMenuItem source;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    source = (JMenuItem)e.getSource();
                                    node = this.getSelectedNode();
                                    if (source.getText().equals("Refresh")) {
                                        if (node == null) {
                                            this.newRoot(this.root.getAbsolutePath());
                                        } else if (node.isLeaf()) {
                                            this.refresh((FileNode)node.getParent());
                                        } else {
                                            this.refresh(node);
                                        }
                                        return;
                                    }
                                    if (node == null) {
                                        JOptionPane.showMessageDialog(null, "No file selected.", "Warning", 2);
                                        return;
                                    }
                                    f = node.getFile();
                                    if (!source.getText().equals("Jemboss Alignment Editor")) break block14;
                                    AlignJFrame ajFrame = new AlignJFrame(f);
                                    ((Component)ajFrame).setVisible(true);
                                    break block15;
                                }
                                if (!source.getText().equals("Artemis")) break block16;
                                this.setCursor(this.cbusy);
                                String selected = node.getFile().getAbsolutePath();
                                this.showFilePane(selected);
                                this.setCursor(this.cdone);
                                break block15;
                            }
                            if (!source.getText().equals("Text Editor")) break block17;
                            this.showFilePane(f.getAbsolutePath());
                            break block15;
                        }
                        if (!source.getText().equals("New Folder...")) break block18;
                        String path = null;
                        path = node.isLeaf() ? f.getParent() : f.getAbsolutePath();
                        String inputValue2 = JOptionPane.showInputDialog(null, "Folder Name", "Create New Folder in " + path, 3);
                        if (inputValue2 == null || inputValue2.equals("")) break block15;
                        String fullname = path + this.fs + inputValue2;
                        File dir = new File(fullname);
                        if (dir.exists()) {
                            JOptionPane.showMessageDialog(null, fullname + " alread exists!", "Error", 0);
                        } else if (dir.mkdir()) {
                            this.addObject(inputValue2, path, node);
                        } else {
                            JOptionPane.showMessageDialog(null, "Cannot make the folder\n" + fullname, "Error", 0);
                        }
                        break block15;
                    }
                    if (!source.getText().equals("Delete...")) break block19;
                    File[] fn = this.getSelectedFiles();
                    String names = "";
                    for (int i = 0; i < fn.length; ++i) {
                        names = names.concat(fn[i].getAbsolutePath() + "\n");
                    }
                    int n = JOptionPane.showConfirmDialog(null, "Delete \n" + names + "?", "Delete Files", 0);
                    FileNode[] nodes = this.getSelectedNodes();
                    if (n != 0) break block15;
                    for (int i = 0; i < nodes.length; ++i) {
                        this.deleteFile(nodes[i]);
                    }
                    break block15;
                }
                if (!source.getText().equals("De-select All")) break block20;
                this.clearSelection();
                break block15;
            }
            if (!this.isFileSelection() || !source.getText().equals("Rename...") || (inputValue = (String)JOptionPane.showInputDialog(null, "New File Name", "Rename " + f.getName(), 3, null, null, f.getName())) == null || inputValue.equals("")) break block15;
            String path = f.getParent();
            String fullname = path + this.fs + inputValue;
            File newFile = new File(fullname);
            try {
                this.renameFile(f, node, newFile.getCanonicalPath());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void deleteFile(final FileNode node) {
        File f = node.getFile();
        if (f.delete()) {
            Runnable deleteFileFromTree = new Runnable(){

                public void run() {
                    FileTree.this.deleteObject(node);
                }
            };
            SwingUtilities.invokeLater(deleteFileFromTree);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot delete\n" + f.getAbsolutePath(), "Warning", 0);
        }
    }

    private void renameFile(File oldFile, final FileNode oldNode, String newFullName) {
        final File fnew = new File(newFullName);
        if (fnew.exists()) {
            JOptionPane.showMessageDialog(null, newFullName + " alread exists!", "Warning", 0);
        } else if (oldFile.renameTo(fnew)) {
            Runnable renameFileInTree = new Runnable(){

                public void run() {
                    FileTree.this.addObject(fnew.getName(), fnew.getParent(), oldNode);
                    FileTree.this.deleteObject(oldNode);
                }
            };
            SwingUtilities.invokeLater(renameFileInTree);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot rename \n" + oldFile.getAbsolutePath() + "\nto\n" + fnew.getAbsolutePath(), "Rename Error", 0);
        }
    }

    public void newRoot(String newRoot) {
        this.root = new File(newRoot);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model = this.createTreeModel(this.root);
        this.setModel(model);
    }

    public File getRoot() {
        return this.root;
    }

    public void refresh(FileNode node) {
        node.reExplore(this.filter);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(node);
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
        Enumeration en = this.openNode.elements();
        while (en.hasMoreElements()) {
            this.refresh((FileNode)en.nextElement());
        }
    }

    public FileNode getSelectedNode() {
        TreePath path = this.getLeadSelectionPath();
        if (path == null) {
            return null;
        }
        FileNode node = (FileNode)path.getLastPathComponent();
        return node;
    }

    public FileNode[] getSelectedNodes() {
        TreePath[] path = this.getSelectionPaths();
        if (path == null) {
            return null;
        }
        int numberSelected = path.length;
        FileNode[] nodes = new FileNode[numberSelected];
        for (int i = 0; i < numberSelected; ++i) {
            nodes[i] = (FileNode)path[i].getLastPathComponent();
        }
        return nodes;
    }

    public File[] getSelectedFiles() {
        FileNode[] fn = this.getSelectedNodes();
        int numberSelected = fn.length;
        File[] files = new File[numberSelected];
        for (int i = 0; i < numberSelected; ++i) {
            files[i] = fn[i].getFile();
        }
        return files;
    }

    public boolean isFileSelection() {
        TreePath path = this.getLeadSelectionPath();
        if (path == null) {
            return false;
        }
        FileNode node = (FileNode)path.getLastPathComponent();
        return node.isLeaf();
    }

    private DefaultTreeModel createTreeModel(File root) {
        FileNode rootNode = new FileNode(root);
        rootNode.explore(this.filter);
        this.openNode = new Vector();
        this.openNode.add(rootNode);
        return new DefaultTreeModel(rootNode);
    }

    public DefaultMutableTreeNode addObject(String child, String path, FileNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (node == null && (node = this.getNode(path)) == null) {
            return null;
        }
        FileNode parentNode = this.getNode(path);
        File newleaf = new File(path + this.fs + child);
        FileNode childNode = null;
        if (parentNode.isExplored()) {
            childNode = new FileNode(newleaf);
            int index = this.getAnIndex(parentNode, child);
            if (index > -1) {
                model.insertNodeInto(childNode, parentNode, index);
            }
        } else if (parentNode.isDirectory()) {
            this.exploreNode(parentNode);
            childNode = this.getNode(path + this.fs + child);
        }
        this.scrollPathToVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    public void deleteObject(FileNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        FileNode parentNode = this.getNode(node.getFile().getParent());
        model.removeNodeFromParent(node);
    }

    public void exploreNode(FileNode dirNode) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        dirNode.explore(this.filter);
        this.openNode.add(dirNode);
        model.nodeStructureChanged(dirNode);
    }

    private FileNode getNode(String path) {
        Enumeration en = this.openNode.elements();
        while (en.hasMoreElements()) {
            FileNode node = (FileNode)en.nextElement();
            String nodeName = node.getFile().getAbsolutePath();
            if (!nodeName.equals(path)) continue;
            return node;
        }
        en = this.openNode.elements();
        while (en.hasMoreElements()) {
            FileNode child = this.getChildNode((FileNode)en.nextElement(), path);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private FileNode getChildNode(FileNode parent, String childName) {
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            FileNode childNode = (FileNode)children.nextElement();
            String nodeName = childNode.getFile().getAbsolutePath();
            if (!childName.equals(nodeName)) continue;
            return childNode;
        }
        return null;
    }

    private int getAnIndex(FileNode parentNode, String child) {
        int num;
        int childIndex = num = parentNode.getChildCount();
        for (int i = 0; i < num; ++i) {
            String nodeName = ((FileNode)parentNode.getChildAt(i)).getFile().getName();
            if (nodeName.compareTo(child) > 0) {
                childIndex = i;
                break;
            }
            if (nodeName.compareTo(child) != 0) continue;
            childIndex = -1;
            break;
        }
        return childIndex;
    }

    protected static byte[] readByteFile(String filename) {
        File fn = new File(filename);
        byte[] b = null;
        try {
            long s = fn.length();
            if (s == 0L) {
                return b;
            }
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(fn);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + filename);
        }
        return b;
    }

    public void showFilePane(final String filename) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        progress_thread.start();
        SwingWorker entryWorker = new SwingWorker(){
            EntryEdit entry_edit;

            public Object construct() {
                try {
                    SimpleEntryInformation new_entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
                    Entry entry = new Entry(EntryFileDialog.getEntryFromFile(null, new FileDocument(new File(filename)), new_entry_information, false));
                    if (entry == null) {
                        return null;
                    }
                    SimpleEntryGroup entry_group = new SimpleEntryGroup(entry.getBases());
                    entry_group.add(entry);
                    this.entry_edit = new EntryEdit(entry_group);
                    return null;
                }
                catch (NoSequenceException e) {
                    new MessageDialog(null, "read failed: entry contains no sequence");
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(null, "read failed: one of the features in  the entry has an out of range location: " + e.getMessage());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return null;
            }

            public void finished() {
                if (this.entry_edit != null) {
                    ((Component)this.entry_edit).setVisible(true);
                }
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        InputEvent ie = e.getTriggerEvent();
        if (ie instanceof MouseEvent && ((MouseEvent)ie).isPopupTrigger()) {
            return;
        }
        if (this.isFileSelection()) {
            e.startDrag(DragSource.DefaultCopyDrop, this.getSelectedNode(), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            e.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        FileNode dropNode = this.getSelectedNode();
        if (dropNode == null) {
            e.rejectDrop();
            return;
        }
        if (t.isDataFlavorSupported(FileNode.FILENODE)) {
            try {
                FileNode fn = (FileNode)t.getTransferData(FileNode.FILENODE);
                fn = this.getNode(fn.getFile().getAbsolutePath());
                if (dropNode.isLeaf()) {
                    e.rejectDrop();
                    return;
                }
                String dropDir = dropNode.getFile().getAbsolutePath();
                String newFullName = dropDir + this.fs + fn.toString();
                this.renameFile(fn.getFile(), fn, newFullName);
            }
            catch (Exception ufe) {}
        } else {
            e.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            Point ploc = e.getLocation();
            TreePath ePath = this.getPathForLocation(ploc.x, ploc.y);
            if (ePath == null) {
                e.rejectDrag();
                return;
            }
            FileNode node = (FileNode)ePath.getLastPathComponent();
            if (!node.isDirectory()) {
                e.rejectDrag();
            } else {
                this.setSelectionPath(ePath);
                e.acceptDrag(3);
            }
        } else {
            e.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void autoscroll(Point location) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        int bottomEdge = rect.y + rect.height;
        int rightEdge = rect.x + rect.width;
        if (location.y - rect.y < 45 && rect.y > 0) {
            top = 45;
        }
        if (location.x - rect.x < 45 && rect.x > 0) {
            left = 45;
        }
        if (bottomEdge - location.y < 45 && bottomEdge < size.height) {
            bottom = 45;
        }
        if (rightEdge - location.x < 45 && rightEdge < size.width) {
            right = 45;
        }
        rect.x += right - left;
        rect.y += bottom - top;
        this.scrollRectToVisible(rect);
    }

    public Insets getAutoscrollInsets() {
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        this.autoscrollInsets.top = rect.y + 45;
        this.autoscrollInsets.left = rect.x + 45;
        this.autoscrollInsets.bottom = size.height - (rect.y + rect.height) + 45;
        this.autoscrollInsets.right = size.width - (rect.x + rect.width) + 45;
        return this.autoscrollInsets;
    }

    public static void main(String[] args) {
        JFrame tree_frame = new JFrame("File Manager");
        FileTree ftree = new FileTree(new File(System.getProperty("user.home")), tree_frame, null);
        JScrollPane jsp = new JScrollPane(ftree);
        tree_frame.getContentPane().add(jsp);
        tree_frame.pack();
        ((Component)tree_frame).setVisible(true);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FileTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

