/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.io.IOException;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.components.EntryActionListener;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

class ReadFeaturesActionListener
extends EntryActionListener {
    final EntrySource entry_source;

    ReadFeaturesActionListener(EntryEdit entry_edit, EntrySource entry_source, Entry destination_entry) {
        super(entry_edit, destination_entry);
        this.entry_source = entry_source;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (this.getEntry().isReadOnly()) {
                String message = "the default entry is read only - cannot continue";
                new MessageDialog(this.getEntryEdit(), "the default entry is read only - cannot continue");
            }
            Entry source_entry = this.entry_source.getEntry(this.getEntryEdit().getEntryGroup().getBases(), true);
            for (int i = 0; i < source_entry.getFeatureCount(); ++i) {
                String message;
                Feature this_feature = source_entry.getFeature(i);
                try {
                    this_feature.copyTo(this.getEntry());
                    continue;
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (EntryInformationException e) {
                    message = "couldn't move one of the features(" + this_feature.getIDString() + "): " + e.getMessage();
                    new MessageDialog(this.getEntryEdit(), message);
                    continue;
                }
                catch (ReadOnlyException e) {
                    message = "the default entry is read only - cannot continue";
                    new MessageDialog(this.getEntryEdit(), "the default entry is read only - cannot continue");
                    return;
                }
            }
        }
        catch (OutOfRangeException e) {
            new MessageDialog(this.getEntryEdit(), "read failed: one of the features in the source entry has an out of range location");
        }
        catch (IOException e) {
            new MessageDialog(this.getEntryEdit(), "read failed due to an IO error: " + e.getMessage());
        }
        catch (NullPointerException e) {
            new MessageDialog(this.getEntryEdit(), "read failed due to a null pointer error: " + ((Throwable)e).getMessage());
        }
    }
}

