/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.CanvasPanel;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.StreamQualifier;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class SelectionInfoDisplay
extends CanvasPanel
implements SelectionChangeListener {
    private EntryGroup entry_group;
    private final Selection selection;

    public SelectionInfoDisplay(EntryGroup entry_group, Selection selection) {
        this.entry_group = entry_group;
        this.selection = selection;
        this.getSelection().addSelectionChangeListener(this);
        this.getCanvas().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                SelectionInfoDisplay.this.getCanvas().setSize(SelectionInfoDisplay.this.getCanvas().getSize().width, SelectionInfoDisplay.this.getFontHeight() + 1);
                SelectionInfoDisplay.this.getCanvas().repaint();
            }

            public void componentShown(ComponentEvent e) {
                SelectionInfoDisplay.this.getCanvas().setSize(SelectionInfoDisplay.this.getCanvas().getSize().width, SelectionInfoDisplay.this.getFontHeight() + 1);
                SelectionInfoDisplay.this.getCanvas().repaint();
            }
        });
        int canvas_width = this.getCanvas().getSize().width;
        this.setBackground(Color.white);
        this.setSize(100, this.getFontHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, this.getFontHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, this.getFontHeight());
    }

    public void selectionChanged(SelectionChangeEvent event) {
        this.repaintCanvas();
    }

    public void paintCanvas(Graphics g) {
        String text;
        if (!this.isVisible()) {
            return;
        }
        FeatureVector features = this.getSelection().getAllFeatures();
        StringBuffer new_text = new StringBuffer();
        new_text.append(SelectionInfoDisplay.markerRangeText(this.getSelection(), this.entry_group));
        int base_total = 0;
        int aa_total = 0;
        boolean saw_a_non_cds = false;
        if (features.size() > 0) {
            StringBuffer feature_names = new StringBuffer();
            if (features.size() < 100) {
                if (features.size() > 1) {
                    feature_names.append("  (");
                }
                for (int i = 0; i < features.size(); ++i) {
                    Feature current_feature = features.elementAt(i);
                    base_total += current_feature.getBaseCount();
                    aa_total += current_feature.getAACount();
                    if (!current_feature.getKey().equals("CDS")) {
                        saw_a_non_cds = true;
                    }
                    if (i >= 10) continue;
                    if (i != 0) {
                        feature_names.append(' ');
                    }
                    feature_names.append(current_feature.getIDString());
                }
                if (features.size() > 10) {
                    feature_names.append("...");
                }
                if (features.size() == 1) {
                    feature_names.append("  (");
                    feature_names.append(this.getQualifierString(features.elementAt(0)));
                }
                feature_names.append(")");
            }
            if (features.size() == 1) {
                new_text.append("Selected feature:  ");
            } else {
                new_text.append(features.size() + " selected features  ");
            }
            if (features.size() < 100) {
                if (features.size() > 1) {
                    new_text.append("total bases " + base_total);
                    if (!saw_a_non_cds) {
                        new_text.append("  total amino acids " + aa_total);
                    }
                } else if (features.size() == 1) {
                    new_text.append("bases " + base_total);
                    if (!saw_a_non_cds) {
                        new_text.append("  amino acids " + aa_total);
                    }
                }
            }
            new_text.append("  ");
            new_text.append(feature_names.toString());
        }
        if ((text = new_text.toString()).length() > 0) {
            if (text.length() > 150) {
                text = text.substring(0, 150);
            }
        } else {
            text = "Nothing selected";
        }
        g.setColor(new Color(230, 230, 230));
        g.fillRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        g.setColor(Color.black);
        g.drawString(text, 2, this.getFontMaxAscent() + 1);
    }

    private String getQualifierString(Feature feature) {
        QualifierInfo qualifier_info;
        Qualifier this_qualifier;
        int i;
        QualifierVector qualifiers = feature.getQualifiers();
        Vector<Qualifier> saved_qualifiers = new Vector<Qualifier>();
        StringBuffer string_buffer = new StringBuffer();
        EntryInformation entry_information = feature.getEntry().getEntryInformation();
        for (i = 0; i < qualifiers.size(); ++i) {
            this_qualifier = qualifiers.elementAt(i);
            if (this_qualifier.getName().equals("note") || this_qualifier.getName().endsWith("_file")) {
                saved_qualifiers.addElement(this_qualifier);
                continue;
            }
            if (string_buffer.length() > 0) {
                string_buffer.append(' ');
            }
            qualifier_info = entry_information.getQualifierInfo(this_qualifier.getName());
            string_buffer.append(StreamQualifier.toString(qualifier_info, this_qualifier));
        }
        for (i = 0; i < saved_qualifiers.size(); ++i) {
            if (string_buffer.length() > 0) {
                string_buffer.append(' ');
            }
            this_qualifier = (Qualifier)saved_qualifiers.elementAt(i);
            qualifier_info = entry_information.getQualifierInfo(this_qualifier.getName());
            string_buffer.append(StreamQualifier.toString(qualifier_info, this_qualifier));
        }
        return string_buffer.toString();
    }

    static String markerRangeText(Selection current_selection, EntryGroup entry_group) {
        MarkerRange marker_range = current_selection.getMarkerRange();
        if (marker_range == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int start_pos = marker_range.getStart().getPosition();
        int end_pos = marker_range.getEnd().getPosition();
        if (marker_range.getStrand().isForwardStrand()) {
            if (start_pos == end_pos) {
                buffer.append("One selected base on forward strand: " + start_pos + "  ");
            } else {
                buffer.append(end_pos - start_pos + 1 + " selected bases on forward strand: " + start_pos + ".." + end_pos + " ");
            }
        } else if (start_pos == end_pos) {
            buffer.append("One selected base on reverse strand: " + marker_range.getStart().getPosition() + "  = complement (" + marker_range.getEnd().getRawPosition() + ") ");
        } else {
            buffer.append(end_pos - start_pos + 1 + " selected bases on reverse strand: " + marker_range.getStart().getPosition() + ".." + marker_range.getEnd().getPosition() + "  = complement (" + marker_range.getEnd().getRawPosition() + ".." + marker_range.getStart().getRawPosition() + ") ");
        }
        if (marker_range.getCount() >= 3) {
            FeatureVector features;
            Range raw_range = marker_range.getRawRange();
            try {
                features = entry_group.getFeaturesInRange(raw_range);
            }
            catch (OutOfRangeException e) {
                return "illegal marker range";
            }
            for (int i = 0; i < features.size(); ++i) {
                Feature this_feature = features.elementAt(i);
                if (!this_feature.isProteinFeature() || marker_range.isForwardMarker() != this_feature.isForwardFeature()) continue;
                String this_feature_id = this_feature.getIDString();
                Marker start_marker = marker_range.getStart();
                Marker end_marker = marker_range.getEnd();
                int start_position_in_feature = this_feature.getFeaturePositionFromMarker(start_marker);
                int start_codon_position = start_position_in_feature - this_feature.getCodonStart() + 1;
                String start_string = null;
                if (start_position_in_feature != -1 && start_codon_position % 3 == 0) {
                    start_string = "codon " + (start_codon_position / 3 + 1);
                }
                String end_string = null;
                int end_position_in_feature = this_feature.getFeaturePositionFromMarker(end_marker);
                int end_codon_position = end_position_in_feature - this_feature.getCodonStart() - 1;
                if (end_position_in_feature != -1 && start_codon_position != end_codon_position && end_codon_position % 3 == 0) {
                    end_string = "codon " + (end_codon_position / 3 + 1);
                }
                if (start_string == null && end_string == null) continue;
                buffer.append(" (");
                if (start_string != null) {
                    buffer.append(start_string);
                }
                if (start_string != null && end_string != null) {
                    buffer.append(" to ");
                }
                if (end_string != null) {
                    buffer.append(end_string);
                }
                buffer.append(" in feature " + this_feature.getIDString() + ") ");
            }
        }
        return buffer.append(" ").toString();
    }

    private Selection getSelection() {
        return this.selection;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

