/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class TextFieldSink
extends JTextField
implements DropTargetListener {
    protected static Border dropBorder = new BevelBorder(1);
    protected static Border endBorder = BorderFactory.createLineBorder(Color.black);

    public TextFieldSink(String text, int columns) {
        super(text, columns);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TextFieldSink.this.pasteText();
                    e.consume();
                }
            }
        });
        this.setDropTarget(new DropTarget(this, this));
    }

    public TextFieldSink() {
        this("", 0);
    }

    public void pasteText() {
        Clipboard c = this.getToolkit().getSystemClipboard();
        Transferable t = c.getContents(this);
        if (t == null) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(s);
            } else {
                this.getToolkit().beep();
            }
        }
        catch (UnsupportedFlavorException ex) {
            this.getToolkit().beep();
        }
        catch (IOException ex) {
            this.getToolkit().beep();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrag(3);
            this.setBorder(dropBorder);
        }
    }

    public void dragExit(DropTargetEvent e) {
        this.setBorder(null);
    }

    public void drop(DropTargetDropEvent e) {
        this.setBorder(endBorder);
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrop(3);
            try {
                String dropS = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(dropS);
                e.dropComplete(true);
            }
            catch (Exception exception) {}
        } else {
            e.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrag(3);
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

