/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.DocumentFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamFeature;
import uk.ac.sanger.artemis.io.StreamQualifier;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public abstract class PublicDBStreamFeature
extends SimpleDocumentFeature
implements DocumentFeature,
StreamFeature,
ComparableFeature {
    private static final StringBuffer qualifier_string_buffer = new StringBuffer(1500);
    private static final int KEY_FIELD_WIDTH = 16;
    private static final int KEY_START_COLUMN = 5;
    private static final int LOCATION_START_COLUMN = 21;
    private static final int LAST_COLUMN = 81;
    private static final int QUALIFIER_WRAP_LENGTH = 59;

    public PublicDBStreamFeature(Key key, Location location, QualifierVector qualifiers) {
        super(null);
        try {
            this.setKey(key);
            this.setLocation(location);
            this.setQualifiers(qualifiers);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public PublicDBStreamFeature(Feature feature) {
        super(null);
        try {
            this.setKey(feature.getKey());
            this.setLocation(feature.getLocation());
            this.setQualifiers(feature.getQualifiers());
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public synchronized void writeToStream(Writer writer) throws IOException {
        this.writeKey(writer);
        this.writeLocation(writer);
        this.writeQualifiers(writer);
    }

    protected static PublicDBStreamFeature readFromStream(LinePushBackReader stream, int feature_type) throws IOException {
        PublicDBStreamFeature new_feature = feature_type == 3 ? new EmblStreamFeature() : new GenbankStreamFeature();
        try {
            super.setFromStream(stream);
        }
        catch (EOFException e) {
            return null;
        }
        return new_feature;
    }

    private void setFromStream(LinePushBackReader in_stream) throws IOException {
        QualifierVector qualifiers;
        Location location;
        String line;
        String first_line = in_stream.readLine();
        if (first_line == null) {
            throw new EOFException("while reading a feature");
        }
        int line_type = LineGroup.getLineType(first_line);
        if (this instanceof EmblStreamFeature && line_type != 3 || this instanceof GenbankStreamFeature && line_type != 5) {
            in_stream.pushBack(first_line);
            throw new EOFException("end of feature table");
        }
        if (first_line.length() < 15) {
            throw new ReadFormatException("line too short", in_stream.getLineNumber());
        }
        String key_string = PublicDBStreamFeature.getKeyStringFromLine(first_line, in_stream.getLineNumber());
        if (key_string == null) {
            throw new ReadFormatException("expected the first line of a feature", in_stream.getLineNumber());
        }
        boolean location_string_finished = false;
        String location_string = PublicDBStreamFeature.getRestOfFeatureLine(first_line);
        qualifier_string_buffer.setLength(0);
        int qualifier_start_line = -1;
        int feature_start_line = in_stream.getLineNumber();
        while ((line = in_stream.readLine()) != null) {
            int current_line_type = LineGroup.getLineType(line);
            if (this instanceof EmblStreamFeature && current_line_type == 3 || this instanceof GenbankStreamFeature && current_line_type == 5) {
                if (PublicDBStreamFeature.getKeyStringFromLine(line, in_stream.getLineNumber()) == null) {
                    String rest_of_line = PublicDBStreamFeature.getRestOfFeatureLine(line);
                    if (rest_of_line == null) {
                        throw new ReadFormatException("line too short while reading feature", in_stream.getLineNumber());
                    }
                    if (location_string_finished) {
                        int qualifier_string_length = qualifier_string_buffer.length();
                        char last_char = qualifier_string_buffer.charAt(qualifier_string_length - 1);
                        if (last_char != '\"') {
                            qualifier_string_buffer.append(" ");
                        }
                        qualifier_string_buffer.append(rest_of_line);
                        continue;
                    }
                    if (rest_of_line.startsWith("/")) {
                        location_string_finished = true;
                        qualifier_string_buffer.append(rest_of_line);
                        qualifier_start_line = in_stream.getLineNumber();
                        continue;
                    }
                    location_string = location_string + rest_of_line;
                    continue;
                }
                in_stream.pushBack(line);
                break;
            }
            in_stream.pushBack(line);
            break;
        }
        Key key = new Key(key_string);
        try {
            location = new Location(location_string);
        }
        catch (LocationParseException exception) {
            String new_error_string = exception.getMessage();
            throw new ReadFormatException(new_error_string, feature_start_line);
        }
        String qualifier_string = qualifier_string_buffer.toString();
        try {
            qualifiers = PublicDBStreamFeature.getQualifiersFromString(qualifier_string, this.getEntryInformation());
        }
        catch (QualifierParseException exception) {
            String new_error_string = exception.getMessage();
            throw new ReadFormatException(new_error_string, feature_start_line);
        }
        try {
            this.set(key, location, qualifiers);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.setDirtyFlag();
    }

    private static String getRestOfFeatureLine(String line) {
        if (line.length() < 21) {
            return null;
        }
        return line.substring(21).trim();
    }

    private static String getKeyStringFromLine(String line_string, int line_number) throws ReadFormatException {
        String rest_of_line = LineGroup.getRestOfLine(line_string);
        if (rest_of_line == null || rest_of_line.startsWith(" ")) {
            return null;
        }
        if (rest_of_line.length() < 16) {
            return null;
        }
        if (rest_of_line.charAt(15) != ' ') {
            throw new ReadFormatException("column 21 must be empty", line_number);
        }
        String key_field = rest_of_line.substring(0, 15);
        return key_field.trim();
    }

    public static QualifierVector readQualifiers(Reader in_stream, EntryInformation entry_information) throws QualifierParseException, IOException {
        String name;
        QualifierVector return_vector = new QualifierVector();
        BufferedReader buffered_reader = new BufferedReader(in_stream);
        while ((name = StreamQualifier.readName(buffered_reader)) != null) {
            String value;
            buffered_reader.mark(1);
            int next_char = buffered_reader.read();
            if (next_char == -1) {
                value = null;
            } else if (next_char == 61) {
                value = StreamQualifier.readValue(buffered_reader);
            } else {
                value = null;
                buffered_reader.reset();
            }
            Qualifier new_qualifier = value == null ? new Qualifier(name) : StreamQualifier.makeStreamQualifier(name, value, entry_information);
            return_vector.addQualifierValues(new_qualifier);
        }
        return return_vector;
    }

    private static QualifierVector getQualifiersFromString(String qual_string, EntryInformation entry_information) throws QualifierParseException {
        QualifierVector qualifiers;
        StringReader string_reader = new StringReader(qual_string);
        try {
            qualifiers = PublicDBStreamFeature.readQualifiers(string_reader, entry_information);
        }
        catch (IOException exception) {
            throw new QualifierParseException(exception.getMessage());
        }
        string_reader.close();
        return qualifiers;
    }

    private void writeKey(Writer writer) throws IOException {
        if (this instanceof EmblStreamFeature) {
            writer.write("FT   " + this.getKey());
        } else {
            writer.write("     " + this.getKey());
        }
        StringBuffer spaces = new StringBuffer(20);
        for (int i = 0; i < 16 - this.getKey().length(); ++i) {
            spaces.append(' ');
        }
        writer.write(spaces.toString());
    }

    private void writeLocation(Writer writer) throws IOException {
        block5: {
            if (this.getEntryInformation().useEMBLFormat()) {
                String location_string = this.getLocation().toString();
                while (true) {
                    int wrap_position;
                    if ((wrap_position = this.getWrapPosition(location_string, ',', 59)) == -1) {
                        writer.write(location_string);
                        writer.write("\n");
                        break block5;
                    }
                    writer.write(location_string.substring(0, wrap_position + 1));
                    if (this instanceof EmblStreamFeature) {
                        writer.write("\nFT                   ");
                    } else {
                        writer.write("\n                     ");
                    }
                    location_string = location_string.substring(wrap_position + 1);
                }
            }
            String location_string = this.getLocation().toStringShort();
            writer.write(location_string);
            writer.write("\n");
        }
    }

    private void writeQualifiers(Writer writer) throws IOException {
        for (int i = 0; i < this.getQualifiers().size(); ++i) {
            Qualifier current_qualifier = this.getQualifiers().elementAt(i);
            String qualifier_name = current_qualifier.getName();
            EntryInformation entry_information = this.getEntryInformation();
            QualifierInfo qualifier_info = entry_information.getQualifierInfo(current_qualifier.getName());
            StringVector qualifier_strings = StreamQualifier.toStringVector(qualifier_info, current_qualifier);
            block1: for (int value_index = 0; value_index < qualifier_strings.size(); ++value_index) {
                int wrap_position;
                String qualifier_string = qualifier_strings.elementAt(value_index);
                do {
                    wrap_position = this.getWrapPosition(qualifier_string, ' ', 59);
                    if (entry_information.useEMBLFormat() && (wrap_position == -1 || wrap_position > 59) && qualifier_string.length() > 59) {
                        wrap_position = 59;
                    }
                    String this_string = wrap_position == -1 ? qualifier_string : qualifier_string.substring(0, wrap_position);
                    if (this instanceof EmblStreamFeature) {
                        writer.write("FT                   ");
                        writer.write(this_string);
                        writer.write("\n");
                    } else {
                        writer.write("                     ");
                        writer.write(this_string);
                        writer.write("\n");
                    }
                    if (wrap_position == -1) continue block1;
                    while (wrap_position < qualifier_string.length() && qualifier_string.charAt(wrap_position) == ' ') {
                        ++wrap_position;
                    }
                } while ((qualifier_string = qualifier_string.substring(wrap_position)).length() != 0);
            }
        }
    }

    private int getWrapPosition(String string_to_wrap, char wrap_character, int line_length) {
        if (string_to_wrap.length() < line_length) {
            return -1;
        }
        int wrap_char_index = string_to_wrap.substring(0, line_length).lastIndexOf(wrap_character);
        if (wrap_char_index == -1) {
            return string_to_wrap.indexOf(wrap_character);
        }
        return wrap_char_index;
    }
}

