/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;

public class QualifierInfo {
    public static final int QUOTED_TEXT = 1;
    public static final int TEXT = 2;
    public static final int NO_VALUE = 3;
    public static final int OPTIONAL_QUOTED_TEXT = 4;
    public static final int ANY = 5;
    public static final int UNKNOWN = 0;
    private static final String[] possible_type_strings = new String[]{"\"text\"", "text", "\"list\"", "\"opt\"", "(::)", "EC", "feature", "list", "location", "modbase", "none", "number", "real", "ref", "item"};
    private String name;
    private int type;
    private KeyVector keys = null;
    private KeyVector required_keys = null;
    private boolean once_only;

    public QualifierInfo(String name, int type, KeyVector keys, KeyVector required_keys, boolean once_only) {
        this.name = name;
        this.type = type;
        this.once_only = once_only;
        if (keys != null) {
            this.keys = keys.copy();
        }
        if (required_keys != null) {
            this.required_keys = required_keys.copy();
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidFor(Key key) {
        if (this.keys == null) {
            return true;
        }
        return this.keys.contains(key);
    }

    public boolean isRequiredFor(Key key) {
        if (this.required_keys == null) {
            return false;
        }
        return this.required_keys.contains(key);
    }

    public KeyVector getValidKeys() {
        return this.keys;
    }

    public KeyVector getRequiredKeys() {
        return this.required_keys;
    }

    public boolean isOnceOnly() {
        return this.once_only;
    }

    public static int getQualifierTypeID(String type_string) {
        for (int i = 0; i < possible_type_strings.length; ++i) {
            String this_type_string = possible_type_strings[i];
            if (!this_type_string.equals(type_string)) continue;
            if (type_string.equals("\"text\"") || type_string.equals("\"list\"")) {
                return 1;
            }
            if (type_string.equals("text")) {
                return 2;
            }
            if (type_string.equals("none")) {
                return 3;
            }
            if (type_string.equals("\"opt\"")) {
                return 4;
            }
            return 2;
        }
        throw new Error("unknown type string: " + type_string);
    }
}

