/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

abstract class SimpleDocumentFeature
extends LineGroup
implements Feature {
    private static long id_counter = 0L;
    private DocumentEntry entry;
    private Key key;
    private Location location;
    private QualifierVector qualifiers = new QualifierVector();
    private int first_base = -1;
    private int last_base = -1;
    private final long id = id_counter++;

    public SimpleDocumentFeature(DocumentEntry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    protected void setDirtyFlag() {
        if (this.getEntry() != null) {
            this.getDocumentEntry().setDirtyFlag();
        }
    }

    public DocumentEntry getDocumentEntry() {
        return this.entry;
    }

    public boolean isReadOnly() {
        return this.getEntry() != null && this.getEntry().isReadOnly();
    }

    private void setEntry(DocumentEntry entry) {
        this.entry = entry;
    }

    protected void setDocumentEntry(DocumentEntry entry) throws ReadOnlyException {
        this.setEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Key key, Location location, QualifierVector qualifiers) throws EntryInformationException, OutOfRangeException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        if (key == null) {
            Key key_to_test = this.key;
        } else {
            Key key_to_test = key;
        }
        if (qualifiers == null) {
            QualifierVector qualifiers_to_test = this.qualifiers;
        } else {
            QualifierVector qualifiers_to_test = qualifiers;
        }
        Entry saved_entry = this.getEntry();
        try {
            if (saved_entry != null) {
                saved_entry.remove(this);
            }
            if (key != null) {
                this.key = key;
            }
            if (qualifiers != null) {
                this.qualifiers = qualifiers;
            }
            if (location != null) {
                this.setLocation(location);
            }
            this.setDirtyFlag();
            Object var8_9 = null;
            if (saved_entry == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (saved_entry == null) throw throwable;
            try {
                saved_entry.add(this);
                throw throwable;
            }
            catch (EntryInformationException e) {
                saved_entry.forcedAdd(this);
                throw new Error("internal error (feature key change may have been lost) - unexpected exception: " + e);
            }
        }
        try {
            saved_entry.add(this);
            return;
        }
        catch (EntryInformationException e) {
            saved_entry.forcedAdd(this);
            throw new Error("internal error (feature key change may have been lost) - unexpected exception: " + e);
        }
    }

    private void set(DocumentEntry entry, Key key, Location location, QualifierVector qualifiers) throws EntryInformationException, ReadOnlyException {
        this.setDocumentEntry(entry);
        this.setKey(key);
        this.first_base = -1;
        this.last_base = -1;
        this.location = location;
        this.setQualifiers(qualifiers);
        this.setDirtyFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setKey(Key key) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        for (int i = 0; i < this.qualifiers.size(); ++i) {
            String this_name = this.qualifiers.elementAt(i).getName();
            if (this.getEntryInformation().isValidQualifier(key, this_name)) continue;
            String message = key + " cannot have /" + this.qualifiers.elementAt(i).getName() + " as a qualifier";
            throw new InvalidRelationException(message, key, this.qualifiers.elementAt(i));
        }
        Entry saved_entry = this.getEntry();
        try {
            if (saved_entry != null) {
                saved_entry.remove(this);
            }
            this.key = key;
            this.setDirtyFlag();
            Object var6_6 = null;
            if (saved_entry == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (saved_entry == null) throw throwable;
            try {
                saved_entry.add(this);
                throw throwable;
            }
            catch (EntryInformationException e) {
                saved_entry.forcedAdd(this);
                throw new Error("internal error (feature key change may have been lost) - unexpected exception: " + e);
            }
        }
        try {
            saved_entry.add(this);
            return;
        }
        catch (EntryInformationException e) {
            saved_entry.forcedAdd(this);
            throw new Error("internal error (feature key change may have been lost) - unexpected exception: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLocation(Location location) throws ReadOnlyException, OutOfRangeException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        Entry saved_entry = this.getEntry();
        try {
            if (saved_entry != null) {
                saved_entry.remove(this);
            }
            this.location = location;
            this.setDirtyFlag();
            this.first_base = -1;
            this.last_base = -1;
            Object var4_3 = null;
            if (saved_entry == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (saved_entry == null) throw throwable;
            try {
                saved_entry.add(this);
                throw throwable;
            }
            catch (EntryInformationException e) {
                saved_entry.forcedAdd(this);
                this.first_base = -1;
                this.last_base = -1;
                throw new Error("internal error (some feature qualifiers may have been lost) - unexpected exception: " + e);
            }
        }
        try {
            saved_entry.add(this);
            return;
        }
        catch (EntryInformationException e) {
            saved_entry.forcedAdd(this);
            this.first_base = -1;
            this.last_base = -1;
            throw new Error("internal error (some feature qualifiers may have been lost) - unexpected exception: " + e);
        }
    }

    public void setQualifiers(QualifierVector qualifiers) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        if (qualifiers == null) {
            this.qualifiers = new QualifierVector();
        } else {
            for (int i = 0; i < qualifiers.size(); ++i) {
                String this_name = qualifiers.elementAt(i).getName();
                if (this.getEntryInformation().isValidQualifier(this.getKey(), this_name)) continue;
                String message = this.getKey() + " cannot have /" + qualifiers.elementAt(i).getName() + " as a qualifier";
                throw new InvalidRelationException(message, this.getKey(), qualifiers.elementAt(i));
            }
            this.qualifiers = qualifiers.copy();
        }
        this.setDirtyFlag();
    }

    public void setQualifier(Qualifier qualifier) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.getQualifiers().setQualifier(qualifier);
        this.setDirtyFlag();
    }

    public void removeQualifierByName(String name) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.getQualifiers().removeQualifierByName(name);
        this.setDirtyFlag();
    }

    public Qualifier addQualifierValues(Qualifier qualifier) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() != null && this.getEntry().isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.setDirtyFlag();
        return this.getQualifiers().addQualifierValues(qualifier);
    }

    public long getNumericID() {
        return this.id;
    }

    public Key getKey() {
        return this.key;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getFirstBase() {
        if (this.first_base == -1) {
            this.first_base = this.getLocation().getFirstBase();
        }
        return this.first_base;
    }

    public int getLastBase() {
        if (this.last_base == -1) {
            this.last_base = this.getLocation().getLastBase();
        }
        return this.last_base;
    }

    public QualifierVector getQualifiers() {
        return this.qualifiers;
    }

    public Qualifier getQualifierByName(String name) {
        return this.getQualifiers().getQualifierByName(name);
    }

    public EntryInformation getEntryInformation() {
        if (this.getEntry() == null) {
            return SimpleEntryInformation.getDefaultEntryInformation();
        }
        return this.getEntry().getEntryInformation();
    }

    public abstract Feature copy();
}

