/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import uk.ac.sanger.artemis.sequence.BasePatternFormatException;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.MarkerRangeVector;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class BasePattern {
    private static int ILLEGAL_PATTERN = -1;
    private static int SIMPLE_PATTERN = 0;
    private static int IUC_PATTERN = 1;
    final String pattern_string;
    final int pattern_type;

    public BasePattern(String pattern_string) throws BasePatternFormatException {
        if (pattern_string.length() < 1) {
            throw new BasePatternFormatException("pattern too short");
        }
        this.pattern_string = pattern_string.toLowerCase();
        this.pattern_type = BasePattern.patternType(this.pattern_string);
        if (this.pattern_type == ILLEGAL_PATTERN) {
            throw new BasePatternFormatException("illegal characters in pattern");
        }
    }

    public String toString() {
        return this.pattern_string;
    }

    public boolean matches(String match_string) {
        return match_string.length() == this.pattern_string.length() && this.searchFor(match_string, 0) == 0;
    }

    public MarkerRange findMatch(Bases bases, Marker search_start_marker, int search_end_position, boolean search_backwards) {
        Strand match_strand;
        int match_last_base;
        int match_first_base;
        int complement_search_start_index;
        int forward_search_start_index;
        String bases_string = bases.toString();
        if (search_backwards) {
            if (search_start_marker == null) {
                forward_search_start_index = bases.getLength() - 1;
                complement_search_start_index = bases.getLength() - 1;
            } else {
                complement_search_start_index = search_start_marker.getRawPosition() - 2;
                forward_search_start_index = search_start_marker.getStrand().isForwardStrand() ? search_start_marker.getRawPosition() - 2 : search_start_marker.getRawPosition() - 1;
            }
        } else if (search_start_marker == null) {
            forward_search_start_index = 0;
            complement_search_start_index = 0;
        } else {
            forward_search_start_index = search_start_marker.getRawPosition();
            complement_search_start_index = search_start_marker.getStrand().isForwardStrand() ? search_start_marker.getRawPosition() - 1 : search_start_marker.getRawPosition();
        }
        int forward_search_result = this.searchFor(bases_string, this.pattern_string, forward_search_start_index, search_backwards);
        int complement_search_result = this.searchFor(bases_string, Bases.reverseComplement(this.pattern_string), complement_search_start_index, search_backwards);
        if (forward_search_result == -1 && complement_search_result == -1) {
            return null;
        }
        if (search_backwards) {
            if (complement_search_result != -1 && (forward_search_result == -1 || forward_search_result != -1 && complement_search_result >= forward_search_result)) {
                match_first_base = bases.getComplementPosition(complement_search_result + 1);
                match_last_base = match_first_base - (this.pattern_string.length() - 1);
                match_strand = bases.getReverseStrand();
            } else {
                match_first_base = forward_search_result + 1;
                match_last_base = match_first_base + this.pattern_string.length() - 1;
                match_strand = bases.getForwardStrand();
            }
        } else if (forward_search_result != -1 && (complement_search_result == -1 || complement_search_result != -1 && forward_search_result <= complement_search_result)) {
            match_first_base = forward_search_result + 1;
            match_last_base = match_first_base + this.pattern_string.length() - 1;
            match_strand = bases.getForwardStrand();
        } else {
            match_first_base = bases.getComplementPosition(complement_search_result + 1);
            match_last_base = match_first_base - (this.pattern_string.length() - 1);
            match_strand = bases.getReverseStrand();
        }
        if (match_last_base > search_end_position) {
            return null;
        }
        try {
            return new MarkerRange(match_strand, match_first_base, match_last_base);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public MarkerRangeVector findMatches(Bases bases, Marker search_start_marker, int search_end_position) {
        MarkerRange new_match_position;
        MarkerRangeVector return_vector = new MarkerRangeVector();
        Marker current_position_marker = search_start_marker;
        while ((new_match_position = this.findMatch(bases, current_position_marker, search_end_position, false)) != null) {
            current_position_marker = new_match_position.getRawStart();
            return_vector.add(new_match_position);
        }
        return return_vector;
    }

    public int searchFor(String bases_string, int start_index) {
        return this.searchFor(bases_string, this.pattern_string, start_index, false);
    }

    private int searchFor(String bases_string, String pattern_string, int start_index, boolean search_backwards) {
        if (search_backwards) {
            if (this.pattern_type == SIMPLE_PATTERN) {
                return bases_string.lastIndexOf(pattern_string, start_index);
            }
            if (bases_string.length() - start_index < this.toString().length()) {
                start_index = bases_string.length() - this.toString().length();
            }
            for (int i = start_index; i > 0; --i) {
                boolean match_failed = false;
                for (int pattern_index = 0; pattern_index < pattern_string.length(); ++pattern_index) {
                    if (this.charMatch(bases_string.charAt(i + pattern_index), pattern_string.charAt(pattern_index))) continue;
                    match_failed = true;
                    break;
                }
                if (match_failed) continue;
                return i;
            }
        } else {
            if (this.pattern_type == SIMPLE_PATTERN) {
                return bases_string.indexOf(pattern_string, start_index);
            }
            for (int i = start_index; i < bases_string.length() - pattern_string.length() + 1; ++i) {
                boolean match_failed = false;
                for (int pattern_index = 0; pattern_index < pattern_string.length(); ++pattern_index) {
                    if (this.charMatch(bases_string.charAt(i + pattern_index), pattern_string.charAt(pattern_index))) continue;
                    match_failed = true;
                    break;
                }
                if (match_failed) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean charMatch(char base_char, char pattern_char) {
        switch (base_char) {
            case 'c': {
                switch (pattern_char) {
                    case 'b': 
                    case 'c': 
                    case 'h': 
                    case 'm': 
                    case 'n': 
                    case 's': 
                    case 'v': 
                    case 'y': {
                        return true;
                    }
                }
                break;
            }
            case 't': {
                switch (pattern_char) {
                    case 'b': 
                    case 'd': 
                    case 'h': 
                    case 'k': 
                    case 'n': 
                    case 't': 
                    case 'w': 
                    case 'y': {
                        return true;
                    }
                }
                break;
            }
            case 'a': {
                switch (pattern_char) {
                    case 'a': 
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 'n': 
                    case 'r': 
                    case 'v': 
                    case 'w': {
                        return true;
                    }
                }
                break;
            }
            case 'g': {
                switch (pattern_char) {
                    case 'b': 
                    case 'd': 
                    case 'g': 
                    case 'k': 
                    case 'n': 
                    case 'r': 
                    case 's': 
                    case 'v': {
                        return true;
                    }
                }
                break;
            }
            default: {
                if (pattern_char != 'n') break;
                return true;
            }
        }
        return false;
    }

    private static int patternType(String pattern_string) {
        boolean seen_iuc = false;
        block4: for (int i = 0; i < pattern_string.length(); ++i) {
            switch (pattern_string.charAt(i)) {
                case 'b': 
                case 'd': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 'n': 
                case 'r': 
                case 's': 
                case 'v': 
                case 'w': 
                case 'y': {
                    seen_iuc = true;
                    continue block4;
                }
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': {
                    continue block4;
                }
                default: {
                    return ILLEGAL_PATTERN;
                }
            }
        }
        if (seen_iuc) {
            return IUC_PATTERN;
        }
        return SIMPLE_PATTERN;
    }
}

