/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class FastVector {
    private static final int INITIAL_CAPACITY = 20;
    private ArrayList vector = new ArrayList();
    private HashMap table = new HashMap(20);

    public void add(Object object) {
        if (object == null) {
            throw new Error("internal error - adding a null object");
        }
        if (this.contains(object)) {
            throw new Error("internal error - object added a second time");
        }
        this.vector.add(object);
        this.table.put(object, object);
    }

    public Object elementAt(int index) {
        return this.vector.get(index);
    }

    public Object lastElement() {
        return this.vector.get(this.vector.size() - 1);
    }

    public boolean remove(Object object) {
        if (this.contains(object)) {
            ((AbstractCollection)this.vector).remove(object);
            if (this.table.remove(object) == null) {
                throw new Error("internal error - remove could not find target");
            }
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.table.containsKey(object);
    }

    public int indexOf(Object object) {
        if (!this.contains(object)) {
            return -1;
        }
        return this.vector.indexOf(object);
    }

    public int size() {
        return this.vector.size();
    }

    public void removeAllElements() {
        this.vector.clear();
        this.table.clear();
    }

    public void removeElementAt(int index) {
        Object object = this.vector.remove(index);
        this.table.remove(object);
    }

    public final void insertElementAt(Object object, int index) {
        this.vector.add(index, object);
        this.table.put(object, object);
    }

    public void insertElementAfter(Object old_object, Object new_object) {
        int old_object_index = this.indexOf(old_object);
        if (old_object_index == -1) {
            this.insertElementAt(new_object, 0);
        } else {
            this.insertElementAt(new_object, old_object_index + 1);
        }
        this.table.put(new_object, new_object);
    }

    public void setElementAt(Object object, int index) {
        this.removeElementAt(index);
        this.insertElementAt(object, index);
    }

    public Object clone() {
        FastVector return_vector = new FastVector();
        return_vector.vector = (ArrayList)this.vector.clone();
        return_vector.table = (HashMap)this.table.clone();
        return return_vector;
    }

    public FastVector sort(Comparator cmp) {
        FastVector return_vector = (FastVector)this.clone();
        Collections.sort(return_vector.vector, cmp);
        return return_vector;
    }
}

