/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.ProgressInputStream;
import uk.ac.sanger.artemis.util.WorkingGZIPInputStream;

public class FileDocument
extends Document {
    public FileDocument(File location) {
        super(location);
    }

    public Document append(String name) throws IOException {
        return new FileDocument(new File(this.getFile(), name));
    }

    public String getName() {
        return this.getFile().getName();
    }

    public Document getParent() {
        try {
            File canonical_file = new File(this.getFile().getCanonicalPath());
            return new FileDocument(new File(canonical_file.getParent()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean readable() {
        return this.getFile().exists() && this.getFile().canRead();
    }

    public boolean writable() {
        return this.getFile().exists() && this.getFile().canWrite();
    }

    public InputStream getInputStream() throws IOException {
        File read_file = (File)this.getLocation();
        ProgressInputStream file_input_stream = new ProgressInputStream(new FileInputStream(read_file), this.getProgressListeners());
        if (read_file.getName().endsWith(".gz")) {
            return new WorkingGZIPInputStream(file_input_stream);
        }
        return file_input_stream;
    }

    public OutputStream getOutputStream() throws IOException {
        File write_file = (File)this.getLocation();
        FileOutputStream file_output_stream = new FileOutputStream(write_file);
        if (write_file.getName().endsWith(".gz")) {
            return new GZIPOutputStream(file_output_stream);
        }
        return file_output_stream;
    }

    public File getFile() {
        return (File)this.getLocation();
    }
}

