/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.sanger.artemis.util.InputStreamProgressEvent;
import uk.ac.sanger.artemis.util.InputStreamProgressListenerVector;

public class ProgressInputStream
extends FilterInputStream {
    private final InputStreamProgressListenerVector listeners;
    private int byte_count = 0;
    private int last_count = 0;

    public ProgressInputStream(InputStream input_stream, InputStreamProgressListenerVector listeners) {
        super(input_stream);
        this.listeners = listeners;
    }

    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result > 0) {
            this.byte_count += b.length;
            this.maybeFireEvent();
        } else if (result == -1) {
            InputStreamProgressEvent event = new InputStreamProgressEvent(-1);
            this.fireEvent(event);
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.byte_count += b.length;
            this.maybeFireEvent();
        } else if (result == -1) {
            InputStreamProgressEvent event = new InputStreamProgressEvent(-1);
            this.fireEvent(event);
        }
        return result;
    }

    public void close() throws IOException {
        super.close();
        InputStreamProgressEvent event = new InputStreamProgressEvent(-1);
        this.fireEvent(event);
    }

    private void maybeFireEvent() {
        int char_count;
        if (this.byte_count > 50000 && this.last_count + 10000 < (char_count = this.byte_count / 10000 * 10000)) {
            this.fireEvent(new InputStreamProgressEvent(char_count));
            this.last_count = char_count;
        }
    }

    private void fireEvent(InputStreamProgressEvent event) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.elementAt(i).progressMade(event);
            }
        }
    }
}

