/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import uk.ac.sanger.jcon.dao.ExecutableDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.Executable;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.JobBatchImpl;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.protocol.AbstractProtocol;
import uk.ac.sanger.jcon.util.Configuration;

abstract class ConfigurableProtocol
extends AbstractProtocol {
    public static final String VELOCITY_PROPS = "/velocity.properties";
    public static final String LOG_TAG = "CMD_TMPL_GEN";
    static ResourceBundle resource = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$protocol$ConfigurableProtocol == null ? (class$uk$ac$sanger$jcon$protocol$ConfigurableProtocol = ConfigurableProtocol.class$("uk.ac.sanger.jcon.protocol.ConfigurableProtocol")) : class$uk$ac$sanger$jcon$protocol$ConfigurableProtocol).getName());
    protected Configuration config;
    private ExecutableDAO execDAO;
    private StatusDAO statusDAO;
    private VelocityEngine vEngine;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$protocol$ConfigurableProtocol;

    ConfigurableProtocol() throws Exception {
        this.execDAO = this.jobControl.createExecutableDAO();
        this.statusDAO = this.jobControl.createStatusDAO();
        this.config = new Configuration(resource);
        Properties velocityProps = new Properties();
        velocityProps.load(this.getClass().getResourceAsStream(VELOCITY_PROPS));
        this.vEngine = new VelocityEngine();
        this.vEngine.init(velocityProps);
    }

    Job createJob(String[] baseNames, String organismAlias, String execAlias) throws Exception {
        Job job = this._createJob(baseNames, organismAlias, execAlias);
        job.setCommandTemplate(this.config.getTemplate(organismAlias, execAlias));
        return job;
    }

    Job createJob(String[] baseNames, VelocityContext context, String organismAlias, String execAlias) throws Exception {
        Job job = this._createJob(baseNames, organismAlias, execAlias);
        String template = this.config.getTemplate(organismAlias, execAlias);
        StringWriter writer = new StringWriter(256);
        this.vEngine.evaluate((Context)context, (Writer)writer, LOG_TAG, template);
        job.setCommandTemplate(writer.toString());
        return job;
    }

    private Job _createJob(String[] baseNames, String organismAlias, String execAlias) throws Exception {
        int taxId = this.config.getTaxonomyId(organismAlias);
        int execId = this.config.getExecutableId(execAlias);
        Executable exec = this.execDAO.readExecutableById(execId);
        Status waiting = this.statusDAO.readStatusById(1);
        String queueName = this.config.getString(Configuration.EXEC_QUEUE_KEY);
        JobBatchImpl job = new JobBatchImpl(exec);
        job.setStatus(waiting);
        job.setQueue(queueName);
        if (baseNames[0] != null) {
            job.setInputName(baseNames[0]);
        }
        if (baseNames[1] != null) {
            job.setOutputName(baseNames[1]);
        }
        if (baseNames[2] != null) {
            job.setErrorName(baseNames[2]);
        }
        return job;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

