#!/usr/bin/perl
# mergefiles - perl script that joins the informations of all tab delimited files.
#
#
# Written by: Siomar C. Soares, Federal University of Minas Gerais (UFMG), 
#   Laboratory of Celular and Molecular Genetics, Brazil
# Acknowledgments: This script was developed with the help of:
#   Romel T. J. Ramos, Federal University of Pará (UFPA),
#   Laboratory of DNA polimorfisms, Brazil.
# 
#
# Date Written: Sep 27, 2010

my %hash1;
my %hash2;
my %hash3;
my $vf = $ARGV[0];
LoadFile(\%hash1,$ARGV[1]);
LoadFile(\%hash2,$ARGV[2]);
LoadFile(\%hash3,$ARGV[3]);

if (open (IN, "$vf")) {
	while ($line = <IN>) {
		$line =~ s/\>//;
		$key = $line;
		$info = $line; 
		$key =~ s/\t.+\n//;
		$info =~ s/$key\t//;
		chomp ($key);
		chomp ($info);
		$chave = $key;
		if (%hash2->{$chave} eq "") {%hash2->{$chave} = "Pseudogene"}
 		print $key."\t".%hash1->{$chave}."\t".%hash2->{$chave}."\t".%hash3->{$chave}."\t".$info."\n";}
}




sub LoadFile{
  my ($hash,$arquivo)=@_;
  my $arq;
  my $chave;
  my $resto;
  open($arq,"<",$arquivo);
  $lines = readline($arq);
  while ($lines){
   $lines =~ s/\>//;
   $chave = $lines;   
   $chave =~ s/\t.+\n//;
   $resto = $lines;
   $resto =~ s/$chave\t//g;
   chomp($resto);
   chomp($chave);
   $hash->{$chave}= $resto;
   $lines = readline($arq);
  }
}

