#!/usr/bin/perl
# trna2embl - perl script that converts the result from tRNAscan-SE into
#a the tab delimited file to be used on Artemis: Annotation tool.
#
# Written by: Siomar C. Soares, Federal University of Minas Gerais (UFMG), 
#   Laboratory of Celular and Molecular Genetics, Brazil
#
# Date Written: Sep 27, 2010

$teste = shift;
open (TEXTO, "$teste");
@file = <TEXTO>;
close (TEXTO);
$tab='';
if (!defined $teste) { 
        die "Usage: $0 tRNAscan.out\n(ex: trna2embl.pl Cp1002.tRNA.out)\n";
}
for $i(@file)
{
	@linhas=split(/\t/,$i);
	$linhas[2]=~s/[ ]//g;
	$linhas[3]=~s/[ ]//g;
	$linhas[8]=~s/\n//g;
	if ($linhas[1]=~/[0-9]/){
		if ($linhas[2]<$linhas[3]){
			$tab.="FT   tRNA            $linhas[2]\.\.$linhas[3]\nFT                   \/note=\"tRNA $linhas[4] anticodon $linhas[5], Cove score $linhas[8]\"\n";}
		else{$tab.="FT   tRNA            complement\($linhas[3]\.\.$linhas[2]\)\nFT                   \/note=\"tRNA $linhas[4] anticodon $linhas[5], Cove score $linhas[8]\"\n";}
				    }
}

$newtitle=$teste;
$newtitle.=".embl";
open (TEXTO,">$newtitle");
print TEXTO $tab;
close (TEXTO);
exit
