#!/usr/bin/perl -w
################################################################################
#
#  gff2chart.pl <gff-file>
# 
#  Prints a chart of colombos output

use strict;
use Bio::SeqIO;
use MyBioUtils;

my $WIDTH=70;

if (@ARGV < 1) {
    die "USAGE: perl gff2chart.pl <gff-file>\n";
}

my $filename = shift @ARGV;

while (@ARGV)
{
    my $option = shift @ARGV;

    if ($option =~ /(.*)=(.*)/)
    {
	if ($1 eq "width") { $WIDTH=$2; }
    }
}

open (INFILE, $filename) || die "Cannot open file \"$filename\"!\n";
print "\nCOLOMBOs Chart for $filename\n";

my %mapping = ("NORMAL" => '_',
	       "OUTNORMAL" => 'o',
	       "HIEXP" => '.',
	       "OUTHIEXP" => '.',
	       "PHX" => '.',
	       "OUTPHX" => '.',
	       "INCON" => '-',
	       "PUTAL" => '*',
	       "OUTPUTAL" => '*');
my %count;
my $zeile;
my $gene_no = 0;

while ($zeile=<INFILE>)
{ 
    if ($zeile !~ /^\#/)
    {
	my ($affil, $start_pos)  = (&MyBioUtils::get_GFF_line($zeile))[2,3];
	if ($WIDTH > 0 && $gene_no % $WIDTH == 0) {
	    printf("\n%5d%10s ", $gene_no, "[$start_pos]");
	}
	if (exists $mapping{$affil}) 
	{
	    print $mapping{$affil};
	}
	else
	{
	    print "?";
	}
	$count{$affil}++;
	$gene_no++;
    }
}

print "\n";

print "\n\nLegend:\n ".$mapping{"NORMAL"}." normal\n ";
print $mapping{"HIEXP"}." putatively highly expressed\n ".$mapping{"PUTAL"}." putatively alien\n ";
print $mapping{"INCON"}." inconspicuous/phx, but located in Genomic Island\n\n";

foreach my $key (keys(%count))
{
    printf("%-10s%s\n", $key.":", show_ratio($count{$key}, $gene_no));
}
print "\n";


sub show_ratio()
{
    my ($share, $total) = @_;

    return sprintf("%5d of%5d%8s",$share, $total, sprintf("(%.1f%%)", $share*100/$total));
}








 
