/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.BlockPainter;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;

public class BarLogoPainter
implements LogoPainter {
    public void paintLogo(LogoContext lCtxt) {
        Graphics2D g2 = lCtxt.getGraphics();
        Distribution dis = lCtxt.getDistribution();
        SymbolStyle style = lCtxt.getStyle();
        BlockPainter blockPainter = lCtxt.getBlockPainter();
        Rectangle bounds = lCtxt.getBounds();
        double width = bounds.getWidth();
        double stepWidth = width / (double)((FiniteAlphabet)dis.getAlphabet()).size();
        double height = bounds.getHeight();
        double w = 0.0;
        Iterator i = ((FiniteAlphabet)dis.getAlphabet()).iterator();
        while (i.hasNext()) {
            AtomicSymbol s = (AtomicSymbol)i.next();
            double rh = 0.0;
            try {
                rh = dis.getWeight(s) * height;
            }
            catch (IllegalSymbolException ire) {
                throw new BioError(ire, "State alphabet has changed while painting");
            }
            Rectangle2D.Double outline = new Rectangle2D.Double(bounds.getX() + w, bounds.getY() + height - rh, stepWidth, rh);
            blockPainter.paintBlock(lCtxt, outline, s);
            w += stepWidth;
        }
    }
}

