/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import org.biojava.bio.program.sax.blastxml.BlastAggregator;
import org.biojava.bio.program.sax.blastxml.BlastOutputHandler;
import org.biojava.bio.program.sax.blastxml.StAXFeatureHandler;
import org.biojava.bio.program.sax.blastxml.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class BlastXMLParser
extends StAXFeatureHandler {
    boolean firstTime = true;

    public BlastXMLParser() {
        this.staxenv = this;
        this.listener = new DefaultHandler();
    }

    public void setContentHandler(ContentHandler listener) {
        this.listener = listener;
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (this.firstTime) {
            if (localName.equals("BlastOutput")) {
                super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput"), new StAXHandlerFactory(){

                    public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                        return new BlastOutputHandler(staxenv);
                    }
                });
            } else if (localName.equals("blast_aggregate")) {
                super.addHandler(new ElementRecognizer.ByLocalName("blast_aggregate"), new StAXHandlerFactory(){

                    public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                        return new BlastAggregator(staxenv);
                    }
                });
            } else {
                throw new SAXException("illegal element " + localName);
            }
            this.firstTime = false;
            AttributesImpl bldscAttrs = new AttributesImpl();
            bldscAttrs.addAttribute("", "xmlns", "xmlns", "CDATA", "");
            bldscAttrs.addAttribute("http://www.biojava.org", "biojava", "xmlns:biojava", "CDATA", "http://www.biojava.org");
            this.listener.startElement("http://www.biojava.org", "BlastLikeDataSetCollection", "http://www.biojava.org:BlastLikeDataSetCollection", bldscAttrs);
        }
        ++this.level;
        if (this.level == 1) {
            int i = this.handlers.size() - 1;
            while (i >= 0) {
                StAXFeatureHandler.Binding b = (StAXFeatureHandler.Binding)this.handlers.get(i);
                if (b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) {
                    dm.delegate(b.handlerFactory.getHandler(this));
                    return;
                }
                --i;
            }
        }
        if (this.level == 1) {
            this.startElementHandler(nsURI, localName, qName, attrs);
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        this.listener.endElement("http://www.biojava.org", "BlastLikeDataSetCollection", "http://www.biojava.org:BlastLikeDataSetCollection");
    }
}

