/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.db.biosql.BioSQLAssembly;
import org.biojava.bio.seq.db.biosql.BioSQLChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureReceiver;
import org.biojava.bio.seq.db.biosql.BioSQLSequence;
import org.biojava.bio.seq.db.biosql.DBHelper;
import org.biojava.bio.seq.db.biosql.FeaturesSQL;
import org.biojava.bio.seq.io.OrganismParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.taxa.EbiFormat;
import org.biojava.bio.taxa.Taxon;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.JDBCConnectionPool;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.FixedSizeCache;
import org.biojava.utils.cache.WeakValueHashMap;

public class BioSQLSequenceDB
implements SequenceDB {
    private JDBCConnectionPool pool;
    private int dbid = -1;
    private String name;
    private IDMaker idmaker = new IDMaker.ByName();
    private WeakValueHashMap sequencesByName = new WeakValueHashMap();
    private WeakValueHashMap sequencesByID = new WeakValueHashMap();
    private DBHelper helper;
    private FeaturesSQL featuresSQL;
    private BioSQLChangeHub changeHub;
    private WeakValueHashMap featuresByID = new WeakValueHashMap();
    private Cache tileCache = new FixedSizeCache(10);
    Map ontologyTermCache = new HashMap();
    Map seqfeatureSourceCache = new HashMap();
    private boolean hierarchyChecked = false;
    private boolean hierarchySupported = false;
    private boolean assemblyChecked = false;
    private boolean assemblySupported = false;
    private boolean dummyChecked = false;
    private boolean dummySupported = false;
    private boolean locationQualifierChecked = false;
    private boolean locationQualifierSupported = false;
    private boolean bioentryPropertyChecked = false;
    private boolean bioentryPropertySupported = false;
    private boolean spaChecked = false;
    private boolean spaSupported = false;
    static /* synthetic */ Class class$org$biojava$bio$seq$ComponentFeature;

    JDBCConnectionPool getPool() {
        return this.pool;
    }

    DBHelper getDBHelper() {
        return this.helper;
    }

    FeaturesSQL getFeaturesSQL() {
        return this.featuresSQL;
    }

    BioSQLChangeHub getChangeHub() {
        return this.changeHub;
    }

    public BioSQLSequenceDB(String dbURL, String dbUser, String dbPass, String biodatabase, boolean create) throws BioException {
        this.helper = DBHelper.getDBHelperForURL(dbURL);
        this.pool = new JDBCConnectionPool(dbURL, dbUser, dbPass);
        if (!this.isBioentryPropertySupported()) {
            throw new BioException("This database appears to be an old (pre-Cape-Town) BioSQL.  If you need to access it, try an older BioJava snapshot");
        }
        this.featuresSQL = new FeaturesSQL(this);
        this.changeHub = new BioSQLChangeHub(this);
        try {
            Connection conn = this.pool.takeConnection();
            PreparedStatement getID = conn.prepareStatement("select * from biodatabase where name = ?");
            getID.setString(1, biodatabase);
            ResultSet rs = getID.executeQuery();
            if (rs.next()) {
                this.dbid = rs.getInt(1);
                this.name = rs.getString(2);
                getID.close();
                this.pool.putConnection(conn);
                return;
            }
            if (!create) {
                throw new BioException("Biodatabase " + biodatabase + " doesn't exist");
            }
            PreparedStatement createdb = conn.prepareStatement("insert into biodatabase (name) values ( ? )");
            createdb.setString(1, biodatabase);
            createdb.executeUpdate();
            createdb.close();
            this.dbid = this.getDBHelper().getInsertID(conn, "biodatabase", "biodatabase_id");
        }
        catch (SQLException ex) {
            throw new BioException(ex, "Error connecting to BioSQL database");
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDummySequence(String id, Alphabet alphabet, int length) throws IllegalIDException, ChangeVetoException, BioException {
        BioSQLChangeHub bioSQLChangeHub = this.changeHub;
        synchronized (bioSQLChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDBLite.SEQUENCES, null);
            this.changeHub.fireDatabasePreChange(cev);
            this._createDummySequence(id, alphabet, length);
            this.changeHub.fireDatabasePostChange(cev);
        }
    }

    private void _createDummySequence(String id, Alphabet seqAlpha, int length) throws IllegalIDException, ChangeVetoException, BioException {
        int version = 1;
        Connection conn = null;
        try {
            conn = this.pool.takeConnection();
            conn.setAutoCommit(false);
            PreparedStatement create_bioentry = conn.prepareStatement("insert into bioentry (biodatabase_id, display_id, accession, entry_version, division) values (?, ?, ?, ?, ?)");
            create_bioentry.setInt(1, this.dbid);
            create_bioentry.setString(2, id);
            create_bioentry.setString(3, id);
            create_bioentry.setInt(4, version);
            create_bioentry.setString(5, "?");
            create_bioentry.executeUpdate();
            create_bioentry.close();
            int bioentry_id = this.getDBHelper().getInsertID(conn, "bioentry", "bioentry_id");
            PreparedStatement create_dummy = conn.prepareStatement("insert into biosequence        (bioentry_id, seq_version, molecule, seq_length) values (?, ?, ?, ?)");
            create_dummy.setInt(1, bioentry_id);
            create_dummy.setInt(2, version);
            create_dummy.setString(3, seqAlpha.getName());
            create_dummy.setInt(4, length);
            create_dummy.executeUpdate();
            create_dummy.close();
            int dummy_id = this.getDBHelper().getInsertID(conn, "biosequence", "biosequence_id");
            conn.commit();
            this.pool.putConnection(conn);
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException(ex, "Error adding BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequence(Sequence seq) throws IllegalIDException, ChangeVetoException, BioException {
        BioSQLChangeHub bioSQLChangeHub = this.changeHub;
        synchronized (bioSQLChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDBLite.SEQUENCES, seq);
            this.changeHub.fireDatabasePreChange(cev);
            this._addSequence(seq);
            this.changeHub.fireDatabasePostChange(cev);
        }
    }

    private void _addSequence(Sequence seq) throws IllegalIDException, ChangeVetoException, BioException {
        SymbolTokenization seqToke;
        String seqName = this.idmaker.calcID(seq);
        int version = 1;
        Alphabet seqAlpha = seq.getAlphabet();
        try {
            seqToke = seqAlpha.getTokenization("token");
        }
        catch (Exception ex) {
            throw new BioException(ex, "Can't store sequences in BioSQL unless they can be sensibly tokenized/detokenized");
        }
        Connection conn = null;
        try {
            conn = this.pool.takeConnection();
            conn.setAutoCommit(false);
            PreparedStatement create_bioentry = conn.prepareStatement("insert into bioentry (biodatabase_id, display_id, accession, entry_version, division) values (?, ?, ?, ?, ?)");
            create_bioentry.setInt(1, this.dbid);
            create_bioentry.setString(2, seqName);
            create_bioentry.setString(3, seqName);
            create_bioentry.setInt(4, version);
            create_bioentry.setString(5, "?");
            create_bioentry.executeUpdate();
            create_bioentry.close();
            int bioentry_id = this.getDBHelper().getInsertID(conn, "bioentry", "bioentry_id");
            if (this.isAssemblySupported() && seq.filter(new FeatureFilter.ByClass(class$org$biojava$bio$seq$ComponentFeature == null ? (class$org$biojava$bio$seq$ComponentFeature = BioSQLSequenceDB.class$("org.biojava.bio.seq.ComponentFeature")) : class$org$biojava$bio$seq$ComponentFeature), false).countFeatures() > 0) {
                PreparedStatement create_assembly = conn.prepareStatement("insert into assembly        (bioentry_id, length, molecule) values (?, ?, ?)");
                create_assembly.setInt(1, bioentry_id);
                create_assembly.setInt(2, seq.length());
                create_assembly.setString(3, seqAlpha.getName());
                create_assembly.executeUpdate();
                create_assembly.close();
                int assembly_id = this.getDBHelper().getInsertID(conn, "assembly", "assembly_id");
                FeatureHolder components = seq.filter(new FeatureFilter.ByClass(class$org$biojava$bio$seq$ComponentFeature == null ? (class$org$biojava$bio$seq$ComponentFeature = BioSQLSequenceDB.class$("org.biojava.bio.seq.ComponentFeature")) : class$org$biojava$bio$seq$ComponentFeature), false);
                PreparedStatement create_fragment = conn.prepareStatement("insert into assembly_fragment        (assembly_id, fragment_name, assembly_start, assembly_end, fragment_start, fragment_end, strand) values (?,           ?,             ?,              ?,            ?,              ?,            ?)");
                Iterator i = components.features();
                while (i.hasNext()) {
                    ComponentFeature cf = (ComponentFeature)i.next();
                    if (cf.getType().equals("static_golden_path_clone")) {
                        System.err.println("Ensembl hack: skipping clone...");
                        continue;
                    }
                    create_fragment.setInt(1, assembly_id);
                    create_fragment.setString(2, cf.getComponentSequenceName());
                    create_fragment.setInt(3, cf.getLocation().getMin());
                    create_fragment.setInt(4, cf.getLocation().getMax());
                    create_fragment.setInt(5, cf.getComponentLocation().getMin());
                    create_fragment.setInt(6, cf.getComponentLocation().getMax());
                    create_fragment.setInt(7, cf.getStrand().getValue());
                    create_fragment.executeUpdate();
                }
                create_fragment.close();
            } else {
                PreparedStatement create_biosequence = conn.prepareStatement("insert into biosequence (bioentry_id, seq_version, seq_length, biosequence_str, molecule) values (?, ?, ?, ?, ?)");
                create_biosequence.setInt(1, bioentry_id);
                create_biosequence.setInt(2, version);
                create_biosequence.setInt(3, seq.length());
                create_biosequence.setString(4, seqToke.tokenizeSymbolList(seq));
                create_biosequence.setString(5, seqAlpha.getName());
                create_biosequence.executeUpdate();
                create_biosequence.close();
                int biosequence_id = this.getDBHelper().getInsertID(conn, "biosequence", "biosequence_id");
            }
            FeatureHolder features = seq;
            int num = features.countFeatures();
            if (!this.isHierarchySupported() && (features = features.filter(FeatureFilter.all, true)).countFeatures() != num) {
                System.err.println("*** Warning: feature hierarchy was lost when adding sequence to BioSQL");
            }
            this.getFeaturesSQL().persistFeatures(conn, bioentry_id, features, -1);
            Annotation ann = seq.getAnnotation();
            Iterator i = ann.asMap().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                Object key = me.getKey();
                Object value = me.getValue();
                if (key.equals(OrganismParser.PROPERTY_ORGANISM)) continue;
                this.persistBioentryProperty(conn, bioentry_id, key, value, false, true);
            }
            if (ann.containsProperty(OrganismParser.PROPERTY_ORGANISM)) {
                int taxa_id;
                Taxon taxon = (Taxon)ann.getProperty(OrganismParser.PROPERTY_ORGANISM);
                Annotation ta = taxon.getAnnotation();
                Object t = ta.getProperty(EbiFormat.PROPERTY_NCBI_TAXON);
                if (t instanceof List) {
                    t = (String)((List)t).get(0);
                }
                int taxonID = Integer.parseInt((String)t);
                PreparedStatement select_taxa = conn.prepareStatement("select taxa_id from taxa where ncbi_taxa_id = ? ");
                select_taxa.setInt(1, taxonID);
                ResultSet trs = select_taxa.executeQuery();
                if (trs.next()) {
                    taxa_id = trs.getInt(1);
                } else {
                    String name = EbiFormat.getInstance().serialize(taxon);
                    String common = taxon.getCommonName();
                    PreparedStatement create_taxa = conn.prepareStatement("insert into taxa (full_lineage, common_name, ncbi_taxa_id) values (?, ?, ?)");
                    create_taxa.setString(1, name);
                    create_taxa.setString(2, common);
                    create_taxa.setInt(3, taxonID);
                    create_taxa.executeUpdate();
                    create_taxa.close();
                    taxa_id = this.getDBHelper().getInsertID(conn, "taxa", "taxa_id");
                }
                select_taxa.close();
                PreparedStatement create_bioentry_taxa = conn.prepareStatement("insert into bioentry_taxa (bioentry_id, taxa_id) values (?, ?)");
                create_bioentry_taxa.setInt(1, bioentry_id);
                create_bioentry_taxa.setInt(2, taxa_id);
                create_bioentry_taxa.executeUpdate();
                create_bioentry_taxa.close();
            }
            conn.commit();
            this.pool.putConnection(conn);
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException(ex, "Error adding BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""));
        }
    }

    public Sequence getSequence(String id) throws BioException, IllegalIDException {
        return this.getSequence(id, -1);
    }

    Sequence getSequence(String id, int bioentry_id) throws BioException, IllegalIDException {
        Sequence seq = null;
        if (id != null) {
            seq = (Sequence)this.sequencesByName.get(id);
        } else if (bioentry_id >= 0) {
            seq = (Sequence)this.sequencesByID.get(new Integer(bioentry_id));
        } else {
            throw new BioError("Neither a name nor an internal ID was supplied");
        }
        if (seq != null) {
            return seq;
        }
        try {
            ResultSet rs;
            Connection conn = this.pool.takeConnection();
            if (bioentry_id < 0) {
                PreparedStatement get_bioentry = conn.prepareStatement("select bioentry.bioentry_id from bioentry where bioentry.accession = ? and       bioentry.biodatabase_id = ?");
                get_bioentry.setString(1, id);
                get_bioentry.setInt(2, this.dbid);
                rs = get_bioentry.executeQuery();
                if (rs.next()) {
                    bioentry_id = rs.getInt(1);
                }
                get_bioentry.close();
                if (bioentry_id < 0) {
                    this.pool.putConnection(conn);
                    throw new IllegalIDException("No bioentry with accession " + id);
                }
            } else {
                PreparedStatement get_accession = conn.prepareStatement("select bioentry.accession from bioentry where bioentry.bioentry_id = ? and bioentry.biodatabase_id = ?");
                get_accession.setInt(1, bioentry_id);
                get_accession.setInt(2, this.dbid);
                rs = get_accession.executeQuery();
                if (rs.next()) {
                    id = rs.getString(1);
                }
                get_accession.close();
                if (id == null) {
                    this.pool.putConnection(conn);
                    throw new IllegalIDException("No bioentry with internal ID " + bioentry_id);
                }
            }
            if (seq == null) {
                PreparedStatement get_biosequence = conn.prepareStatement("select biosequence_id, molecule, seq_length from   biosequence where  bioentry_id = ?");
                get_biosequence.setInt(1, bioentry_id);
                rs = get_biosequence.executeQuery();
                if (rs.next()) {
                    int biosequence_id = rs.getInt(1);
                    String molecule = rs.getString(2);
                    int length = rs.getInt(3);
                    if (rs.wasNull()) {
                        length = -1;
                    }
                    seq = new BioSQLSequence(this, id, bioentry_id, biosequence_id, molecule, length);
                }
                get_biosequence.close();
            }
            if (seq == null && this.isAssemblySupported()) {
                PreparedStatement get_assembly = conn.prepareStatement("select assembly_id, length, molecule from   assembly where  bioentry_id = ?");
                get_assembly.setInt(1, bioentry_id);
                rs = get_assembly.executeQuery();
                if (rs.next()) {
                    int assembly_id = rs.getInt(1);
                    int length = rs.getInt(2);
                    String molecule = rs.getString(3);
                    seq = new BioSQLAssembly(this, id, bioentry_id, assembly_id, molecule, length);
                }
                get_assembly.close();
            }
            this.pool.putConnection(conn);
            if (seq != null) {
                this.sequencesByName.put(id, seq);
                this.sequencesByID.put(new Integer(bioentry_id), seq);
                return seq;
            }
        }
        catch (SQLException ex) {
            throw new BioException(ex, "Error accessing BioSQL tables");
        }
        throw new BioException("BioEntry " + id + " exists with unknown sequence type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequence(String id) throws IllegalIDException, ChangeVetoException, BioException {
        BioSQLChangeHub bioSQLChangeHub = this.changeHub;
        synchronized (bioSQLChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDBLite.SEQUENCES, null);
            this.changeHub.fireDatabasePreChange(cev);
            this._removeSequence(id);
            this.changeHub.fireDatabasePostChange(cev);
        }
    }

    private void _removeSequence(String id) throws BioException, IllegalIDException, ChangeVetoException {
        Sequence seq = (Sequence)this.sequencesByName.get(id);
        if (seq != null) {
            seq = null;
            try {
                Thread.sleep(100L);
                System.gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            seq = (Sequence)this.sequencesByName.get(id);
            if (seq != null) {
                throw new BioException("There are still references to sequence with ID " + id + " from this database.");
            }
        }
        Connection conn = null;
        try {
            conn = this.pool.takeConnection();
            conn.setAutoCommit(false);
            PreparedStatement get_sequence = conn.prepareStatement("select bioentry.bioentry_id, biosequence.biosequence_id from bioentry, biosequence where bioentry.accession = ? and       biosequence.bioentry_id = bioentry.bioentry_id");
            get_sequence.setString(1, id);
            ResultSet rs = get_sequence.executeQuery();
            boolean exists = rs.next();
            if (exists) {
                int bioentry_id = rs.getInt(1);
                int biosequence_id = rs.getInt(2);
                PreparedStatement delete_taxa = conn.prepareStatement("delete from bioentry_taxa where bioentry_id = ?");
                delete_taxa.setInt(1, bioentry_id);
                delete_taxa.executeUpdate();
                delete_taxa.close();
                PreparedStatement delete_reference = conn.prepareStatement("delete from bioentry_reference where bioentry_id = ?");
                delete_reference.setInt(1, bioentry_id);
                delete_reference.executeUpdate();
                delete_reference.close();
                PreparedStatement delete_comment = conn.prepareStatement("delete from comment where bioentry_id = ?");
                delete_comment.setInt(1, bioentry_id);
                delete_comment.executeUpdate();
                delete_comment.close();
                PreparedStatement delete_qv = conn.prepareStatement("delete from bioentry_qualifier_value where bioentry_id = ?");
                delete_qv.setInt(1, bioentry_id);
                delete_qv.executeUpdate();
                delete_qv.close();
                DBHelper.DeleteStyle dstyle = this.getDBHelper().getDeleteStyle();
                PreparedStatement delete_locs = dstyle == DBHelper.DELETE_POSTGRESQL ? conn.prepareStatement("delete from seqfeature_location  where seqfeature_location.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ?") : conn.prepareStatement("delete from seqfeature_location  using seqfeature_location, seqfeature  where seqfeature_location.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ?");
                delete_locs.setInt(1, bioentry_id);
                delete_locs.executeUpdate();
                delete_locs.close();
                PreparedStatement delete_fqv = dstyle == DBHelper.DELETE_POSTGRESQL ? conn.prepareStatement("delete from seqfeature_qualifier_value  where seqfeature_qualifier_value.seqfeature_id = seqfeature.seqfeature_id    and seqfeature.bioentry_id = ?") : conn.prepareStatement("delete from seqfeature_qualifier_value  using seqfeature_qualifier_value, seqfeature  where seqfeature_qualifier_value.seqfeature_id = seqfeature.seqfeature_id    and seqfeature.bioentry_id = ?");
                delete_fqv.setInt(1, bioentry_id);
                delete_fqv.executeUpdate();
                delete_fqv.close();
                PreparedStatement delete_rel = dstyle == DBHelper.DELETE_POSTGRESQL ? conn.prepareStatement("delete from seqfeature_relationship  where parent_seqfeature_id = seqfeature.seqfeature_id    and seqfeature.bioentry_id = ?") : conn.prepareStatement("delete from seqfeature_relationship  using seqfeature_relationship, seqfeature  where parent_seqfeature_id = seqfeature.seqfeature_id    and seqfeature.bioentry_id = ?");
                delete_rel.setInt(1, bioentry_id);
                delete_rel.executeUpdate();
                delete_rel.close();
                PreparedStatement delete_features = conn.prepareStatement("delete from seqfeature  where bioentry_id = ?");
                delete_features.setInt(1, bioentry_id);
                delete_features.executeUpdate();
                delete_features.close();
                PreparedStatement delete_biosequence = conn.prepareStatement("delete from biosequence where biosequence_id = ?");
                delete_biosequence.setInt(1, biosequence_id);
                delete_biosequence.executeUpdate();
                delete_biosequence.close();
                PreparedStatement delete_entry = conn.prepareStatement("delete from bioentry where bioentry_id = ?");
                delete_entry.setInt(1, bioentry_id);
                delete_entry.executeUpdate();
                delete_entry.close();
            }
            get_sequence.close();
            conn.commit();
            this.pool.putConnection(conn);
            if (!exists) {
                throw new IllegalIDException("Sequence " + id + " didn't exist");
            }
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioException(ex, "Error removing from BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""));
        }
    }

    public Set ids() {
        try {
            HashSet<String> _ids = new HashSet<String>();
            Connection conn = this.pool.takeConnection();
            PreparedStatement st = conn.prepareStatement("select bioentry.accession from bioentry where bioentry.biodatabase_id = ?");
            st.setInt(1, this.dbid);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                _ids.add(rs.getString(1));
            }
            st.close();
            this.pool.putConnection(conn);
            return Collections.unmodifiableSet(_ids);
        }
        catch (SQLException ex) {
            throw new BioRuntimeException(ex, "Error reading from BioSQL tables");
        }
    }

    void persistBioentryProperty(Connection conn, int bioentry_id, Object key, Object value, boolean removeFirst, boolean silent) throws SQLException {
        String keyString = key.toString();
        if (!this.isBioentryPropertySupported()) {
            if (silent) {
                return;
            }
            throw new SQLException("Can't persist this property since the bioentry_property table isn't available");
        }
        if (removeFirst) {
            int id = this.intern_ontology_term(conn, keyString);
            PreparedStatement remove_old_value = conn.prepareStatement("delete from bioentry_qualifier_value  where bioentry_id = ? and ontology_term_id = ?");
            remove_old_value.setInt(1, bioentry_id);
            remove_old_value.setInt(2, id);
            remove_old_value.executeUpdate();
            remove_old_value.close();
        }
        if (value != null) {
            PreparedStatement insert_new;
            if (this.isSPASupported()) {
                insert_new = conn.prepareStatement("insert into bioentry_qualifier_value        (bioentry_id, ontology_term_id, qualifier_value) values (?, intern_ontology_term( ? ), ?)");
                if (value instanceof Collection) {
                    boolean cnt = false;
                    Iterator i = ((Collection)value).iterator();
                    while (i.hasNext()) {
                        insert_new.setInt(1, bioentry_id);
                        insert_new.setString(2, keyString);
                        insert_new.setString(3, i.next().toString());
                        insert_new.executeUpdate();
                    }
                } else {
                    insert_new.setInt(1, bioentry_id);
                    insert_new.setString(2, keyString);
                    insert_new.setString(3, value.toString());
                    insert_new.executeUpdate();
                }
            } else {
                insert_new = conn.prepareStatement("insert into bioentry_qualifier_value        (bioentry_id, ontology_term_id, qualifier_value) values (?, ?, ?)");
                int termID = this.intern_ontology_term(conn, keyString);
                if (value instanceof Collection) {
                    boolean cnt = false;
                    Iterator i = ((Collection)value).iterator();
                    while (i.hasNext()) {
                        insert_new.setInt(1, bioentry_id);
                        insert_new.setInt(2, termID);
                        insert_new.setString(3, i.next().toString());
                        insert_new.executeUpdate();
                    }
                } else {
                    insert_new.setInt(1, bioentry_id);
                    insert_new.setInt(2, termID);
                    insert_new.setString(3, value.toString());
                    insert_new.executeUpdate();
                }
            }
            insert_new.close();
        }
    }

    int intern_seqfeature_source(Connection conn, String s) throws SQLException {
        PreparedStatement get = conn.prepareStatement("select seqfeature_source_id from seqfeature_source where source_name = ?");
        get.setString(1, s);
        ResultSet rs = get.executeQuery();
        if (rs.next()) {
            int id = rs.getInt(1);
            get.close();
            return id;
        }
        get.close();
        PreparedStatement insert = conn.prepareStatement("insert into seqfeature_source (source_name) values ( ? )");
        insert.setString(1, s);
        insert.executeUpdate();
        insert.close();
        int id = this.getDBHelper().getInsertID(conn, "seqfeature_source", "seqfeature_source_id");
        return id;
    }

    int intern_ontology_term(Connection conn, String s) throws SQLException {
        PreparedStatement get = conn.prepareStatement("select ontology_term_id from ontology_term where term_name = ?");
        get.setString(1, s);
        ResultSet rs = get.executeQuery();
        if (rs.next()) {
            int id = rs.getInt(1);
            get.close();
            return id;
        }
        get.close();
        PreparedStatement insert = conn.prepareStatement("insert into ontology_term (term_name) values ( ? )");
        insert.setString(1, s);
        insert.executeUpdate();
        insert.close();
        int id = this.getDBHelper().getInsertID(conn, "ontology_term", "ontology_term_id");
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOntologyTerm(int termId) {
        Map map = this.ontologyTermCache;
        synchronized (map) {
            Integer termKey = new Integer(termId);
            if (!this.ontologyTermCache.containsKey(termKey)) {
                this.ontologyTermCache.clear();
                Connection conn = null;
                try {
                    conn = this.pool.takeConnection();
                    PreparedStatement get_terms = conn.prepareStatement("select ontology_term_id, term_name   from ontology_term");
                    ResultSet rs = get_terms.executeQuery();
                    while (rs.next()) {
                        this.ontologyTermCache.put(new Integer(rs.getInt(1)), rs.getString(2).trim());
                    }
                    get_terms.close();
                    this.pool.putConnection(conn);
                }
                catch (SQLException ex) {
                    throw new BioRuntimeException(ex, "Error fetching annotations");
                }
            }
            return (String)this.ontologyTermCache.get(termKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSeqfeatureSource(int termId) {
        Map map = this.seqfeatureSourceCache;
        synchronized (map) {
            Integer termKey = new Integer(termId);
            if (!this.seqfeatureSourceCache.containsKey(termKey)) {
                this.seqfeatureSourceCache.clear();
                Connection conn = null;
                try {
                    conn = this.pool.takeConnection();
                    PreparedStatement get_terms = conn.prepareStatement("select seqfeature_source_id, source_name   from seqfeature_source");
                    ResultSet rs = get_terms.executeQuery();
                    while (rs.next()) {
                        this.seqfeatureSourceCache.put(new Integer(rs.getInt(1)), rs.getString(2).trim());
                    }
                    get_terms.close();
                    this.pool.putConnection(conn);
                }
                catch (SQLException ex) {
                    throw new BioRuntimeException(ex, "Error fetching annotations");
                }
            }
            return (String)this.seqfeatureSourceCache.get(termKey);
        }
    }

    boolean isHierarchySupported() {
        if (!this.hierarchyChecked) {
            try {
                Connection conn = this.pool.takeConnection();
                PreparedStatement ps = conn.prepareStatement("select * from seqfeature_relationship limit 1");
                try {
                    ps.executeQuery();
                    this.hierarchySupported = true;
                }
                catch (SQLException ex) {
                    this.hierarchySupported = false;
                }
                ps.close();
                this.pool.putConnection(conn);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex);
            }
            this.hierarchyChecked = true;
        }
        return this.hierarchySupported;
    }

    boolean isAssemblySupported() {
        if (!this.assemblyChecked) {
            try {
                Connection conn = this.pool.takeConnection();
                PreparedStatement ps = conn.prepareStatement("select * from assembly limit 1");
                try {
                    ps.executeQuery();
                    this.assemblySupported = true;
                }
                catch (SQLException ex) {
                    this.assemblySupported = false;
                }
                ps.close();
                this.pool.putConnection(conn);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex);
            }
            this.assemblyChecked = true;
        }
        return this.assemblySupported;
    }

    boolean isDummySupported() {
        if (!this.dummyChecked) {
            try {
                Connection conn = this.pool.takeConnection();
                PreparedStatement ps = conn.prepareStatement("select * from dummy limit 1");
                try {
                    ps.executeQuery();
                    this.dummySupported = true;
                }
                catch (SQLException ex) {
                    this.dummySupported = false;
                }
                ps.close();
                this.pool.putConnection(conn);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex);
            }
            this.dummyChecked = true;
        }
        return this.dummySupported;
    }

    boolean isLocationQualifierSupported() {
        return false;
    }

    boolean isBioentryPropertySupported() {
        if (!this.bioentryPropertyChecked) {
            try {
                Connection conn = this.pool.takeConnection();
                PreparedStatement ps = conn.prepareStatement("select * from bioentry_qualifier_value limit 1");
                try {
                    ps.executeQuery();
                    this.bioentryPropertySupported = true;
                }
                catch (SQLException ex) {
                    this.bioentryPropertySupported = false;
                }
                ps.close();
                this.pool.putConnection(conn);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex);
            }
            this.bioentryPropertyChecked = true;
        }
        return this.bioentryPropertySupported;
    }

    boolean isSPASupported() {
        if (!this.spaChecked) {
            try {
                this.spaSupported = false;
                Connection conn = this.pool.takeConnection();
                PreparedStatement ps = conn.prepareStatement("select biosql_accelerators_level()");
                try {
                    int level;
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && (level = rs.getInt(1)) >= 2) {
                        this.spaSupported = true;
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                ps.close();
                this.pool.putConnection(conn);
                this.spaChecked = true;
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex);
            }
        }
        return this.spaSupported;
    }

    public FeatureHolder filter(FeatureFilter ff) {
        try {
            SqlizedFilter sqf = new SqlizedFilter(ff);
            System.err.println("Doing BioSQL filter");
            System.err.println(sqf.getQuery());
            Connection conn = this.pool.takeConnection();
            PreparedStatement get_features = conn.prepareStatement(sqf.getQuery());
            get_features.setInt(1, this.dbid);
            ResultSet rs = get_features.executeQuery();
            String lastAcc = "";
            Sequence seq = null;
            SimpleFeatureHolder fh = new SimpleFeatureHolder();
            while (rs.next()) {
                FeatureHolder hereFeature;
                Feature f;
                String accession = rs.getString(1);
                int fid = rs.getInt(2);
                System.err.println(accession + "\t" + fid);
                if (seq == null || !lastAcc.equals(accession)) {
                    seq = this.getSequence(accession);
                }
                if (!ff.accept(f = (Feature)(hereFeature = seq.filter(new FilterByInternalID(fid), true)).features().next())) continue;
                fh.addFeature(f);
            }
            get_features.close();
            this.pool.putConnection(conn);
            return fh;
        }
        catch (SQLException ex) {
            throw new BioRuntimeException(ex, "Error accessing BioSQL tables");
        }
        catch (ChangeVetoException ex) {
            throw new BioError(ex, "Assert failed: couldn't modify internal FeatureHolder");
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex, "Error fetching sequence");
        }
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator pID;
            {
                this.pID = BioSQLSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.pID.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return BioSQLSequenceDB.this.getSequence((String)this.pID.next());
            }
        };
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.getChangeHub().addDatabaseListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.getChangeHub().removeDatabaseListener(cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }

    BioSQLFeature canonicalizeFeature(BioSQLFeature f, int feature_id) {
        Integer key = new Integer(feature_id);
        BioSQLFeature oldFeature = (BioSQLFeature)this.featuresByID.get(key);
        if (oldFeature != null) {
            return oldFeature;
        }
        this.featuresByID.put(key, f);
        return f;
    }

    BioSQLFeature getFeatureByID(int feature_id) {
        Integer key = new Integer(feature_id);
        BioSQLFeature f = (BioSQLFeature)this.featuresByID.get(key);
        if (f != null) {
            return f;
        }
        try {
            SingleFeatureReceiver receiver = new SingleFeatureReceiver();
            this.getFeaturesSQL().retrieveFeatures(-1, receiver, null, -1, feature_id);
            if (receiver.getFeature() == null) {
                throw new BioRuntimeException("Dangling internal_feature_id");
            }
            this.featuresByID.put(key, (BioSQLFeature)receiver.getFeature());
            return (BioSQLFeature)receiver.getFeature();
        }
        catch (SQLException ex) {
            throw new BioRuntimeException(ex, "Database error");
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
    }

    Cache getTileCache() {
        return this.tileCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SingleFeatureReceiver
    extends BioSQLFeatureReceiver {
        private Feature feature;

        private SingleFeatureReceiver() {
            super(BioSQLSequenceDB.this);
        }

        protected void deliverTopLevelFeature(Feature f) throws ParseException {
            if (this.feature != null) {
                throw new ParseException("Expecting only a single feature");
            }
            this.feature = f;
        }

        public Feature getFeature() {
            return this.feature;
        }
    }

    private class FilterByInternalID
    implements FeatureFilter {
        private int id;

        public FilterByInternalID(int id) {
            this.id = id;
        }

        public boolean accept(Feature f) {
            if (!(f instanceof BioSQLFeature)) {
                return false;
            }
            int intID = ((BioSQLFeature)f)._getInternalID();
            return intID == this.id;
        }
    }

    private class SqlizedFilter {
        private List tables = new ArrayList();
        private String filter;
        private int used_ot = 0;
        private int used_sfs = 0;
        private int used_sqv = 0;

        SqlizedFilter(FeatureFilter ff) {
            this.filter = this.sqlizeFilter(ff, false);
        }

        private String sqlizeFilter(FeatureFilter ff, boolean negate) {
            if (ff instanceof FeatureFilter.ByType) {
                String type = ((FeatureFilter.ByType)ff).getType();
                String tableName = "ot_" + this.used_ot++;
                this.tables.add("ontology_term as " + tableName);
                return tableName + ".term_name " + this.eq(negate) + this.qw(type) + " and seqfeature.seqfeature_key_id = " + tableName + ".ontology_term_id";
            }
            if (ff instanceof FeatureFilter.BySource) {
                String source = ((FeatureFilter.BySource)ff).getSource();
                String tableName = "sfs_" + this.used_sfs++;
                this.tables.add("seqfeature_source as " + tableName);
                return tableName + ".source_name " + this.eq(negate) + this.qw(source) + " and seqfeature.seqfeature_source_id = " + tableName + ".seqfeature_source_id";
            }
            if (ff instanceof FeatureFilter.ByAnnotation) {
                return "";
            }
            if (ff instanceof FeatureFilter.And) {
                FeatureFilter.And and = (FeatureFilter.And)ff;
                FeatureFilter ff1 = and.getChild1();
                FeatureFilter ff2 = and.getChild2();
                String filter1 = this.sqlizeFilter(ff1, negate);
                String filter2 = this.sqlizeFilter(ff2, negate);
                if (filter1.length() > 0) {
                    if (filter2.length() > 0) {
                        return filter1 + " and " + filter2;
                    }
                    return filter1;
                }
                if (filter2.length() > 0) {
                    return filter2;
                }
                return "";
            }
            if (ff instanceof FeatureFilter.Not) {
                FeatureFilter child = ((FeatureFilter.Not)ff).getChild();
                return this.sqlizeFilter(child, !negate);
            }
            return "";
        }

        private String eq(boolean negate) {
            if (negate) {
                return " <> ";
            }
            return "=";
        }

        private String qw(String word) {
            return "'" + word + "'";
        }

        public String getQuery() {
            StringBuffer query = new StringBuffer();
            query.append("select bioentry.accession, seqfeature.seqfeature_id ");
            query.append("  from seqfeature, bioentry");
            Iterator i = this.tables.iterator();
            while (i.hasNext()) {
                query.append(", ");
                query.append((String)i.next());
            }
            query.append(" where bioentry.bioentry_id = seqfeature.bioentry_id");
            query.append("   and bioentry.biodatabase_id = ?");
            if (this.filter.length() > 0) {
                query.append(" and ");
                query.append(this.filter);
            }
            query.append(" order by bioentry.accession");
            return query.substring(0);
        }
    }
}

