/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeSupport;

class SparseCrossProductAlphabet
extends AbstractAlphabet
implements Serializable {
    private final int size;
    private final List alphas;
    private final Map knownSymbols;
    private char tokenSeed = (char)65;

    SparseCrossProductAlphabet(List alphas) {
        this.alphas = alphas;
        this.knownSymbols = new HashMap();
        int size = 1;
        Iterator i = alphas.iterator();
        while (i.hasNext()) {
            FiniteAlphabet a = (FiniteAlphabet)i.next();
            size *= a.size();
        }
        this.size = size;
    }

    protected ChangeSupport generateChangeSupport() {
        Iterator i = this.alphas.iterator();
        while (i.hasNext()) {
            Alphabet a = (Alphabet)i.next();
            if (a.isUnchanging(Alphabet.SYMBOLS)) continue;
            return new ChangeSupport();
        }
        return new ChangeSupport(Collections.singleton(Alphabet.SYMBOLS));
    }

    public String getName() {
        StringBuffer name = new StringBuffer("(");
        int i = 0;
        while (i < this.alphas.size()) {
            Alphabet a = (Alphabet)this.alphas.get(i);
            name.append(a.getName());
            if (i < this.alphas.size() - 1) {
                name.append(" x ");
            }
            ++i;
        }
        name.append(")");
        return name.substring(0);
    }

    public int size() {
        return this.size;
    }

    protected boolean containsImpl(AtomicSymbol s) {
        return this.knownSymbols.values().contains(s);
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public Iterator iterator() {
        return new SparseIterator(this);
    }

    protected AtomicSymbol getSymbolImpl(List sList) throws IllegalSymbolException {
        AtomicSymbol s = (AtomicSymbol)this.knownSymbols.get(sList);
        if (s == null) {
            Iterator si = sList.iterator();
            Iterator ai = this.getAlphabets().iterator();
            while (ai.hasNext()) {
                ((Alphabet)ai.next()).validate((Symbol)si.next());
            }
            ArrayList l = new ArrayList(sList);
            char c = this.tokenSeed;
            this.tokenSeed = (char)(c + '\u0001');
            s = (AtomicSymbol)AlphabetManager.createSymbol(c, Annotation.EMPTY_ANNOTATION, l, (Alphabet)this);
            this.knownSymbols.put(s.getSymbols(), s);
        }
        return s;
    }

    public void addSymbolImpl(AtomicSymbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    private static class SparseIterator
    implements Iterator {
        private Alphabet parent;
        private FiniteAlphabet[] alphas;
        private Iterator[] symI;
        private AtomicSymbol[] as;
        private boolean hasNext;
        private List symList;

        public SparseIterator(FiniteAlphabet parent) {
            this.parent = parent;
            this.alphas = parent.getAlphabets().toArray(new FiniteAlphabet[0]);
            this.symI = new Iterator[this.alphas.length];
            this.as = new AtomicSymbol[this.alphas.length];
            this.hasNext = true;
            int i = 0;
            while (i < this.alphas.length) {
                this.symI[i] = this.alphas[i].iterator();
                if (!this.symI[i].hasNext()) {
                    this.hasNext = false;
                    return;
                }
                this.as[i] = (AtomicSymbol)this.symI[i].next();
                ++i;
            }
            this.symList = Arrays.asList(this.as);
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            try {
                Symbol sym = this.parent.getSymbol(this.symList);
                int i = 0;
                while (i <= this.alphas.length) {
                    if (i == this.alphas.length) {
                        this.hasNext = false;
                    } else if (!this.symI[i].hasNext()) {
                        this.symI[i] = this.alphas[i].iterator();
                        this.as[i] = (AtomicSymbol)this.symI[i].next();
                    } else {
                        this.as[i] = (AtomicSymbol)this.symI[i].next();
                        break;
                    }
                    ++i;
                }
                return sym;
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Assertion Failure: I should contain this symbol");
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

