/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.directory.OBDARegistryParser;
import org.biojava.directory.Registry;
import org.biojava.directory.RegistryConfiguration;

public class SystemRegistry {
    public static final String CONFIG_LOCATOR = "http://www.open-bio.org/registry/seqdatabase.ini";
    public static final String CONFIG_FILE = "seqdatabase.ini";
    public static final String OBDA_SEARCH_ENV = "OBDA_SEARCH_PATH";
    private static Registry systemRegistry;

    public static Registry instance() {
        if (systemRegistry == null) {
            RegistryConfiguration.Composite regConfig = new RegistryConfiguration.Composite();
            Iterator i = SystemRegistry.getRegistryPath().iterator();
            while (i.hasNext()) {
                try {
                    File file;
                    String locator = (String)i.next();
                    URL url = new URL(locator);
                    if (url.getProtocol().equals("file") && (!(file = new File(url.getPath())).exists() || !file.canRead())) continue;
                    BufferedReader stream = null;
                    try {
                        stream = new BufferedReader(new InputStreamReader(url.openStream()));
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (stream == null) continue;
                    try {
                        RegistryConfiguration cfg = OBDARegistryParser.parseRegistry(stream, locator);
                        regConfig.addBottomConfig(cfg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            systemRegistry = new Registry(regConfig);
        }
        return systemRegistry;
    }

    public static List getRegistryPath() {
        ArrayList<String> registryPath = new ArrayList<String>();
        String customPath = System.getProperty(OBDA_SEARCH_ENV);
        if (customPath != null) {
            StringTokenizer st = new StringTokenizer(customPath, "+");
            while (st.hasMoreTokens()) {
                registryPath.add(st.nextToken());
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                registryPath.add("file://" + userHome + "/.bioinformatics/" + CONFIG_FILE);
            }
            registryPath.add("file:///etc/bioinformatics/seqdatabase.ini");
            registryPath.add(CONFIG_LOCATOR);
        }
        return registryPath;
    }
}

