/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListTools
implements Serializable {
    public static List createList(List l) {
        switch (l.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, l.get(0));
            }
            case 2: {
                Doublet d = new Doublet(l.get(0), l.get(1));
                return d;
            }
            case 3: {
                Triplet t = new Triplet(l.get(0), l.get(1), l.get(2));
                return t;
            }
        }
        return new ArrayList(l);
    }

    public static List createList(Object[] a) {
        switch (a.length) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, a[0]);
            }
            case 2: {
                Doublet d = new Doublet(a[0], a[1]);
                return d;
            }
            case 3: {
                Triplet t = new Triplet(a[0], a[1], a[2]);
                return t;
            }
        }
        return Arrays.asList(a);
    }

    public static class Triplet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;
        private Object c;

        public Triplet() {
        }

        public Triplet(Object a, Object b, Object c) {
            this();
            this.set(a, b, c);
        }

        public void set(Object a, Object b, Object c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public void setC(Object c) {
            this.c = c;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        public Object getC() {
            return this.c;
        }

        public int size() {
            return 3;
        }

        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
                case 2: {
                    return this.c;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(this){
                private int indx;
                private final /* synthetic */ Triplet this$0;
                {
                    this.this$0 = this$0;
                    this.indx = 0;
                }

                public boolean hasNext() {
                    return this.indx < 3;
                }

                public Object next() {
                    return this.this$0.get(this.indx++);
                }

                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            hashcode = 31 * hashcode + this.c.hashCode();
            return hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 3) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b) && other.get(2).equals(this.c);
        }
    }

    public static class Doublet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;

        public Doublet() {
        }

        public Doublet(Object a, Object b) {
            this();
            this.set(a, b);
        }

        public void set(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        public int size() {
            return 2;
        }

        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(this){
                private int indx;
                private final /* synthetic */ Doublet this$0;
                {
                    this.this$0 = this$0;
                    this.indx = 0;
                }

                public boolean hasNext() {
                    return this.indx < 2;
                }

                public Object next() {
                    return this.this$0.get(this.indx++);
                }

                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            return hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 2) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b);
        }
    }
}

