/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.util.Vector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.LastSegmentException;
import uk.ac.sanger.artemis.Selectable;
import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.MarkerChangeListener;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class FeatureSegment
implements Selectable,
SequenceChangeListener,
MarkerChangeListener {
    public static final int NO_FRAME = -1;
    public static final int FORWARD_FRAME_1 = 0;
    public static final int FORWARD_FRAME_2 = 1;
    public static final int FORWARD_FRAME_3 = 2;
    public static final int FORWARD_STRAND = 3;
    public static final int REVERSE_STRAND = 4;
    public static final int REVERSE_FRAME_3 = 5;
    public static final int REVERSE_FRAME_2 = 6;
    public static final int REVERSE_FRAME_1 = 7;
    public static final int SCALE_LINE = 8;
    private Feature feature;
    private Marker start = null;
    private Marker end = null;
    private Range range = null;
    private final Vector marker_listener_list = new Vector();
    private Bases bases;

    public FeatureSegment(Feature feature, Range range) {
        this.feature = feature;
        if (feature == null) {
            throw new Error();
        }
        this.setRange(range);
    }

    public void setRange(Range range) {
        int end_position;
        int start_position;
        this.range = range;
        if (this.getFeature().isForwardFeature()) {
            start_position = range.getStart();
            end_position = range.getEnd();
        } else {
            start_position = range.getEnd();
            end_position = range.getStart();
        }
        Strand strand = this.getFeature().getStrand();
        try {
            if (this.start == null) {
                this.start = strand.makeMarkerFromRawPosition(start_position);
            } else {
                this.start.removeMarkerChangeListener(this);
                this.start.setRawPosition(start_position);
            }
            if (this.end == null) {
                this.end = strand.makeMarkerFromRawPosition(end_position);
            } else {
                this.end.removeMarkerChangeListener(this);
                this.end.setRawPosition(end_position);
            }
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected OutOfRangeException for position: " + start_position);
        }
        this.start.addMarkerChangeListener(this);
        this.end.addMarkerChangeListener(this);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Marker getStart() {
        return this.start;
    }

    public Marker getEnd() {
        return this.end;
    }

    void setStartPosition(int position) throws OutOfRangeException {
        this.getStart().setPosition(position);
        this.updateRange();
    }

    void setEndPosition(int position) throws OutOfRangeException {
        this.getEnd().setPosition(position);
        this.updateRange();
    }

    public Range getRawRange() {
        return this.range;
    }

    public MarkerRange getMarkerRange() {
        try {
            return new MarkerRange(this.getFeature().getStrand(), this.getStart().getPosition(), this.getEnd().getPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - " + e);
        }
    }

    public void removeFromFeature() throws ReadOnlyException, LastSegmentException {
        this.getFeature().removeSegment(this);
        this.feature = null;
    }

    public int getBaseCount() {
        return this.getEnd().getPosition() - this.getStart().getPosition() + 1;
    }

    public String getBases() {
        Strand strand = this.getFeature().getStrand();
        try {
            return strand.getSubSequence(new Range(this.getStart().getPosition(), this.getEnd().getPosition()));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean canDirectEdit() {
        return !(this.range instanceof FuzzyRange);
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        if (event.getType() != 3) {
            this.updateRange();
        }
    }

    void startListening() {
        Bases bases = this.getFeature().getEntry().getBases();
        int PRIORITY = -1;
        bases.addSequenceChangeListener(this, -1);
        this.bases = bases;
    }

    void stopListening() {
        this.bases.removeSequenceChangeListener(this);
    }

    private void updateRange() {
        try {
            Range new_range = this.getFeature().isForwardFeature() ? this.range.change(this.getStart().getRawPosition(), this.getEnd().getRawPosition()) : this.range.change(this.getEnd().getRawPosition(), this.getStart().getRawPosition());
            this.range = new_range;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void addMarkerChangeListener(MarkerChangeListener l) {
        this.marker_listener_list.addElement(l);
        if (this.marker_listener_list.size() == 1) {
            this.start.addMarkerChangeListener(this);
            this.end.addMarkerChangeListener(this);
        }
    }

    public void removeMarkerChangeListener(MarkerChangeListener l) {
        this.marker_listener_list.removeElement(l);
        if (this.marker_listener_list.size() == 0) {
            this.start.removeMarkerChangeListener(this);
            this.end.removeMarkerChangeListener(this);
        }
    }

    public void markerChanged(MarkerChangeEvent event) {
        this.updateRange();
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(MarkerChangeEvent event) {
        Vector targets;
        FeatureSegment featureSegment = this;
        synchronized (featureSegment) {
            targets = (Vector)this.marker_listener_list.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            MarkerChangeListener target = (MarkerChangeListener)targets.elementAt(i);
            target.markerChanged(event);
        }
    }

    private int getFrameShift() {
        int base_count = 0;
        FeatureSegmentVector segments = this.getFeature().getSegments();
        for (int i = 0; i < segments.size() && segments.elementAt(i) != this; ++i) {
            base_count += segments.elementAt(i).getBaseCount();
        }
        int mod_value = (base_count + 3 - (this.getFeature().getCodonStart() - 1)) % 3;
        if (mod_value == 1) {
            return 2;
        }
        if (mod_value == 2) {
            return 1;
        }
        return 0;
    }

    public int getFrameID() {
        int start_base_modulo = (this.getStart().getPosition() - 1 + this.getFrameShift()) % 3;
        if (this.getFeature().getStrand().isForwardStrand()) {
            switch (start_base_modulo) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
        } else {
            switch (start_base_modulo) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 6;
                }
                case 2: {
                    return 5;
                }
            }
        }
        return -1;
    }
}

