/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.io.InputStreamReader;
import uk.ac.sanger.artemis.ExternalProgramEvent;
import uk.ac.sanger.artemis.ExternalProgramMonitor;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.SimpleExternalProgramMonitor;

public class ProcessMonitor
extends SimpleExternalProgramMonitor
implements ExternalProgramMonitor {
    public final Process process;

    public ProcessMonitor(Process process, String name, Logger logger) {
        super(name, logger);
        this.process = process;
    }

    public void run() {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(this.process.getErrorStream());
            this.getLogger().log(reader);
        }
        catch (IOException e) {
            this.getLogger().log("cannot read the errer stream from " + this.getProgramName());
        }
        try {
            reader = new InputStreamReader(this.process.getInputStream());
            this.getLogger().log(reader);
        }
        catch (IOException e) {
            this.getLogger().log("cannot read the ouput stream from " + this.getProgramName());
        }
        while (true) {
            try {
                int exit_code;
                int sig_number;
                int return_value = this.process.waitFor();
                boolean core_dumped = (return_value & 0x80) != 0;
                this.getLogger().log("\n-----------------------------------------------------------\n\n");
                String log_message = core_dumped ? this.getProgramName() + " process dumped core" : ((sig_number = return_value & 0x7F) > 0 ? this.getProgramName() + " process received signal: " + sig_number : ((exit_code = return_value >> 8) == 0 ? this.getProgramName() + " process completed" : this.getProgramName() + " process finished with exit code: " + exit_code));
                ExternalProgramEvent event = new ExternalProgramEvent(1, log_message, this.process);
                this.sendEvent(event);
                this.getLogger().log(log_message + "\n");
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

