/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;

abstract class SimpleComparisonData
implements ComparisonData {
    private final int BUCKET_SIZE = 1000;
    private AlignMatch[] matches;
    private AlignMatch[] match_buffer;
    private int max_score = -1;
    private int min_score = 999999999;
    private int subject_sequence_max_base = -1;
    private int query_sequence_max_base = -1;
    private Vector[] subject_sequence_buckets = null;
    private Vector[] query_sequence_buckets = null;
    private Vector spare_buckets = new Vector();

    public SimpleComparisonData(LinePushBackReader stream) throws IOException {
        String line;
        Vector<AlignMatch> align_match_vector = new Vector<AlignMatch>();
        while ((line = stream.readLine()) != null) {
            AlignMatch new_match;
            if (line.trim().length() == 0 || (new_match = this.makeMatchFromString(line)) == null) continue;
            align_match_vector.addElement(new_match);
        }
        AlignMatch[] matches = new AlignMatch[align_match_vector.size()];
        for (int i = 0; i < matches.length; ++i) {
            matches[i] = (AlignMatch)align_match_vector.elementAt(i);
        }
        this.setMatches(matches);
    }

    protected SimpleComparisonData() {
    }

    public AlignMatch[] getMatches() {
        return this.matches;
    }

    public AlignMatch[] getMatchesInRange(Range subject_seq_range, Range query_seq_range) {
        AlignMatch this_match;
        int i;
        int bucket_index;
        int match_buffer_count = 0;
        for (int i2 = 0; i2 < this.spare_buckets.size(); ++i2) {
            AlignMatch this_match2 = (AlignMatch)this.spare_buckets.elementAt(i2);
            if (!this.matchInRange(this_match2, subject_seq_range, query_seq_range)) continue;
            this.match_buffer[match_buffer_count] = this_match2;
            ++match_buffer_count;
        }
        Hashtable<AlignMatch, AlignMatch> table = new Hashtable<AlignMatch, AlignMatch>(100);
        for (bucket_index = subject_seq_range.getStart() / 1000; bucket_index < subject_seq_range.getEnd() / 1000; ++bucket_index) {
            for (i = 0; i < this.subject_sequence_buckets[bucket_index].size(); ++i) {
                this_match = (AlignMatch)this.subject_sequence_buckets[bucket_index].elementAt(i);
                if (!this_match.getSubjectSequenceRange().overlaps(subject_seq_range)) continue;
                this.match_buffer[match_buffer_count] = this_match;
                ++match_buffer_count;
                table.put(this_match, this_match);
            }
        }
        for (bucket_index = query_seq_range.getStart() / 1000; bucket_index < query_seq_range.getEnd() / 1000; ++bucket_index) {
            for (i = 0; i < this.query_sequence_buckets[bucket_index].size(); ++i) {
                this_match = (AlignMatch)this.query_sequence_buckets[bucket_index].elementAt(i);
                if (table.containsKey(this_match) || !this_match.getQuerySequenceRange().overlaps(query_seq_range)) continue;
                this.match_buffer[match_buffer_count] = this_match;
                ++match_buffer_count;
            }
        }
        AlignMatch[] return_matches = new AlignMatch[match_buffer_count];
        System.arraycopy(this.match_buffer, 0, return_matches, 0, return_matches.length);
        return return_matches;
    }

    /*
     * WARNING - void declaration
     */
    public ComparisonData flipMatchesIfNeeded(Bases subject_sequence, Bases query_sequence) throws OutOfRangeException {
        void var5_6;
        String message;
        AlignMatch forward_error_match = this.checkMatches(subject_sequence, query_sequence);
        if (forward_error_match == null) {
            return null;
        }
        AlignMatch reverse_error_match = this.checkMatches(query_sequence, subject_sequence);
        if (reverse_error_match == null) {
            SimpleComparisonData new_comparison_data = this.getNewSimpleComparisonData();
            AlignMatch[] new_matches = new AlignMatch[this.matches.length];
            for (int i = 0; i < this.matches.length; ++i) {
                AlignMatch new_match;
                AlignMatch this_match = this.matches[i];
                new_matches[i] = new_match = new AlignMatch(this_match.getQuerySequenceRange(), this_match.getSubjectSequenceRange(), this_match.isRevMatch(), this_match.getScore(), this_match.getPercentID());
            }
            new_comparison_data.setMatches(new_matches);
            return new_comparison_data;
        }
        if (forward_error_match.getSubjectSequenceStart() > subject_sequence.getLength()) {
            message = "match goes off end of subject sequence: " + forward_error_match.getSubjectSequenceStart();
        } else if (forward_error_match.getSubjectSequenceEnd() > subject_sequence.getLength()) {
            message = "match goes off end of subject sequence: " + forward_error_match.getSubjectSequenceEnd();
        } else if (forward_error_match.getQuerySequenceStart() > query_sequence.getLength()) {
            message = "match goes off end of query sequence: " + forward_error_match.getQuerySequenceStart();
        } else if (forward_error_match.getQuerySequenceEnd() > query_sequence.getLength()) {
            message = "match goes off end of query sequence: " + forward_error_match.getQuerySequenceEnd();
        } else {
            throw new Error("internal error - unreachable code");
        }
        throw new OutOfRangeException((String)var5_6);
    }

    protected abstract SimpleComparisonData getNewSimpleComparisonData();

    protected abstract AlignMatch makeMatchFromString(String var1) throws IOException;

    private AlignMatch checkMatches(Bases subject_sequence, Bases query_sequence) {
        for (int i = 0; i < this.matches.length; ++i) {
            AlignMatch match = this.matches[i];
            if (match.getSubjectSequenceStart() > subject_sequence.getLength() || match.getSubjectSequenceEnd() > subject_sequence.getLength()) {
                return match;
            }
            if (match.getQuerySequenceStart() <= query_sequence.getLength() && match.getQuerySequenceEnd() <= query_sequence.getLength()) continue;
            return match;
        }
        return null;
    }

    private boolean matchInRange(AlignMatch match, Range subject_seq_range, Range query_seq_range) {
        return match.getSubjectSequenceRange().overlaps(subject_seq_range) || match.getQuerySequenceRange().overlaps(query_seq_range);
    }

    protected void setMatches(AlignMatch[] matches) {
        this.matches = matches;
        this.match_buffer = new AlignMatch[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            AlignMatch this_match = matches[i];
            int score = this_match.getScore();
            int this_match_subject_sequence_end = this_match.getSubjectSequenceEnd();
            int this_match_query_sequence_end = this_match.getQuerySequenceEnd();
            if (this_match_subject_sequence_end > this.subject_sequence_max_base) {
                this.subject_sequence_max_base = this_match_subject_sequence_end;
            }
            if (this_match_query_sequence_end <= this.query_sequence_max_base) continue;
            this.query_sequence_max_base = this_match_query_sequence_end;
        }
    }

    private void makeBuckets() {
        this.subject_sequence_buckets = new Vector[this.subject_sequence_max_base / 1000 + 1];
        this.query_sequence_buckets = new Vector[this.query_sequence_max_base / 1000 + 1];
        for (int i = 0; i < this.matches.length; ++i) {
            AlignMatch match = this.matches[i];
            if (match.getSubjectSequenceRange().getCount() > 1000 || match.getQuerySequenceRange().getCount() > 1000) {
                this.spare_buckets.addElement(match);
                continue;
            }
            int match_subject_sequence_start = match.getSubjectSequenceStart();
            int match_query_sequence_start = match.getQuerySequenceStart();
            int subject_buckets_index = match_subject_sequence_start / 1000;
            this.subject_sequence_buckets[subject_buckets_index].addElement(match);
            int query_buckets_index = match_query_sequence_start / 1000;
            this.query_sequence_buckets[query_buckets_index].addElement(match);
        }
    }

    protected static AlignMatch makeAlignMatch(int subject_sequence_start, int subject_sequence_end, int query_sequence_start, int query_sequence_end, int score, int percent_id) {
        try {
            int tmp;
            boolean rev_match = false;
            if (subject_sequence_end < subject_sequence_start) {
                tmp = subject_sequence_start;
                subject_sequence_start = subject_sequence_end;
                subject_sequence_end = tmp;
                boolean bl = rev_match = !rev_match;
            }
            if (query_sequence_end < query_sequence_start) {
                tmp = query_sequence_start;
                query_sequence_start = query_sequence_end;
                query_sequence_end = tmp;
                rev_match = !rev_match;
            }
            return new AlignMatch(new Range(subject_sequence_start, subject_sequence_end), new Range(query_sequence_start, query_sequence_end), rev_match, score, percent_id);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void setMinMaxScore() {
        for (int i = 0; i < this.matches.length; ++i) {
            AlignMatch this_match = this.matches[i];
            int score = this_match.getScore();
            if (score <= -1) continue;
            if (score > this.max_score) {
                this.max_score = score;
            }
            if (score >= this.min_score) continue;
            this.min_score = score;
        }
    }

    public int getMaximumScore() {
        if (this.max_score == -1) {
            this.setMinMaxScore();
        }
        return this.max_score;
    }

    public int getMinimumScore() {
        if (this.max_score == -1) {
            this.setMinMaxScore();
        }
        return this.min_score;
    }
}

