/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.ActMain;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.MessageFrame;
import uk.ac.sanger.artemis.components.StickyFileChooser;
import uk.ac.sanger.artemis.components.TextFieldSink;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

public class ComparatorDialog
extends JFrame {
    public ComparatorDialog(final ActMain act_main) {
        final JPanel top_panel = new JPanel();
        this.getContentPane().add((Component)top_panel, "Center");
        final GridBagLayout gridbag = new GridBagLayout();
        top_panel.setLayout(gridbag);
        final Vector<JTextField> text_field_vector = new Vector<JTextField>();
        for (int i = 0; i < 3; ++i) {
            String label;
            switch (i) {
                case 0: {
                    label = "Sequence file 1";
                    break;
                }
                case 1: {
                    label = "Comparison file 1";
                    break;
                }
                case 2: {
                    label = "Sequence file 2";
                    break;
                }
                default: {
                    throw new Error("internal error");
                }
            }
            JTextField text_field = this.makeFileNamePanel(label, top_panel, gridbag);
            text_field_vector.addElement(text_field);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JButton more_button = new JButton("more files ...");
        final JPanel more_button_panel = new JPanel();
        more_button_panel.setLayout(new FlowLayout(0));
        more_button_panel.add(more_button);
        c.gridwidth = 1;
        gridbag.setConstraints(more_button_panel, c);
        top_panel.add(more_button_panel);
        more_button.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            public void actionPerformed(ActionEvent e) {
                block7: {
                    block6: {
                        top_panel.remove(more_button_panel);
                        if (text_field_vector.size() % 2 == 0) ** GOTO lbl-1000
                        Options.getOptions();
                        if (Options.isNoddyMode()) lbl-1000:
                        // 2 sources

                        {
                            add_sequence_flag = true;
                        } else {
                            add_sequence_flag = false;
                        }
                        if (text_field_vector.size() % 2 == 1) break block6;
                        Options.getOptions();
                        if (!Options.isNoddyMode()) break block7;
                    }
                    seq_label = "Comparison file " + (text_field_vector.size() / 2 + 1);
                    seq_text_field = ComparatorDialog.access$000(ComparatorDialog.this, seq_label, top_panel, gridbag);
                    text_field_vector.addElement(seq_text_field);
                }
                if (add_sequence_flag) {
                    comp_label = "Sequence file " + (text_field_vector.size() / 2 + 1);
                    comp_text_field = ComparatorDialog.access$000(ComparatorDialog.this, comp_label, top_panel, gridbag);
                    text_field_vector.addElement(comp_text_field);
                }
                top_panel.add(more_button_panel);
                ComparatorDialog.access$100(ComparatorDialog.this);
            }
        });
        JButton apply_button = new JButton("Apply");
        apply_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComparatorDialog.this.doApply(act_main, text_field_vector);
            }
        });
        JButton close_button = new JButton("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComparatorDialog.this.dispose();
            }
        });
        FlowLayout flow_layout = new FlowLayout(1, 15, 5);
        JPanel close_and_apply_panel = new JPanel(flow_layout);
        close_and_apply_panel.add(apply_button);
        close_and_apply_panel.add(close_button);
        this.getContentPane().add((Component)close_and_apply_panel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ComparatorDialog.this.dispose();
            }
        });
        this.packAndCentre();
    }

    private void packAndCentre() {
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    private JTextField makeFileNamePanel(String label_string, JPanel parent_panel, GridBagLayout gridbag) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weighty = 0.0;
        JLabel label = new JLabel(label_string);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(label);
        c.gridwidth = 1;
        gridbag.setConstraints(panel, c);
        parent_panel.add(panel);
        final TextFieldSink text_field = new TextFieldSink("", 28);
        gridbag.setConstraints(text_field, c);
        parent_panel.add(text_field);
        JButton choose_button = new JButton("Choose ...");
        choose_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                StickyFileChooser file_dialog = new StickyFileChooser();
                file_dialog.setDialogTitle("Choose first sequence ...");
                file_dialog.setFileSelectionMode(0);
                file_dialog.setDialogType(0);
                file_dialog.showOpenDialog(ComparatorDialog.this);
                if (file_dialog.getSelectedFile() != null) {
                    File selected_file = new File(file_dialog.getCurrentDirectory(), file_dialog.getSelectedFile().getName());
                    text_field.setText(selected_file.toString());
                }
            }
        });
        c.gridwidth = 0;
        gridbag.setConstraints(choose_button, c);
        parent_panel.add(choose_button);
        return text_field;
    }

    private void doApply(ActMain act_main, Vector text_field_vector) {
        if (text_field_vector.size() < 3) {
            throw new Error("internal error - not enough file names given to ComparatorDialog.doApply()");
        }
        String[] file_names = new String[text_field_vector.size()];
        for (int i = 0; i < text_field_vector.size(); ++i) {
            file_names[i] = ((JTextField)text_field_vector.elementAt(i)).getText().trim();
            if (file_names[i].length() != 0) continue;
            if (i > 3) {
                boolean found_file = false;
                for (int sub_index = i; sub_index < text_field_vector.size(); ++sub_index) {
                    JTextField text_field = (JTextField)text_field_vector.elementAt(sub_index);
                    String this_text = text_field.getText().trim();
                    if (this_text.length() == 0) continue;
                    found_file = true;
                }
                if (!found_file) {
                    String[] new_file_names = new String[i];
                    System.arraycopy(file_names, 0, new_file_names, 0, i);
                    file_names = new_file_names;
                    break;
                }
            }
            new MessageDialog(this, "one of the file names is missing");
            return;
        }
        MessageFrame reading_message = new MessageFrame("reading ...");
        InputStreamProgressListener progress_listener = act_main.getInputStreamProgressListener();
        if (ActMain.makeMultiComparator(act_main, progress_listener, file_names)) {
            this.dispose();
        }
        reading_message.dispose();
    }

    static /* synthetic */ JTextField access$000(ComparatorDialog x0, String x1, JPanel x2, GridBagLayout x3) {
        return x0.makeFileNamePanel(x1, x2, x3);
    }

    static /* synthetic */ void access$100(ComparatorDialog x0) {
        x0.packAndCentre();
    }
}

