/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.GotoListener;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.AlignmentEvent;
import uk.ac.sanger.artemis.components.AlignmentListener;
import uk.ac.sanger.artemis.components.AlignmentViewer;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class ComparatorGlue {
    private final JFrame parent_frame;
    private final FeatureDisplay subject_feature_display;
    private final FeatureDisplay query_feature_display;
    private final AlignmentViewer alignment_viewer;
    private int subject_first_base_position = 1;
    private int query_first_base_position = 1;
    private DisplayAdjustmentListener subject_listener = null;
    private DisplayAdjustmentListener query_listener = null;
    private final Strand orig_subject_forward_strand;
    private final Strand orig_query_forward_strand;

    public ComparatorGlue(JFrame parent_frame, FeatureDisplay subject_feature_display, FeatureDisplay query_feature_display, AlignmentViewer alignment_viewer) {
        this.parent_frame = parent_frame;
        this.subject_feature_display = subject_feature_display;
        this.query_feature_display = query_feature_display;
        this.alignment_viewer = alignment_viewer;
        this.getSubjectEntryGroup().addFeatureChangeListener(this.getSubjectSelection());
        this.getQueryEntryGroup().addEntryChangeListener(this.getQuerySelection());
        this.addDisplayListeners(subject_feature_display, query_feature_display);
        this.orig_subject_forward_strand = this.getSubjectEntryGroup().getBases().getForwardStrand();
        this.orig_query_forward_strand = this.getQueryEntryGroup().getBases().getForwardStrand();
        this.makeAlignmentEventListener();
    }

    private void addDisplayListeners(final FeatureDisplay subject_display, final FeatureDisplay query_display) {
        this.subject_listener = new DisplayAdjustmentListener(){

            public void displayAdjustmentValueChanged(DisplayAdjustmentEvent e) {
                if (e.getType() == 2) {
                    ComparatorGlue.this.getAlignmentViewer().unlockDisplays();
                    return;
                }
                subject_display.removeDisplayAdjustmentListener(ComparatorGlue.this.subject_listener);
                query_display.removeDisplayAdjustmentListener(ComparatorGlue.this.query_listener);
                query_display.setScaleFactor(e.getScaleFactor());
                if (ComparatorGlue.this.getAlignmentViewer().displaysAreLocked() && (e.getType() == 1 || e.getType() == 3)) {
                    int difference = e.getStart() - ComparatorGlue.this.subject_first_base_position;
                    ComparatorGlue.this.query_first_base_position = query_display.getForwardBaseAtLeftEdge() + difference;
                    query_display.setFirstBase(ComparatorGlue.this.query_first_base_position);
                }
                ComparatorGlue.this.subject_first_base_position = e.getStart();
                subject_display.addDisplayAdjustmentListener(ComparatorGlue.this.subject_listener);
                query_display.addDisplayAdjustmentListener(ComparatorGlue.this.query_listener);
            }
        };
        this.query_listener = new DisplayAdjustmentListener(){

            public void displayAdjustmentValueChanged(DisplayAdjustmentEvent e) {
                if (e.getType() == 2) {
                    ComparatorGlue.this.getAlignmentViewer().unlockDisplays();
                    return;
                }
                subject_display.removeDisplayAdjustmentListener(ComparatorGlue.this.subject_listener);
                query_display.removeDisplayAdjustmentListener(ComparatorGlue.this.query_listener);
                subject_display.setScaleFactor(e.getScaleFactor());
                if (ComparatorGlue.this.getAlignmentViewer().displaysAreLocked() && (e.getType() == 1 || e.getType() == 3)) {
                    int difference = e.getStart() - ComparatorGlue.this.query_first_base_position;
                    ComparatorGlue.this.subject_first_base_position = subject_display.getForwardBaseAtLeftEdge() + difference;
                    subject_display.setFirstBase(ComparatorGlue.this.subject_first_base_position);
                }
                ComparatorGlue.this.query_first_base_position = e.getStart();
                subject_display.addDisplayAdjustmentListener(ComparatorGlue.this.subject_listener);
                query_display.addDisplayAdjustmentListener(ComparatorGlue.this.query_listener);
            }
        };
        subject_display.addDisplayAdjustmentListener(this.subject_listener);
        query_display.addDisplayAdjustmentListener(this.query_listener);
        DisplayAdjustmentListener subject_align_listener = new DisplayAdjustmentListener(){

            public void displayAdjustmentValueChanged(DisplayAdjustmentEvent e) {
                ComparatorGlue.this.getAlignmentViewer().setSubjectSequencePosition(e);
            }
        };
        subject_display.addDisplayAdjustmentListener(subject_align_listener);
        DisplayAdjustmentListener query_align_listener = new DisplayAdjustmentListener(){

            public void displayAdjustmentValueChanged(DisplayAdjustmentEvent e) {
                ComparatorGlue.this.getAlignmentViewer().setQuerySequencePosition(e);
            }
        };
        query_display.addDisplayAdjustmentListener(query_align_listener);
    }

    private void makeAlignmentEventListener() {
        AlignmentListener listener = new AlignmentListener(){

            public void alignMatchChosen(AlignmentEvent e) {
                ComparatorGlue.this.alignAt(e.getMatch());
            }
        };
        this.getAlignmentViewer().addAlignmentListener(listener);
    }

    private void alignAt(AlignMatch align_match) {
        this.getAlignmentViewer().unlockDisplays();
        this.getAlignmentViewer().disableSelection();
        this.maybeRevCompQuery(align_match);
        int subject_length = this.getSubjectForwardStrand().getSequenceLength();
        int query_length = this.getQueryForwardStrand().getSequenceLength();
        int subject_sequence_start = AlignmentViewer.getRealSubjectSequenceStart(align_match, subject_length, this.getAlignmentViewer().subjectIsRevComp());
        int subject_sequence_end = AlignmentViewer.getRealSubjectSequenceEnd(align_match, subject_length, this.getAlignmentViewer().subjectIsRevComp());
        int query_sequence_start = AlignmentViewer.getRealQuerySequenceStart(align_match, query_length, this.getAlignmentViewer().queryIsRevComp());
        int query_sequence_end = AlignmentViewer.getRealQuerySequenceEnd(align_match, query_length, this.getAlignmentViewer().queryIsRevComp());
        if (this.getSubjectDisplay().isRevCompDisplay()) {
            subject_sequence_start = this.getSubjectDisplay().getSequenceLength() - subject_sequence_start + 1;
            subject_sequence_end = this.getSubjectDisplay().getSequenceLength() - subject_sequence_end + 1;
        }
        if (this.getQueryDisplay().isRevCompDisplay()) {
            query_sequence_start = this.getQueryDisplay().getSequenceLength() - query_sequence_start + 1;
            query_sequence_end = this.getQueryDisplay().getSequenceLength() - query_sequence_end + 1;
        }
        int new_subject_base = subject_sequence_start + (subject_sequence_end - subject_sequence_start) / 2;
        this.getSubjectDisplay().makeBaseVisible(new_subject_base);
        try {
            Strand subject_strand = align_match.isRevMatch() ^ !this.getOrigSubjectForwardStrand().isForwardStrand() ? this.getSubjectReverseStrand() : this.getSubjectForwardStrand();
            MarkerRange new_subject_marker = subject_strand.makeMarkerRangeFromRawPositions(subject_sequence_start, subject_sequence_end);
            this.getSubjectSelection().setMarkerRange(new_subject_marker);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        int new_query_base = query_sequence_start + (query_sequence_end - query_sequence_start) / 2;
        this.getQueryDisplay().makeBaseVisible(new_query_base);
        try {
            Strand query_strand = this.getOrigQueryForwardStrand().isForwardStrand() ? this.getQueryForwardStrand() : this.getQueryReverseStrand();
            MarkerRange new_query_marker_range = query_strand.makeMarkerRangeFromRawPositions(query_sequence_start, query_sequence_end);
            this.getQuerySelection().setMarkerRange(new_query_marker_range);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.getAlignmentViewer().lockDisplays();
        this.getAlignmentViewer().enableSelection();
    }

    private void maybeRevCompQuery(AlignMatch align_match) {
        YesNoDialog yes_no_dialog;
        if (!this.getAlignmentViewer().offerToFlip()) {
            return;
        }
        boolean display_is_rev_comped = this.getOrigSubjectForwardStrand().isForwardStrand() ^ this.getOrigQueryForwardStrand().isForwardStrand() ^ this.getSubjectDisplay().isRevCompDisplay() ^ this.getQueryDisplay().isRevCompDisplay();
        if (align_match.isRevMatch() ^ display_is_rev_comped && (yes_no_dialog = new YesNoDialog(this.parent_frame, "reverse and complement query sequence display?")).getResult()) {
            if (this.getQueryDisplay().isRevCompDisplay()) {
                this.getQueryDisplay().setRevCompDisplay(false);
            } else {
                this.getQueryDisplay().setRevCompDisplay(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, EventObject event) {
        Vector targets;
        ComparatorGlue comparatorGlue = this;
        synchronized (comparatorGlue) {
            targets = (Vector)listeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            GotoListener target = (GotoListener)targets.elementAt(i);
            if (!(event instanceof GotoEvent)) {
                throw new Error("EntryEdit.fireAction () - unknown event");
            }
            GotoListener goto_listener = target;
            goto_listener.performGoto((GotoEvent)event);
        }
    }

    public Strand getOrigSubjectForwardStrand() {
        return this.orig_subject_forward_strand;
    }

    public Strand getOrigQueryForwardStrand() {
        return this.orig_query_forward_strand;
    }

    public GotoEventSource getSubjectGotoEventSource() {
        return this.getSubjectDisplay().getGotoEventSource();
    }

    public GotoEventSource getQueryGotoEventSource() {
        return this.getQueryDisplay().getGotoEventSource();
    }

    public EntryGroup getSubjectEntryGroup() {
        return this.getSubjectDisplay().getEntryGroup();
    }

    public EntryGroup getQueryEntryGroup() {
        return this.getQueryDisplay().getEntryGroup();
    }

    public Selection getSubjectSelection() {
        return this.getSubjectDisplay().getSelection();
    }

    public Selection getQuerySelection() {
        return this.getQueryDisplay().getSelection();
    }

    private AlignmentViewer getAlignmentViewer() {
        return this.alignment_viewer;
    }

    public FeatureDisplay getSubjectDisplay() {
        return this.subject_feature_display;
    }

    public FeatureDisplay getQueryDisplay() {
        return this.query_feature_display;
    }

    private Strand getSubjectForwardStrand() {
        return this.getSubjectEntryGroup().getBases().getForwardStrand();
    }

    private Strand getQueryForwardStrand() {
        return this.getQueryEntryGroup().getBases().getForwardStrand();
    }

    private Strand getSubjectReverseStrand() {
        return this.getSubjectEntryGroup().getBases().getReverseStrand();
    }

    private Strand getQueryReverseStrand() {
        return this.getQueryEntryGroup().getBases().getReverseStrand();
    }
}

