/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.sanger.artemis.Options;

public class MessageDialog
extends JDialog {
    private final int MESSAGE_SPLIT_SIZE = 100;
    private final JButton ok_button = new JButton("OK");

    public MessageDialog(JFrame parent, String message) {
        this(parent, message, message, true);
    }

    public MessageDialog(JFrame parent, String message, boolean modal) {
        this(parent, message, message, modal);
    }

    public MessageDialog(JFrame parent_frame, String title, String message) {
        this(parent_frame, title, message, true);
    }

    public MessageDialog(JFrame parent_frame, String title, String message, boolean modal) {
        super(parent_frame, title, modal);
        Font font = Options.getOptions().getFont();
        this.setFont(font);
        if (message.length() < 100) {
            this.getContentPane().add((Component)new JLabel(message), "North");
        } else {
            JTextArea text_area = new JTextArea(18, 90);
            text_area.setText(message);
            this.getContentPane().add((Component)new JScrollPane(text_area), "North");
            text_area.setEditable(false);
        }
        JPanel panel = new JPanel();
        panel.add(this.ok_button);
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                MessageDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                MessageDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        ((Component)this).setVisible(true);
    }
}

