/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.ExternalProgramEvent;
import uk.ac.sanger.artemis.ExternalProgramException;
import uk.ac.sanger.artemis.ExternalProgramListener;
import uk.ac.sanger.artemis.ExternalProgramMonitor;
import uk.ac.sanger.artemis.ExternalProgramVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.ExternalProgramOptions;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.MessageFrame;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class RunMenu
extends SelectionMenu {
    private JMenu fastaMenu = null;
    private JMenu fastaMenuOptions = null;
    private JMenu blastpMenu = null;
    private JMenu blastpMenuOptions = null;

    public RunMenu(JFrame frame, Selection selection, String menu_name) {
        super(frame, menu_name, selection);
        int i;
        ExternalProgramVector external_programs = Options.getOptions().getExternalPrograms();
        for (i = 0; i < external_programs.size(); ++i) {
            this.makeMenuItem(external_programs.elementAt(i));
        }
        this.addSeparator();
        for (i = 0; i < external_programs.size(); ++i) {
            this.makeOptionsMenuItem(external_programs.elementAt(i));
        }
    }

    public RunMenu(JFrame frame, Selection selection) {
        this(frame, selection, "Run");
    }

    private void makeMenuItem(final ExternalProgram program) {
        String options_string;
        JMenuItem new_menu = program.getType() == 0 || program.getType() == 1 && Options.getOptions().getPropertyTruthValue("sanger_options") ? ((options_string = program.getProgramOptions()).length() > 0 ? (program.getName().startsWith("fasta") || program.getName().startsWith("blastp") ? new JMenuItem(options_string) : new JMenuItem("Run " + program.getName() + " (" + options_string + ") on selected features")) : new JMenuItem("Run " + program.getName() + " on selected features")) : new JMenuItem("Run " + program.getName() + " on selected features");
        new_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!RunMenu.this.checkForSelectionFeatures()) {
                    return;
                }
                FeatureVector selection_features = RunMenu.this.getSelection().getAllFeatures();
                try {
                    ExternalProgramMonitor monitor = program.run(selection_features, Splash.getLogger());
                    monitor.addExternalProgramListener(new ExternalProgramListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void statusChanged(ExternalProgramEvent e) {
                            if (e.getType() == 1) {
                                ((Component)new MessageFrame(e.getMessage())).setVisible(true);
                            }
                        }
                    });
                    new Thread(monitor).start();
                }
                catch (InvalidKeyException e) {
                    new MessageDialog(RunMenu.this.getParentFrame(), "execution failed: " + e.getMessage());
                }
                catch (EntryInformationException e) {
                    new MessageDialog(RunMenu.this.getParentFrame(), "execution of " + program.getName() + " failed because: " + e.getMessage());
                }
                catch (ReadOnlyException e) {
                    new MessageDialog(RunMenu.this.getParentFrame(), "execution of " + program.getName() + " failed because one of the features is " + "read only");
                }
                catch (IOException e) {
                    new MessageDialog(RunMenu.this.getParentFrame(), "execution of " + program.getName() + " failed because of an I/O error: " + e);
                }
                catch (ExternalProgramException e) {
                    new MessageDialog(RunMenu.this.getParentFrame(), "execution of " + program.getName() + " failed: " + e.getMessage());
                }
            }
        });
        if (program.getName().startsWith("fasta")) {
            if (this.fastaMenu == null) {
                this.fastaMenu = new JMenu("Run fasta on selected features against");
                this.add(this.fastaMenu);
            }
            this.fastaMenu.add(new_menu);
        } else if (program.getName().startsWith("blastp")) {
            if (this.blastpMenu == null) {
                this.blastpMenu = new JMenu("Run blast on selected features against");
                this.add(this.blastpMenu);
            }
            this.blastpMenu.add(new_menu);
        } else {
            this.add(new_menu);
        }
    }

    private void makeOptionsMenuItem(final ExternalProgram program) {
        if (program.getType() != 0 && program.getType() != 1) {
            return;
        }
        JMenuItem new_options_menu = null;
        if (program.getName().startsWith("fasta")) {
            if (this.fastaMenuOptions == null) {
                this.fastaMenuOptions = new JMenu("Set " + program.getName() + " options");
                this.add(this.fastaMenuOptions);
            }
            new_options_menu = new JMenuItem(program.getProgramOptions());
            this.fastaMenuOptions.add(new_options_menu);
        } else if (program.getName().startsWith("blastp")) {
            if (this.blastpMenuOptions == null) {
                this.blastpMenuOptions = new JMenu("Set " + program.getName() + " options");
                this.add(this.blastpMenuOptions);
            }
            new_options_menu = new JMenuItem(program.getProgramOptions());
            this.blastpMenuOptions.add(new_options_menu);
        } else {
            new_options_menu = new JMenuItem("Set " + program.getName() + " options");
            this.add(new_options_menu);
        }
        new_options_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new ExternalProgramOptions(program);
            }
        });
    }

    private int[] getIds() {
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        Vector<Integer> ids_vector = new Vector<Integer>();
        for (int feature_index = 0; feature_index < selected_features.size(); ++feature_index) {
            Feature this_feature = selected_features.elementAt(feature_index);
            try {
                Qualifier job_qualifier = this_feature.getQualifierByName("job");
                StringVector values = job_qualifier.getValues();
                if (values == null || values.size() <= 0) continue;
                for (int value_index = 0; value_index < values.size(); ++value_index) {
                    String job_value = values.elementAt(value_index);
                    StringVector bits = StringVector.getStrings(job_value);
                    if (bits.size() <= 4 || !bits.elementAt(2).equals("task:")) continue;
                    try {
                        Integer task_id = Integer.valueOf(bits.elementAt(3));
                        if (ids_vector.contains(task_id)) continue;
                        ids_vector.add(task_id);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (InvalidRelationException e) {
                // empty catch block
            }
        }
        int[] ids = new int[ids_vector.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Integer)ids_vector.elementAt(i);
        }
        return ids;
    }
}

