/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.io.PrintWriter;
import java.io.StringWriter;
import uk.ac.sanger.artemis.components.FileViewer;

public class SequenceViewer
extends FileViewer {
    private String sequence = "";
    private String comment_line = null;
    private final boolean include_numbers;

    public SequenceViewer(String title, boolean include_numbers) {
        super(title);
        this.include_numbers = include_numbers;
    }

    public void setSequence(String comment_line, String sequence) {
        this.comment_line = comment_line;
        this.sequence = sequence;
        this.setView();
    }

    public void setSequence(String sequence) {
        this.comment_line = null;
        this.sequence = sequence;
        this.setView();
    }

    private void setView() {
        StringWriter string_writer = new StringWriter();
        PrintWriter writer = new PrintWriter(string_writer);
        if (this.comment_line != null) {
            writer.println(this.comment_line);
        }
        String rest_of_sequence = this.sequence;
        int UNITS_PER_LINE = 60;
        int line_count = 0;
        while (rest_of_sequence != null) {
            String this_line;
            if (rest_of_sequence.length() < 60) {
                this_line = rest_of_sequence;
                rest_of_sequence = null;
            } else {
                this_line = rest_of_sequence.substring(0, 60);
                rest_of_sequence = rest_of_sequence.substring(60);
            }
            writer.println(this_line);
            if (this.include_numbers) {
                int COUNT_INTERVAL = 10;
                for (int i = 1; i <= this_line.length() / 10; ++i) {
                    int this_unit_count = i * 10 + line_count * 60;
                    int number_of_spaces = 10 - String.valueOf(this_unit_count).length();
                    for (int space_index = 0; space_index < number_of_spaces; ++space_index) {
                        writer.print(' ');
                    }
                    writer.print(this_unit_count);
                }
                writer.println();
            }
            ++line_count;
        }
        writer.flush();
        this.setText(string_writer.toString());
    }
}

