/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import nsdb.Embl;
import nsdb.EmblWriter;
import nsdb.EmblWriterHelper;
import nsdb.EntryStats;
import nsdb.ServerInfo;
import org.omg.CORBA.ORB;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.components.EMBLCorbaEntrySource;
import uk.ac.sanger.artemis.components.ListDialog;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class WritableEMBLCorbaEntrySource
extends EMBLCorbaEntrySource {
    public WritableEMBLCorbaEntrySource(JFrame frame, String ior_url_string) throws MalformedURLException {
        super(frame, ior_url_string);
    }

    public Entry getEntry(Bases bases, boolean show_progress) throws OutOfRangeException, IOException {
        return this.makeCorbaDialog(bases, false);
    }

    public Entry getEntry(boolean show_progress) throws OutOfRangeException, NoSequenceException, IOException {
        return this.makeCorbaDialog(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry makeCorbaDialog(Bases bases, boolean read_only) throws OutOfRangeException, IOException {
        ORB orb = ORB.init((String[])new String[0], (Properties)new Properties());
        Embl corba_handle = this.getServerHandle();
        EmblWriter embl_writer = EmblWriterHelper.narrow(corba_handle);
        if (embl_writer == null) {
            String message = "Server reference is not an EmblWriter: " + corba_handle;
            new MessageDialog(this.getFrame(), message);
            return null;
        }
        ListDialog list_dialog = new ListDialog(this.getFrame(), "Select an entry");
        ServerInfo stats = embl_writer.getServerInfo();
        final EntryStats[] entry_stats_list = stats.entry_stats_list;
        final EntryStats[] file_stats_list = stats.file_stats_list;
        list_dialog.getList().setModel(new AbstractListModel(){

            public int getSize() {
                return entry_stats_list.length + file_stats_list.length;
            }

            public Object getElementAt(int i) {
                if (i < entry_stats_list.length) {
                    return WritableEMBLCorbaEntrySource.this.makeListString(entry_stats_list[i], false);
                }
                return WritableEMBLCorbaEntrySource.this.makeListString(file_stats_list[i - entry_stats_list.length], true);
            }
        });
        String selected_entry_string = (String)list_dialog.getSelectedValue();
        if (selected_entry_string == null) {
            return null;
        }
        int end_of_entry_name = selected_entry_string.indexOf("   ");
        String corba_id = selected_entry_string.substring(0, end_of_entry_name);
        if (corba_id.length() > 0) {
            MessageDialog message_frame = new MessageDialog(this.getFrame(), "reading entry - please wait", false);
            try {
                Entry entry = this.makeFromCorbaID(bases, corba_id, read_only);
                return entry;
            }
            finally {
                message_frame.dispose();
            }
        }
        return null;
    }

    private String makeListString(EntryStats this_entry_stats, boolean is_file_entry) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this_entry_stats.name).append("   ");
        for (int j = 0; j < 30 - this_entry_stats.name.length(); ++j) {
            buffer.append(" ");
        }
        long last_change_time = this_entry_stats.last_change_time;
        if (is_file_entry) {
            buffer.append("(file)");
        } else if (last_change_time > 0L) {
            buffer.append(new Date(last_change_time * 1000L));
        } else {
            buffer.append("(not saved)");
        }
        return buffer.toString();
    }

    public String getSourceName() {
        return "Database";
    }

    public boolean isFullEntrySource() {
        return false;
    }
}

