/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public abstract class StreamSequenceFactory {
    public static final int EMBL_FORMAT = 1;
    public static final int GENBANK_FORMAT = 2;
    public static final int RAW_FORMAT = 3;
    public static final int FASTA_FORMAT = 4;

    public static StreamSequence makeStreamSequence(LinePushBackReader in_stream) throws IOException {
        int sequence_type = StreamSequenceFactory.getSequenceType(in_stream);
        switch (sequence_type) {
            case 1: {
                return new EmblStreamSequence(in_stream);
            }
            case 4: {
                return new FastaStreamSequence(in_stream);
            }
            case 2: {
                return new GenbankStreamSequence(in_stream);
            }
        }
        return new RawStreamSequence(in_stream);
    }

    public static int getSequenceType(LinePushBackReader in_stream) throws IOException {
        String seq_header_line = in_stream.readLine();
        in_stream.pushBack(seq_header_line);
        if (seq_header_line.startsWith("SQ   ")) {
            return 1;
        }
        if (seq_header_line.startsWith(">")) {
            return 4;
        }
        if (seq_header_line.startsWith("BASE COUNT") || seq_header_line.startsWith("ORIGIN")) {
            return 2;
        }
        return 3;
    }
}

