/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.Options;

public abstract class Algorithm {
    private String algorithm_name;
    private String algorithm_short_name;
    private boolean max_min_disabled = false;
    private Integer options_window_size = null;
    private Integer options_max_window_size = null;
    private Integer options_min_window_size = null;

    public Algorithm(String algorithm_name, String algorithm_short_name) {
        this.algorithm_name = algorithm_name;
        this.algorithm_short_name = algorithm_short_name;
        this.options_min_window_size = Options.getOptions().getIntegerProperty(this.getAlgorithmShortName() + "_default_min_window");
        if (this.options_min_window_size != null && this.options_min_window_size < 1) {
            this.options_min_window_size = null;
        }
        this.options_max_window_size = Options.getOptions().getIntegerProperty(this.getAlgorithmShortName() + "_default_max_window");
        if (this.options_max_window_size != null) {
            if (this.options_min_window_size == null) {
                if (this.options_max_window_size < 1) {
                    this.options_max_window_size = null;
                }
            } else if (this.options_max_window_size < this.options_min_window_size) {
                this.options_max_window_size = this.options_min_window_size;
            }
        }
        this.options_window_size = Options.getOptions().getIntegerProperty(this.getAlgorithmShortName() + "_default_window_size");
        if (this.options_window_size != null) {
            if (this.options_min_window_size == null) {
                if (this.options_window_size < 1) {
                    this.options_window_size = null;
                }
            } else if (this.options_window_size < this.options_min_window_size) {
                this.options_window_size = this.options_min_window_size;
            }
        }
    }

    public String getAlgorithmName() {
        return this.algorithm_name;
    }

    public String getAlgorithmShortName() {
        return this.algorithm_short_name;
    }

    public Integer getDefaultWindowSize() {
        return this.options_window_size;
    }

    public Integer getDefaultMaxWindowSize() {
        return this.options_max_window_size;
    }

    public Integer getDefaultMinWindowSize() {
        return this.options_min_window_size;
    }

    public Integer getDefaultStepSize(int window_size) {
        return null;
    }

    public final Float getMaximum() {
        if (this.scalingFlag()) {
            return null;
        }
        return this.getMaximumInternal();
    }

    protected Float getMaximumInternal() {
        return null;
    }

    public final Float getMinimum() {
        if (this.scalingFlag()) {
            return null;
        }
        return this.getMinimumInternal();
    }

    protected Float getMinimumInternal() {
        return null;
    }

    public Float getAverage() {
        return null;
    }

    public void setScalingFlag(boolean enable_scaling) {
        this.max_min_disabled = enable_scaling;
    }

    public boolean scalingFlag() {
        return this.max_min_disabled;
    }
}

