/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.plot.CodonWeight;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class CodonUsageAlgorithm
extends BaseAlgorithm {
    private final CodonWeight usage_data;

    public CodonUsageAlgorithm(Strand strand, CodonUsageWeight usage_data) {
        super(strand, CodonUsageAlgorithm.makeName(strand, usage_data), "codon_usage");
        this.usage_data = usage_data;
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        int real_frame;
        float this_weight;
        char base3;
        char base2;
        char base1;
        int i;
        int frame;
        String sequence;
        if (this.isRevCompDisplay()) {
            int new_end = this.getStrand().getBases().getComplementPosition(start);
            int new_start = this.getStrand().getBases().getComplementPosition(end);
            end = new_end;
            start = new_start;
        }
        if (this.getStrand().isForwardStrand()) {
            end -= (end - start + 1) % 3;
        } else {
            start += (end - start + 1) % 3;
        }
        try {
            sequence = this.getStrand().getRawSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float[] totals = new float[]{0.0f, 0.0f, 0.0f};
        int codon_count = 0;
        int sub_sequence_length = sequence.length();
        if (this.getStrand().isForwardStrand()) {
            for (frame = 0; frame < 3; ++frame) {
                for (i = frame; i < sub_sequence_length - 3; i += 3) {
                    base1 = sequence.charAt(i);
                    base2 = sequence.charAt(i + 1);
                    base3 = sequence.charAt(i + 2);
                    this_weight = this.usage_data.getCodonValue(base1, base2, base3);
                    real_frame = (frame + start + 2) % 3;
                    ++codon_count;
                    int n = real_frame;
                    totals[n] = (float)((double)totals[n] + Math.log(this_weight));
                }
            }
        } else {
            for (frame = 2; frame >= 0; --frame) {
                for (i = frame; i < sub_sequence_length - 3; i += 3) {
                    base1 = Bases.complement(sequence.charAt(i + 2));
                    base2 = Bases.complement(sequence.charAt(i + 1));
                    base3 = Bases.complement(sequence.charAt(i));
                    this_weight = this.usage_data.getCodonValue(base1, base2, base3);
                    real_frame = (frame + start + 2) % 3;
                    ++codon_count;
                    int n = real_frame;
                    totals[n] = (float)((double)totals[n] + Math.log(this_weight));
                }
            }
        }
        for (frame = 0; frame < 3; ++frame) {
            values[frame] = codon_count == 0 ? 0.0f : (float)Math.exp(totals[frame] / (float)codon_count);
        }
    }

    public int getValueCount() {
        return 3;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(120);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(500);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(24);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 8) {
            return new Integer(window_size / 8);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(2.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }

    public Float getAverage() {
        return null;
    }

    public float getFeatureScore(Feature feature) {
        String sequence = feature.getTranslationBases();
        float total = 0.0f;
        for (int i = 0; i < sequence.length(); i += 3) {
            char base1 = sequence.charAt(i);
            char base2 = sequence.charAt(i + 1);
            char base3 = sequence.charAt(i + 2);
            float this_weight = this.usage_data.getCodonValue(base1, base2, base3);
            total = (float)((double)total + Math.log(this_weight));
        }
        int codon_count = sequence.length() / 3;
        return (float)Math.exp(total / (float)codon_count);
    }

    private static String makeName(Strand strand, CodonWeight codon_weight) {
        if (strand.isForwardStrand()) {
            return "Codon Usage Scores from " + codon_weight.getName();
        }
        return "Reverse Codon Usage Scores from " + codon_weight.getName();
    }
}

