/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.plot.FeatureAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;

public class CoilFeatureAlgorithm
extends FeatureAlgorithm {
    private static final int WINDOW_SIZE = 28;
    private static final float[][] weight_array = new float[][]{{1.297f, 1.551f, 1.084f, 2.612f, 0.377f, 1.248f, 0.877f}, {0.659f, 1.163f, 1.21f, 0.031f, 1.358f, 1.937f, 1.798f}, {0.835f, 1.475f, 1.534f, 0.039f, 1.722f, 2.456f, 2.28f}, {0.03f, 2.352f, 2.268f, 0.237f, 0.663f, 1.62f, 1.448f}, {0.824f, 0.022f, 0.308f, 0.152f, 0.18f, 0.156f, 0.044f}, {0.179f, 2.114f, 1.778f, 0.631f, 2.55f, 1.578f, 2.526f}, {0.262f, 3.496f, 3.108f, 0.998f, 5.685f, 2.494f, 3.048f}, {0.045f, 0.275f, 0.578f, 0.216f, 0.211f, 0.426f, 0.156f}, {0.347f, 0.275f, 0.679f, 0.395f, 0.294f, 0.579f, 0.213f}, {2.597f, 0.098f, 0.345f, 0.894f, 0.514f, 0.471f, 0.431f}, {3.167f, 0.297f, 0.398f, 3.902f, 0.585f, 0.501f, 0.483f}, {1.375f, 2.639f, 1.763f, 0.191f, 1.815f, 1.961f, 2.795f}, {2.24f, 0.37f, 0.48f, 1.409f, 0.541f, 0.772f, 0.663f}, {0.531f, 0.076f, 0.403f, 0.662f, 0.189f, 0.106f, 0.013f}, {0.0f, 0.008f, 0.0f, 0.013f, 0.0f, 0.0f, 0.0f}, {0.382f, 0.583f, 1.052f, 0.419f, 0.525f, 0.916f, 0.628f}, {0.169f, 0.702f, 0.955f, 0.654f, 0.791f, 0.843f, 0.647f}, {0.24f, 0.0f, 0.0f, 0.456f, 0.019f, 0.0f, 0.0f}, {1.417f, 0.09f, 0.122f, 1.659f, 0.19f, 0.13f, 0.155f}, {1.665f, 0.403f, 0.386f, 0.949f, 0.211f, 0.342f, 0.36f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};

    public CoilFeatureAlgorithm(Feature feature) {
        super(feature, "Coiled Coils", "coiled_coil");
    }

    public void getValues(int start, int end, float[] values) {
        int number_of_weights = weight_array[0].length;
        AminoAcidSequence translation = this.getFeature().getTranslation();
        String translation_string = translation.toString().substring(start, end + 1);
        float[] scores = new float[28];
        float max_score = -1.0f;
        int k = 0;
        for (int frame = 0; frame < 7; ++frame) {
            k = frame - start % 7;
            if (k < 0) {
                k += 7;
            }
            for (int j = 0; j < 28; ++j) {
                float this_score;
                char this_char = translation_string.charAt(j);
                int index = AminoAcidSequence.getSymbolIndex(this_char);
                scores[j] = this_score = weight_array[index][k];
                if (++k < 7) continue;
                k = 0;
            }
            float score = this.geometricMean(scores);
            if (!(score > max_score)) continue;
            max_score = score;
        }
        values[0] = this.probCoil(max_score);
    }

    private float geometricMean(float[] scores) {
        float total = 1.0f;
        for (int i = 0; i < scores.length; ++i) {
            total *= scores[i];
        }
        return (float)Math.pow(total, 1.0 / (double)scores.length);
    }

    private float probCoil(float score) {
        float gcc_mean = 1.63f;
        float gg_mean = 0.77f;
        float gcc_sd = 0.24f;
        float gg_sd = 0.2f;
        float gcc = this.gauss(1.63f, 0.24f, score);
        float gg = this.gauss(0.77f, 0.2f, score);
        return (float)((double)gcc / (30.0 * (double)gg + (double)gcc));
    }

    private float gauss(float mean, float sd, float score) {
        return (float)(Math.pow(Math.E, -0.5 * Math.pow((score - mean) / sd, 2.0)) / ((double)sd * 2.0 * Math.PI));
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        return new Integer(28);
    }

    public Integer getDefaultMaxWindowSize() {
        return new Integer(28);
    }

    public Integer getDefaultMinWindowSize() {
        return new Integer(28);
    }

    public Integer getDefaultStepSize(int window_size) {
        return new Integer(1);
    }

    protected Float getMaximumInternal() {
        return new Float(1.01);
    }

    protected Float getMinimumInternal() {
        return new Float(-0.01);
    }

    public Float getAverage() {
        return null;
    }
}

