/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import org.biojava.bio.symbol.IllegalSymbolException;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class Strand {
    public static final int FORWARD = 1;
    public static final int REVERSE = 2;
    private Bases bases;

    Strand(Bases bases, int direction) {
        this.bases = bases;
    }

    public Bases getBases() {
        return this.bases;
    }

    public String getStrandBases() {
        if (this.getDirection() == 1) {
            return this.getBases().toString();
        }
        return Bases.reverseComplement(this.getBases().toString());
    }

    public int getDirection() {
        if (this.getBases().getForwardStrand() == this) {
            return 1;
        }
        return 2;
    }

    public boolean isForwardStrand() {
        return this.getDirection() == 1;
    }

    public int getSequenceLength() {
        return this.getBases().getLength();
    }

    public int[] getStopCodons(Range range) {
        return this.bases.getStopCodons(range, this.getDirection());
    }

    public int[] getMatchingCodons(Range range, StringVector query_codons) {
        return this.bases.getMatchingCodons(range, this.getDirection(), query_codons);
    }

    public static String getCodonAtMarker(Marker marker) {
        try {
            Range codon_range = new Range(marker.getPosition(), marker.getPosition() + 2);
            return marker.getStrand().getSubSequence(codon_range);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public static MarkerRange[] getOpenReadingFrameRanges(MarkerRange search_range, int minimum_size) {
        Strand search_strand = search_range.getStrand();
        MarkerRange[][] frame_ranges = new MarkerRange[3][];
        for (int frame_offset = 0; frame_offset < 3; ++frame_offset) {
            Range sequence_range;
            try {
                sequence_range = new Range(1 + frame_offset, search_strand.getSequenceLength());
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            int[] frame_stop_codons = search_strand.getStopCodons(sequence_range);
            frame_ranges[frame_offset] = search_strand.getORFsFromStopCodons(frame_stop_codons, minimum_size, frame_offset, search_range);
        }
        int max_range_count = frame_ranges[0].length + frame_ranges[1].length + frame_ranges[2].length;
        MarkerRange[] temp_range_array = new MarkerRange[max_range_count];
        int temp_range_array_index = 0;
        for (int i = 0; i < 3; ++i) {
            MarkerRange[] frame_range_array = frame_ranges[i];
            for (int range_index = 0; range_index < frame_range_array.length && frame_ranges[i][range_index] != null; ++range_index) {
                MarkerRange this_range = frame_ranges[i][range_index];
                if (!search_range.overlaps(this_range)) continue;
                temp_range_array[temp_range_array_index] = this_range;
                ++temp_range_array_index;
            }
        }
        MarkerRange[] return_array = new MarkerRange[temp_range_array_index];
        System.arraycopy(temp_range_array, 0, return_array, 0, temp_range_array_index);
        return return_array;
    }

    public static MarkerRange getORFAroundMarker(Marker search_marker, boolean ignore_illegal_codons) {
        Range search_codon_range;
        try {
            search_codon_range = new Range(search_marker.getPosition(), search_marker.getPosition() + 2);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        Strand search_strand = search_marker.getStrand();
        String search_codon_sequence = search_strand.getSubSequence(search_codon_range);
        char search_codon_char = AminoAcidSequence.getCodonTranslation(search_codon_sequence);
        if (AminoAcidSequence.isStopCodon(search_codon_char)) {
            return null;
        }
        Marker start_marker = Strand.getStartOfORF(search_marker, ignore_illegal_codons);
        Marker end_marker = Strand.getEndOfORF(search_marker, ignore_illegal_codons);
        try {
            return new MarkerRange(search_strand, start_marker.getPosition(), end_marker.getPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected OutOfRangeException");
        }
    }

    private static Marker getStartOfORF(Marker search_marker, boolean ignore_illegal_codons) {
        Strand search_strand = search_marker.getStrand();
        Marker current_marker = search_marker;
        Marker previous_marker = search_marker;
        try {
            while (true) {
                Range search_codon_range;
                String codon_sequence;
                if ((codon_sequence = search_strand.getSubSequence(search_codon_range = new Range((current_marker = current_marker.moveBy(-3)).getPosition(), current_marker.getPosition() + 2))).charAt(0) == 'x' || codon_sequence.charAt(1) == 'x' || codon_sequence.charAt(2) == 'x') {
                    return previous_marker;
                }
                char this_codon_char = AminoAcidSequence.getCodonTranslation(codon_sequence);
                if (AminoAcidSequence.isStopCodon(this_codon_char) || !ignore_illegal_codons && !AminoAcidSequence.isLegalCodon(this_codon_char)) {
                    return previous_marker;
                }
                previous_marker = current_marker;
            }
        }
        catch (OutOfRangeException e) {
            return previous_marker;
        }
    }

    private static Marker getEndOfORF(Marker search_marker, boolean ignore_illegal_codons) {
        Strand search_strand = search_marker.getStrand();
        Marker current_marker = null;
        try {
            current_marker = search_marker.moveBy(2);
        }
        catch (OutOfRangeException e) {
            return search_marker;
        }
        Marker previous_marker = current_marker;
        try {
            while (true) {
                Range search_codon_range;
                String codon_sequence;
                if ((codon_sequence = search_strand.getSubSequence(search_codon_range = new Range((current_marker = current_marker.moveBy(3)).getPosition() - 2, current_marker.getPosition()))).charAt(0) == 'x' || codon_sequence.charAt(1) == 'x' || codon_sequence.charAt(2) == 'x') {
                    return previous_marker;
                }
                char this_codon_char = AminoAcidSequence.getCodonTranslation(codon_sequence);
                if (AminoAcidSequence.isStopCodon(this_codon_char) || !ignore_illegal_codons && !AminoAcidSequence.isLegalCodon(this_codon_char)) {
                    return previous_marker;
                }
                previous_marker = current_marker;
            }
        }
        catch (OutOfRangeException e) {
            return previous_marker;
        }
    }

    private MarkerRange[] getORFsFromStopCodons(int[] stop_codons, int minimum_size, int frame_offset, MarkerRange test_range) {
        MarkerRange[] return_array = new MarkerRange[stop_codons.length + 1];
        int return_array_index = 0;
        for (int i = -1; i < stop_codons.length && (i == -1 || stop_codons[i] != 0); ++i) {
            int aa_count;
            int first_base_of_range = i == -1 ? 1 + frame_offset : stop_codons[i] + 3;
            if (first_base_of_range >= this.getSequenceLength()) continue;
            int last_base_of_range = i + 1 == stop_codons.length || stop_codons[i + 1] == 0 ? this.getSequenceLength() : stop_codons[i + 1] + 2;
            if (last_base_of_range >= this.getSequenceLength()) {
                last_base_of_range = this.getSequenceLength();
            }
            if ((aa_count = (last_base_of_range - first_base_of_range) / 3) < minimum_size || last_base_of_range < test_range.getStart().getPosition() || first_base_of_range > test_range.getEnd().getPosition()) continue;
            try {
                return_array[return_array_index] = this.makeMarkerRangeFromPositions(first_base_of_range, last_base_of_range);
                ++return_array_index;
                continue;
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected OutOfRangeException");
            }
        }
        return return_array;
    }

    public Marker makeMarker(int position) throws OutOfRangeException {
        Marker new_marker = new Marker(this, position);
        return new_marker;
    }

    public Marker makeMarkerFromRawPosition(int position) throws OutOfRangeException {
        if (this.getDirection() == 1) {
            return this.makeMarker(position);
        }
        return this.makeMarker(this.getBases().getComplementPosition(position));
    }

    public MarkerRange makeMarkerRangeFromPositions(int start_position, int end_position) throws OutOfRangeException {
        return new MarkerRange(this, start_position, end_position);
    }

    public MarkerRange makeMarkerRangeFromRawPositions(int raw_start_position, int raw_end_position) throws OutOfRangeException {
        if (this.getDirection() == 1) {
            return new MarkerRange(this, raw_start_position, raw_end_position);
        }
        int real_start_position = this.getBases().getComplementPosition(raw_start_position);
        int real_end_position = this.getBases().getComplementPosition(raw_end_position);
        return new MarkerRange(this, real_start_position, real_end_position);
    }

    public int getRawPosition(int strand_position) {
        return this.getBases().getRawPosition(strand_position, this.getDirection());
    }

    public static void deleteRange(MarkerRange range) throws ReadOnlyException {
        range.getStrand().getBases().deleteRange(range.getRawRange());
    }

    public static void addBases(Marker position, String bases_string) throws ReadOnlyException, IllegalSymbolException {
        Bases bases = position.getStrand().getBases();
        if (position.getStrand().isForwardStrand()) {
            bases.addBases(position.getRawPosition(), 1, bases_string);
        } else {
            bases.addBases(position.getRawPosition(), 2, bases_string);
        }
    }

    public AminoAcidSequence getTranslation(Range range, boolean unknown_is_x) {
        return this.getBases().getTranslation(range, this.getDirection(), unknown_is_x);
    }

    public String getSubSequence(Range range) {
        return this.getBases().getSubSequence(range, this.getDirection());
    }

    public String getRawSubSequence(Range range) {
        return this.getBases().getSubSequence(range, 1);
    }

    public static String markerRangeBases(MarkerRange marker_range) {
        return marker_range.getStrand().getSubSequence(marker_range.getRange());
    }

    public int getACount() {
        if (this.isForwardStrand()) {
            return this.getBases().getACount();
        }
        return this.getBases().getTCount();
    }

    public int getTCount() {
        if (this.isForwardStrand()) {
            return this.getBases().getTCount();
        }
        return this.getBases().getACount();
    }

    public int getGCount() {
        if (this.isForwardStrand()) {
            return this.getBases().getGCount();
        }
        return this.getBases().getCCount();
    }

    public int getCCount() {
        if (this.isForwardStrand()) {
            return this.getBases().getCCount();
        }
        return this.getBases().getGCount();
    }
}

