/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.gui;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.util.gui.ImageFactory;
import uk.ac.sanger.util.gui.ImageFactoryDefaultImpl;

public class JobTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon cancelledIcon;
    private ImageIcon completedIcon;
    private ImageIcon failedIcon;
    private ImageIcon readyIcon;
    private ImageIcon startedIcon;
    private ImageIcon skippedIcon;
    private ImageIcon waitingIcon;
    private StringBuffer sb;

    public JobTreeCellRenderer() throws Exception {
        ImageFactory imFactory = ImageFactoryDefaultImpl.getInstance();
        this.waitingIcon = new ImageIcon(imFactory.createImage("amber_light"));
        this.readyIcon = new ImageIcon(imFactory.createImage("green_light"));
        this.startedIcon = new ImageIcon(imFactory.createImage("blue_ring"));
        this.completedIcon = new ImageIcon(imFactory.createImage("blue_light"));
        this.failedIcon = new ImageIcon(imFactory.createImage("red_light"));
        this.cancelledIcon = new ImageIcon(imFactory.createImage("amber_light"));
        this.skippedIcon = new ImageIcon(imFactory.createImage("yellow_light"));
        this.sb = new StringBuffer();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        Job job = (Job)value;
        this.setIcon(this.selectStatusIcon(job.getStatus()));
        this.sb.setLength(0);
        this.sb.append("Job [");
        this.sb.append(job.getId());
        this.sb.append("] ");
        this.sb.append(job.getExecutable().getDescription());
        this.sb.append(" [");
        String op = job.getOperator();
        if (op.equals("AND")) {
            this.sb.append("OP: &&");
        } else {
            this.sb.append("OP: ||");
        }
        this.sb.append("] ");
        this.sb.append(job.getStatus().getDescription());
        this.sb.append(" after ");
        this.sb.append(job.getRetryCount());
        this.sb.append(" retries (max. ");
        this.sb.append(job.getMaxRetryCount());
        this.sb.append(")");
        this.setText(this.sb.substring(0));
        return this;
    }

    protected ImageIcon selectStatusIcon(Status status) {
        int statusId = status.getId();
        switch (statusId) {
            case 1: {
                return this.waitingIcon;
            }
            case 2: {
                return this.readyIcon;
            }
            case 3: {
                return this.startedIcon;
            }
            case 4: {
                return this.completedIcon;
            }
            case 5: {
                return this.failedIcon;
            }
            case 6: {
                return this.cancelledIcon;
            }
            case 7: {
                return this.skippedIcon;
            }
        }
        throw new IllegalArgumentException("No Job icon for Status [" + statusId + "] " + status.getDescription());
    }
}

