/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.util.StringTokenizer;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.lsf.LSFBsubExec;
import uk.ac.sanger.jcon.run.CommandLineFactory;
import uk.ac.sanger.jcon.run.Processor;
import uk.ac.sanger.jcon.run.ProcessorFactory;

public final class ProcessorLSFImpl
implements Processor {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$ProcessorLSFImpl == null ? (class$uk$ac$sanger$jcon$run$ProcessorLSFImpl = ProcessorLSFImpl.class$("uk.ac.sanger.jcon.run.ProcessorLSFImpl")) : class$uk$ac$sanger$jcon$run$ProcessorLSFImpl).getName());
    public static final ProcessorFactory FACTORY = new ProcessorFactory(){

        public Processor createProcessor(CommandLineFactory clFactory, StatusDAO statusDAO) {
            return new ProcessorLSFImpl(clFactory, statusDAO);
        }
    };
    private CommandLineFactory clFactory;
    private StatusDAO statusDAO;
    private boolean isFree;
    private Job job;
    private String inputName;
    private String outputName;
    private String errorName;
    private String workDirectory;
    private String environment;
    private String command;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$ProcessorLSFImpl;

    public Job getJob() {
        return this.job;
    }

    public boolean getFree() {
        return this.isFree;
    }

    public void setFree(boolean isFree) {
        this.isFree = isFree;
        if (isFree) {
            this.job = null;
        }
    }

    public ProcessorLSFImpl(CommandLineFactory clFactory, StatusDAO statusDAO) {
        this.clFactory = clFactory;
        this.statusDAO = statusDAO;
        this.isFree = true;
    }

    public void process(Job job) throws Exception {
        if (!(job instanceof BatchJob)) {
            throw new JobControlException("Failed to process Job [" + job.getId() + "] as it was not a batch job");
        }
        if (!this.getFree()) {
            throw new JobControlException("Failed to process Job as Processor is not free");
        }
        this.setFree(false);
        this.job = job;
        BatchJob lsfJob = (BatchJob)job;
        String[] env = null;
        if (this.environment != null) {
            env = this.stringTokenize(this.environment);
        }
        this.command = this.clFactory.createCommandLine(job);
        String jobIdStr = Integer.toString(lsfJob.getId());
        cat.info((Object)("Running batch Job [" + jobIdStr + "] command '" + this.command + "'"));
        LSFBsubExec lbs = LSFBsubExec.getInstance();
        int lsfJobId = lbs.submit(jobIdStr, lsfJob.getQueue(), lsfJob.getInputName(), lsfJob.getOutputName(), lsfJob.getErrorName(), this.command, env, lsfJob.getWorkDirectoryName());
        cat.debug((Object)("Obtained new LSF Job ID " + lsfJobId + " for Job [" + jobIdStr + "]"));
        lsfJob.setBatchId(lsfJobId);
        lsfJob.setStatus(this.statusDAO.readStatusById(3));
    }

    private String[] stringTokenize(String string) {
        StringTokenizer st = new StringTokenizer(string);
        int count = st.countTokens();
        String[] tokens = new String[count];
        int i = 0;
        while (i < count) {
            tokens[i] = st.nextToken();
            ++i;
        }
        return tokens;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

