/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.Arrays;
import java.util.List;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class LightPairDPCursor
implements PairDPCursor {
    private int[] pos;
    private boolean flip;
    private SymbolList[] seqs;
    private double[][][] columns;
    private double[][][] emissions;
    protected BackPointer[][][] bPointers;
    protected int numStates;
    protected double[] zeroCol;
    protected BackPointer[] emptyBP;
    protected int[] depth;
    protected EmissionCache eCache;

    public LightPairDPCursor(SymbolList seq1, SymbolList seq2, int depth1, int depth2, int numStates, EmissionCache eCache) throws IllegalSymbolException {
        int i;
        this.numStates = numStates;
        this.zeroCol = new double[this.numStates];
        for (i = 0; i < this.zeroCol.length; ++i) {
            this.zeroCol[i] = Double.NaN;
        }
        this.emptyBP = new BackPointer[numStates];
        this.pos = new int[2];
        this.pos[0] = 0;
        this.pos[1] = 0;
        this.seqs = new SymbolList[2];
        this.seqs[0] = seq1;
        this.seqs[1] = seq2;
        this.depth = new int[2];
        this.depth[0] = depth1;
        this.depth[1] = depth2;
        this.eCache = eCache;
        boolean bl = this.flip = this.seqs[1].length() > this.seqs[0].length();
        if (this.flip) {
            this.columns = new double[this.depth[0]][this.seqs[1].length() + 2][numStates];
            this.emissions = new double[this.depth[0]][this.seqs[1].length() + 2][];
            this.bPointers = new BackPointer[this.depth[0]][this.seqs[1].length() + 2][numStates];
        } else {
            this.columns = new double[this.depth[1]][this.seqs[0].length() + 2][numStates];
            this.emissions = new double[this.depth[1]][this.seqs[0].length() + 2][];
            this.bPointers = new BackPointer[this.depth[1]][this.seqs[0].length() + 2][numStates];
        }
        for (i = 0; i < this.columns.length; ++i) {
            double[][] ci = this.columns[i];
            for (int j = 0; j < ci.length; ++j) {
                double[] cj = ci[j];
                for (int k = 0; k < cj.length; ++k) {
                    cj[k] = Double.NaN;
                }
            }
        }
        this.calcEmissions(this.emissions[0]);
    }

    public int[] getDepth() {
        return this.depth;
    }

    public boolean hasNext() {
        int i = this.flip ? 0 : 1;
        return this.pos[i] <= this.seqs[i].length() + 1;
    }

    public Cell[][] press() {
        Cell[][] cells = new Cell[this.depth[0]][this.depth[1]];
        for (int i = 0; i < cells.length; ++i) {
            Cell[] ci = cells[i];
            for (int j = 0; j < ci.length; ++j) {
                ci[j] = new Cell();
            }
        }
        return cells;
    }

    public void next(Cell[][] cells) throws IllegalSymbolException {
        if (this.flip) {
            for (int i = 0; i < this.depth[0]; ++i) {
                int ii = this.pos[0] - i;
                boolean outI = ii < 0 || ii > this.seqs[0].length() + 1;
                Cell[] cellI = cells[i];
                double[][] columnsI = this.columns[i];
                double[][] emissionsI = this.emissions[i];
                BackPointer[][] bPointersI = this.bPointers[i];
                for (int j = 0; j < this.depth[1]; ++j) {
                    int jj = this.pos[1] - j;
                    boolean outJ = jj < 0 || jj > this.seqs[1].length() + 1;
                    Cell c = cellI[j];
                    if (outI || outJ) {
                        c.scores = this.zeroCol;
                        c.emissions = this.zeroCol;
                        c.backPointers = this.emptyBP;
                        continue;
                    }
                    c.scores = columnsI[jj];
                    c.emissions = emissionsI[jj];
                    c.backPointers = bPointersI[jj];
                }
            }
            if (this.pos[1] <= this.seqs[1].length()) {
                this.pos[1] = this.pos[1] + 1;
            } else {
                this.pos[1] = 0;
                this.pos[0] = this.pos[0] + 1;
                int depth = this.depth[0];
                double[][] tempC = this.columns[depth - 1];
                double[][] tempE = this.emissions[depth - 1];
                BackPointer[][] tempBP = this.bPointers[depth - 1];
                for (int i = 1; i < depth; ++i) {
                    this.columns[i] = this.columns[i - 1];
                    this.emissions[i] = this.emissions[i - 1];
                    this.bPointers[i] = this.bPointers[i - 1];
                }
                this.columns[0] = tempC;
                this.emissions[0] = tempE;
                this.bPointers[0] = tempBP;
                this.calcEmissions(tempE);
            }
        } else {
            for (int i = 0; i < this.depth[1]; ++i) {
                int ii = this.pos[1] - i;
                boolean outI = ii < 0 || ii > this.seqs[1].length() + 1;
                double[][] columnsI = this.columns[i];
                double[][] emissionsI = this.emissions[i];
                BackPointer[][] bPointersI = this.bPointers[i];
                for (int j = 0; j < this.depth[0]; ++j) {
                    int jj = this.pos[0] - j;
                    boolean outJ = jj < 0 || jj > this.seqs[0].length() + 1;
                    Cell c = cells[j][i];
                    if (outI || outJ) {
                        c.scores = this.zeroCol;
                        c.emissions = this.zeroCol;
                        c.backPointers = this.emptyBP;
                        continue;
                    }
                    c.scores = columnsI[jj];
                    c.emissions = emissionsI[jj];
                    c.backPointers = bPointersI[jj];
                }
            }
            if (this.pos[0] <= this.seqs[0].length()) {
                this.pos[0] = this.pos[0] + 1;
            } else {
                this.pos[0] = 0;
                this.pos[1] = this.pos[1] + 1;
                int depth = this.depth[1];
                double[][] tempC = this.columns[depth - 1];
                double[][] tempE = this.emissions[depth - 1];
                BackPointer[][] tempBP = this.bPointers[depth - 1];
                for (int i = 1; i < depth; ++i) {
                    this.columns[i] = this.columns[i - 1];
                    this.emissions[i] = this.emissions[i - 1];
                    this.bPointers[i] = this.bPointers[i - 1];
                }
                this.columns[0] = tempC;
                this.emissions[0] = tempE;
                this.bPointers[0] = tempBP;
                this.calcEmissions(tempE);
            }
        }
    }

    private void calcEmissions(double[][] em) throws IllegalSymbolException {
        if (this.flip) {
            Symbol[] symL = new Symbol[2];
            List<Symbol> symList = Arrays.asList(symL);
            int i = this.pos[0];
            symL[0] = i < 1 || i > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(i);
            for (int j = 0; j <= this.seqs[1].length() + 1; ++j) {
                symL[1] = j < 1 || j > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(j);
                em[j] = this.eCache.getEmissions(symList, !(i < 1 && j < 1 || i > this.seqs[0].length() && j > this.seqs[1].length()));
            }
        } else {
            Symbol[] symL = new Symbol[2];
            List<Symbol> symList = Arrays.asList(symL);
            int j = this.pos[1];
            symL[1] = j < 1 || j > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(j);
            for (int i = 0; i <= this.seqs[0].length() + 1; ++i) {
                symL[0] = i < 1 || i > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(i);
                em[i] = this.eCache.getEmissions(symList, !(i < 1 && j < 1 || i > this.seqs[0].length() && j > this.seqs[1].length()));
            }
        }
    }
}

