/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Font;
import java.awt.geom.Point2D;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class HeadlessRenderContext
implements SequenceRenderContext {
    private static final Font FONT = new Font(null, 0, 10);
    private final RangeLocation range;
    private final double scale;
    private final Sequence seq;
    private final double offset;

    public HeadlessRenderContext(Sequence seq, RangeLocation range, int width) {
        this.seq = seq;
        this.range = range;
        this.scale = (double)width / (double)(range.getMax() - range.getMin() + 1);
        this.offset = -((double)range.getMin() * this.scale);
    }

    public int getDirection() {
        return 0;
    }

    public FeatureHolder getFeatures() {
        return this.seq;
    }

    public Font getFont() {
        return FONT;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return new SequenceRenderContext.Border();
    }

    public RangeLocation getRange() {
        return this.range;
    }

    public double getScale() {
        return this.scale;
    }

    public SymbolList getSymbols() {
        return this.seq;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return new SequenceRenderContext.Border();
    }

    public double sequenceToGraphics(int i) {
        return (double)(i - 1) * this.scale + this.offset;
    }

    public int graphicsToSequence(Point2D point) {
        return this.graphicsToSequence(point.getX());
    }

    public int graphicsToSequence(double d) {
        return (int)((d - this.offset) / this.scale) + 1;
    }
}

