/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;

public final class ProjectedFeatureHolder
extends AbstractFeatureHolder
implements FeatureHolder,
Serializable {
    private final ProjectionContext context;
    private final transient ChangeListener underlyingFeaturesChange = new ChangeListener(){

        public void preChange(ChangeEvent e) throws ChangeVetoException {
            ChangeEvent cev2;
            if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES).firePreChangeEvent(cev2);
            }
        }

        public void postChange(ChangeEvent e) {
            ChangeEvent cev2;
            if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES).firePostChangeEvent(cev2);
            }
        }
    };
    private FeatureHolder topLevelFeatures;

    public ProjectedFeatureHolder(ProjectionContext context) {
        this.context = context;
        context.getUnprojectedFeatures().addChangeListener(this.underlyingFeaturesChange);
    }

    public ProjectionContext getContext() {
        return this.context;
    }

    private FeatureHolder getTopLevelFeatures() {
        if (this.topLevelFeatures == null) {
            this.topLevelFeatures = this.makeProjectionSet(this.context.getUnprojectedFeatures());
        }
        return this.topLevelFeatures;
    }

    public Iterator features() {
        return this.getTopLevelFeatures().features();
    }

    public int countFeatures() {
        return this.getTopLevelFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getTopLevelFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getTopLevelFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getTopLevelFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
        return this.context.createFeature(templ);
    }

    public void removeFeature(Feature dyingChild) throws ChangeVetoException, BioException {
        this.context.removeFeature(dyingChild);
    }

    public FeatureFilter getSchema() {
        return this.getTopLevelFeatures().getSchema();
    }

    protected FeatureHolder makeProjectionSet(FeatureHolder fh) {
        return this.context.projectFeatures(fh);
    }

    protected ChangeEvent forwardChangeEvent(ChangeEvent cev) {
        return new ChangeEvent(this, cev.getType(), cev.getChange(), cev.getPrevious(), cev);
    }
}

