/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;

class EmptyLocation
implements Location,
Serializable {
    EmptyLocation() {
    }

    public Location getDecorator(Class decoratorClass) {
        if (decoratorClass.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Location newInstance(Location loc) {
        return loc;
    }

    public int getMin() {
        return Integer.MAX_VALUE;
    }

    public int getMax() {
        return Integer.MIN_VALUE;
    }

    public boolean overlaps(Location l) {
        return false;
    }

    public boolean contains(Location l) {
        return false;
    }

    public boolean contains(int p) {
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Location) {
            if (o instanceof EmptyLocation) {
                return true;
            }
            return Location.naturalOrder.areEqual(this, (Location)o);
        }
        return false;
    }

    public Location intersection(Location l) {
        return empty;
    }

    public Location union(Location l) {
        return l;
    }

    public SymbolList symbols(SymbolList seq) {
        try {
            return new SimpleSymbolList(seq.getAlphabet(), new ArrayList());
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    public Location translate(int dist) {
        return this;
    }

    public boolean isContiguous() {
        return true;
    }

    public Iterator blockIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder(Location.class.getField("empty"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public String toString() {
        return "{}";
    }
}

