/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.AbstractOrderNDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

class IndexedNthOrderDistribution
extends AbstractOrderNDistribution
implements Serializable {
    private transient Distribution[] dists;
    private transient AlphabetIndex index;
    private static final long serialVersionUID = 3847329L;
    private DistributionFactory df;

    IndexedNthOrderDistribution(Alphabet alpha, DistributionFactory df) throws IllegalAlphabetException {
        super(alpha);
        FiniteAlphabet conditioning = (FiniteAlphabet)this.getConditioningAlphabet();
        this.index = AlphabetManager.getAlphabetIndex(conditioning);
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.df = df;
        this.dists = new Distribution[conditioning.size()];
        int i = 0;
        while (i < conditioning.size()) {
            this.dists[i] = df.createDistribution(this.getConditionedAlphabet());
            ++i;
        }
    }

    public void setDistribution(Symbol sym, Distribution dist) throws IllegalSymbolException, IllegalAlphabetException {
        int indx = this.index.indexForSymbol(sym);
        if (dist.getAlphabet() != this.getConditionedAlphabet()) {
            throw new IllegalAlphabetException("The distribution must be over " + this.getConditionedAlphabet() + ", not " + dist.getAlphabet());
        }
        Distribution old = this.dists[indx];
        if (old != null && this.weightForwarder != null) {
            old.removeChangeListener(this.weightForwarder);
        }
        if (this.weightForwarder != null) {
            dist.addChangeListener(this.weightForwarder);
        }
        this.dists[indx] = dist;
    }

    public Distribution getDistribution(Symbol sym) throws IllegalSymbolException {
        return this.dists[this.index.indexForSymbol(sym)];
    }

    public Collection conditionedDistributions() {
        return Arrays.asList(this.dists);
    }

    protected void writeObject(ObjectOutputStream stream) throws IOException {
        int size = ((FiniteAlphabet)this.getConditioningAlphabet()).size();
        this.symbolIndices = new HashMap(size);
        int i = 0;
        while (i < size) {
            this.symbolIndices.put(this.index.symbolForIndex(i).getName(), this.dists[i]);
            ++i;
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.index = AlphabetManager.getAlphabetIndex((FiniteAlphabet)this.getConditioningAlphabet());
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        int len = this.index.getAlphabet().size();
        this.dists = new Distribution[len];
        try {
            int i = 0;
            while (i < len) {
                Symbol s = this.index.symbolForIndex(i);
                Distribution d = (Distribution)this.symbolIndices.get(s);
                if (d == null) {
                    d = this.df.createDistribution(this.getConditionedAlphabet());
                }
                this.dists[this.index.indexForSymbol((Symbol)s)] = d;
                ++i;
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise);
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError(iae);
        }
    }
}

