/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.TranslatedDistribution;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelInState;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

class FlatModel
extends AbstractChangeable
implements MarkovModel,
Serializable {
    private final MarkovModel source;
    private final MarkovModel delegate;

    protected void addAState(State ourState) throws IllegalSymbolException {
        try {
            this.delegate.addState(ourState);
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "This model should be ours with no listeners");
        }
    }

    public Alphabet emissionAlphabet() {
        return this.delegate.emissionAlphabet();
    }

    public FiniteAlphabet stateAlphabet() {
        return this.delegate.stateAlphabet();
    }

    public int heads() {
        return this.delegate.heads();
    }

    public MagicalState magicalState() {
        return this.delegate.magicalState();
    }

    public Distribution getWeights(State source) throws IllegalSymbolException {
        return this.delegate.getWeights(source);
    }

    public boolean containsTransition(State from, State to) throws IllegalSymbolException {
        return this.delegate.containsTransition(from, to);
    }

    public FiniteAlphabet transitionsFrom(State from) throws IllegalSymbolException {
        return this.delegate.transitionsFrom(from);
    }

    public FiniteAlphabet transitionsTo(State to) throws IllegalSymbolException {
        return this.delegate.transitionsTo(to);
    }

    public void setWeights(State source, Distribution dist) throws ChangeVetoException {
        throw new ChangeVetoException("Can't set weights in immutable view");
    }

    public FlatModel(MarkovModel model) throws IllegalSymbolException, IllegalAlphabetException {
        this.source = model;
        this.delegate = new SimpleMarkovModel(this.source.heads(), this.source.emissionAlphabet(), "flat");
        HashMap<State, Wrapper> toM = new HashMap<State, Wrapper>();
        HashMap<State, MarkovModel> inModel = new HashMap<State, MarkovModel>();
        HashMap<ModelInState, DotStateWrapper> misStart = new HashMap<ModelInState, DotStateWrapper>();
        HashMap<ModelInState, DotStateWrapper> misEnd = new HashMap<ModelInState, DotStateWrapper>();
        HashMap<MarkovModel, AbstractChangeable> modelStart = new HashMap<MarkovModel, AbstractChangeable>();
        HashMap<MarkovModel, AbstractChangeable> modelEnd = new HashMap<MarkovModel, AbstractChangeable>();
        Iterator i = model.stateAlphabet().iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            if (s instanceof DotState) {
                DotStateWrapper dsw = new DotStateWrapper(s);
                this.addAState(dsw);
                inModel.put(s, model);
                toM.put(s, dsw);
                continue;
            }
            if (s instanceof EmissionState) {
                if (s instanceof MagicalState) {
                    modelStart.put(model, model.magicalState());
                    modelEnd.put(model, model.magicalState());
                    continue;
                }
                EmissionWrapper esw = new EmissionWrapper((EmissionState)s);
                this.addAState(esw);
                inModel.put(s, model);
                toM.put(s, esw);
                continue;
            }
            if (s instanceof ModelInState) {
                ModelInState mis = (ModelInState)s;
                MarkovModel flatM = DP.flatView(mis.getModel());
                DotStateWrapper start = new DotStateWrapper(mis, "start");
                DotStateWrapper end = new DotStateWrapper(mis, "end");
                this.addAState(start);
                this.addAState(end);
                inModel.put(mis, model);
                modelStart.put(flatM, start);
                modelEnd.put(flatM, end);
                misStart.put(mis, start);
                misEnd.put(mis, end);
                Iterator j = flatM.stateAlphabet().iterator();
                while (j.hasNext()) {
                    State t = (State)j.next();
                    if (t instanceof DotState) {
                        DotStateWrapper dsw = new DotStateWrapper(t);
                        this.addAState(dsw);
                        inModel.put(t, flatM);
                        toM.put(t, dsw);
                        toM.put(((Wrapper)t).getWrapped(), dsw);
                        continue;
                    }
                    if (t instanceof EmissionState) {
                        if (t instanceof MagicalState) continue;
                        EmissionWrapper esw = new EmissionWrapper((EmissionState)t);
                        this.addAState(esw);
                        inModel.put(t, flatM);
                        toM.put(t, esw);
                        continue;
                    }
                    throw new IllegalSymbolException(s, "Don't know how to handle state: " + s.getName());
                }
                continue;
            }
            throw new IllegalSymbolException(s, "Don't know how to handle state: " + s.getName());
        }
        Iterator i2 = this.delegate.stateAlphabet().iterator();
        while (i2.hasNext()) {
            MarkovModel sModel;
            State sOrig;
            State s = (State)i2.next();
            if (s instanceof MagicalState) {
                sOrig = s;
                sModel = model;
            } else {
                Wrapper swrapper = (Wrapper)s;
                State swrapped = swrapper.getWrapped();
                MarkovModel subModel = (MarkovModel)inModel.get(swrapped);
                if (subModel != model) {
                    sOrig = swrapped;
                    sModel = subModel;
                } else if (swrapper instanceof ModelInState) {
                    if (swrapper == modelStart.get(subModel)) {
                        sModel = ((ModelInState)swrapped).getModel();
                        sOrig = sModel.magicalState();
                    } else {
                        sModel = model;
                        sOrig = swrapped;
                    }
                } else {
                    sModel = model;
                    sOrig = s;
                }
            }
            TranslatedDistribution dist = null;
            SimpleReversibleTranslationTable table = (SimpleReversibleTranslationTable)dist.getTable();
            try {
                this.delegate.setWeights(s, dist);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve, "Couldn't edit delegate model");
            }
            table.setTranslation(s, sOrig);
            Iterator j = sModel.transitionsFrom(sOrig).iterator();
            while (j.hasNext()) {
                State tOrig = (State)j.next();
                State t = tOrig instanceof MagicalState ? (sModel == model ? tOrig : (State)modelEnd.get(sModel)) : (State)toM.get(sOrig);
                table.setTranslation(t, tOrig);
            }
        }
    }

    public void createTransition(State from, State to) throws IllegalSymbolException, UnsupportedOperationException {
        FiniteAlphabet a = this.stateAlphabet();
        a.validate(from);
        a.validate(to);
        throw new UnsupportedOperationException("createTransition not supported by FlatModel");
    }

    public void destroyTransition(State from, State to) throws IllegalSymbolException, UnsupportedOperationException {
        FiniteAlphabet a = this.stateAlphabet();
        a.validate(from);
        a.validate(to);
        throw new UnsupportedOperationException("destroyTransition not supported by FlatModel");
    }

    public void addState(State toAdd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addState not supported by FlatModel");
    }

    public void removeState(State toGo) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("removeState not supported by FlatModel");
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) {
        modelTrainer.registerModel(this.delegate);
    }

    private static class EmissionWrapper
    extends Wrapper
    implements EmissionState {
        private EmissionState getWrappedES() {
            return (EmissionState)this.getWrapped();
        }

        public void setAdvance(int[] advance) throws ChangeVetoException {
            this.getWrappedES().setAdvance(advance);
        }

        public int[] getAdvance() {
            return this.getWrappedES().getAdvance();
        }

        public Distribution getDistribution() {
            return this.getWrappedES().getDistribution();
        }

        public void setDistribution(Distribution dis) throws ChangeVetoException {
            this.getWrappedES().setDistribution(dis);
        }

        public void registerWithTrainer(ModelTrainer trainer) {
        }

        public EmissionWrapper(EmissionState wrapped) {
            this(wrapped, "-f");
        }

        public EmissionWrapper(EmissionState wrapped, String extra) {
            super(wrapped, extra);
        }
    }

    private static class DotStateWrapper
    extends Wrapper
    implements DotState {
        public DotStateWrapper(State wrapped, String extra) {
            super(wrapped, extra);
        }

        public DotStateWrapper(State wrapped) throws NullPointerException {
            this(wrapped, "f");
        }
    }

    private static class Wrapper
    extends AbstractChangeable
    implements State,
    Serializable {
        private final State wrapped;
        private final String extra;
        private final Alphabet matches;
        protected transient ChangeSupport changeSupport = null;

        public String getName() {
            return this.wrapped.getName() + "-" + this.extra;
        }

        public Annotation getAnnotation() {
            return this.wrapped.getAnnotation();
        }

        public State getWrapped() {
            return this.wrapped;
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public Wrapper(State wrapped, String extra) {
            if (wrapped == null) {
                throw new NullPointerException("Can't wrap null");
            }
            this.wrapped = wrapped;
            this.extra = extra;
            this.matches = new SingletonAlphabet(this);
        }
    }
}

