/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.DataStoreFactory;
import org.biojava.bio.program.ssaha.MappedDataStore;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.utils.Constants;

public class MappedDataStoreFactory
implements DataStoreFactory {
    public DataStore getDataStore(File storeFile) throws IOException {
        return new MappedDataStore(storeFile);
    }

    public DataStore buildDataStore(File storeFile, SequenceDB seqDB, Packing packing, int wordLength, int threshold) throws IllegalAlphabetException, IOException, BioException {
        ByteArrayOutputStream packingStream = new ByteArrayOutputStream();
        ObjectOutputStream packingSerializer = new ObjectOutputStream(packingStream);
        packingSerializer.writeObject(packing);
        packingSerializer.flush();
        int structDataSize = 6 * Constants.BYTES_IN_INT + packingStream.toByteArray().length;
        storeFile.createNewFile();
        RandomAccessFile store = new RandomAccessFile(storeFile, "rw");
        FileChannel channel = store.getChannel();
        int words = 1 << packing.wordSize() * wordLength;
        int hashTablePos = structDataSize;
        int hashTableSize = Constants.BYTES_IN_INT + words * Constants.BYTES_IN_INT;
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_WRITE, hashTablePos, hashTableSize);
        IntBuffer hashTable = hashTable_MB.asIntBuffer();
        hashTable.put(0, hashTableSize);
        int i = 0;
        while (i < words) {
            hashTable.put(i + 1, 0);
            ++i;
        }
        hashTable.position(0);
        int seqCount = 0;
        int nameChars = 0;
        SequenceIterator i2 = seqDB.sequenceIterator();
        while (i2.hasNext()) {
            Sequence seq = i2.nextSequence();
            if (seq.length() <= wordLength) continue;
            ++seqCount;
            nameChars += seq.getName().length();
            int word = PackingFactory.primeWord(seq, wordLength, packing);
            this.addCount(hashTable, word);
            int j = wordLength + 1;
            while (j <= seq.length()) {
                word = PackingFactory.nextWord(seq, word, j, wordLength, packing);
                this.addCount(hashTable, word);
                ++j;
            }
        }
        int nameArrayPos = hashTablePos + hashTableSize;
        int nameArraySize = (seqCount + 1) * Constants.BYTES_IN_INT;
        MappedByteBuffer nameArray_MB = channel.map(FileChannel.MapMode.READ_WRITE, nameArrayPos, nameArraySize);
        IntBuffer nameArray = nameArray_MB.asIntBuffer();
        nameArray.put(0, nameArraySize);
        int nameTablePos = nameArrayPos + nameArraySize;
        int nameTableSize = Constants.BYTES_IN_INT + seqCount * Constants.BYTES_IN_INT + nameChars * Constants.BYTES_IN_CHAR;
        MappedByteBuffer nameTable = channel.map(FileChannel.MapMode.READ_WRITE, nameTablePos, nameTableSize);
        nameTable.putInt(0, nameTableSize);
        nameTable.position(Constants.BYTES_IN_INT);
        int kmersUsed = 0;
        int hitCount = 0;
        int i3 = 0;
        while (i3 < words) {
            int counts = hashTable.get(i3 + 1);
            if (counts > 0 && counts < threshold) {
                ++hitCount;
                kmersUsed += counts;
            }
            ++i3;
        }
        int hitTablePos = nameTablePos + nameTableSize;
        long hitTableSize = (long)Constants.BYTES_IN_INT + (long)kmersUsed * (long)(Constants.BYTES_IN_INT + Constants.BYTES_IN_INT) + (long)hitCount * (long)Constants.BYTES_IN_INT;
        MappedByteBuffer hitTable = channel.map(FileChannel.MapMode.READ_WRITE, hitTablePos, (int)hitTableSize);
        hitTable.putInt(0, (int)hitTableSize);
        hitTable.position(Constants.BYTES_IN_INT);
        int hitOffset = 0;
        int i4 = 0;
        while (i4 < words) {
            int counts = hashTable.get(i4 + 1);
            if (counts > 0 && counts < threshold) {
                try {
                    if (hitOffset < 0) {
                        throw new IndexOutOfBoundsException("Hit offset negative");
                    }
                    hashTable.put(i4 + 1, hitOffset);
                    hitTable.putInt(hitOffset + Constants.BYTES_IN_INT, 0);
                    hitOffset += Constants.BYTES_IN_INT + counts * (Constants.BYTES_IN_INT + Constants.BYTES_IN_INT);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("counts:\t" + counts);
                    System.out.println("word:\t" + i4);
                    System.out.println("hitOffset:\t" + hitOffset);
                    throw e;
                }
            } else {
                hashTable.put(i4 + 1, -1);
            }
            ++i4;
        }
        int seqNumber = 0;
        nameTable.position(Constants.BYTES_IN_INT);
        SequenceIterator i5 = seqDB.sequenceIterator();
        while (i5.hasNext()) {
            Sequence seq = i5.nextSequence();
            if (seq.length() <= wordLength) continue;
            try {
                nameArray.put(seqNumber + 1, nameTable.position() - Constants.BYTES_IN_INT);
                String name = seq.getName();
                nameTable.putInt(name.length());
                int j = 0;
                while (j < name.length()) {
                    nameTable.putChar(name.charAt(j));
                    ++j;
                }
                int word = PackingFactory.primeWord(seq, wordLength, packing);
                this.writeRecord(hashTable, hitTable, 1, seqNumber, word);
                int j2 = wordLength + 1;
                while (j2 <= seq.length()) {
                    word = PackingFactory.nextWord(seq, word, j2, wordLength, packing);
                    this.writeRecord(hashTable, hitTable, j2 - wordLength + 1, seqNumber, word);
                    ++j2;
                }
            }
            catch (BufferOverflowException e) {
                System.out.println("name:\t" + seq.getName());
                System.out.println("seqNumber:\t" + seqNumber);
                System.out.println("na pos:\t" + nameArray.position());
                System.out.println("nt pos:\t" + nameTable.position());
                throw e;
            }
            ++seqNumber;
        }
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, structDataSize);
        rootBuffer.position(0);
        rootBuffer.putInt(hashTablePos);
        rootBuffer.putInt(hitTablePos);
        rootBuffer.putInt(nameArrayPos);
        rootBuffer.putInt(nameTablePos);
        rootBuffer.putInt(wordLength);
        rootBuffer.putInt(packingStream.toByteArray().length);
        rootBuffer.put(packingStream.toByteArray());
        rootBuffer.force();
        hashTable_MB.force();
        hitTable.force();
        nameArray_MB.force();
        nameTable.force();
        return this.getDataStore(storeFile);
    }

    private void addCount(IntBuffer buffer, int word) {
        int count = buffer.get(word + 1);
        buffer.put(word + 1, ++count);
    }

    private void writeRecord(IntBuffer hashTable, MappedByteBuffer hitTable, int offset, int seqNumber, int word) {
        int kmerPointer = hashTable.get(word + 1);
        if (kmerPointer != -1) {
            int hitCount = hitTable.getInt(kmerPointer += Constants.BYTES_IN_INT);
            int pos = kmerPointer + hitCount * (Constants.BYTES_IN_INT + Constants.BYTES_IN_INT) + Constants.BYTES_IN_INT;
            hitTable.position(pos);
            hitTable.putInt(seqNumber);
            hitTable.putInt(offset);
            hitTable.putInt(kmerPointer, hitCount + 1);
        }
    }

    private void validateNames(int nameCount, IntBuffer nameArray, MappedByteBuffer nameTable) {
        int ni = 0;
        while (ni < nameCount) {
            int pos = nameArray.get(ni + 1);
            if (pos < 0) {
                throw new Error("Negative pos at index: " + ni);
            }
            int length = nameTable.getInt(Constants.BYTES_IN_INT + pos);
            if (length < 1 || length > 100) {
                throw new Error("Silly sequence length for " + ni + " : " + length);
            }
            StringBuffer buff = new StringBuffer(length);
            int ci = 0;
            while (ci < length) {
                buff.append(nameTable.getChar(Constants.BYTES_IN_INT + pos + Constants.BYTES_IN_INT + Constants.BYTES_IN_CHAR * ci));
                ++ci;
            }
            System.out.println(ni + " " + buff);
            ++ni;
        }
    }
}

