/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.ProteaseManager;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class Protease
implements Serializable {
    public static final String TRYPSIN = "Trypsin";
    public static final String LYS_C = "Lys-C";
    public static final String ARG_C = "Arg-C";
    public static final String ASP_N = "Asp-N";
    public static final String GLU_C_BICARB = "Glu-C-bicarbonate";
    public static final String GLU_C_PHOS = "Glu-C-phosphate";
    public static final String CHYMOTRYP = "Chymotrypsin";
    public static final String CNBr = "CNBr";
    private SymbolList cleavageResidues;
    private SymbolList notCleaveResidues;
    private boolean endoProtease = true;
    private String name;

    protected Protease(SymbolList cleaveRes, boolean endoProtease, SymbolList notCleaveRes, String name) throws IllegalSymbolException {
        if (cleaveRes.getAlphabet() != ProteinTools.getAlphabet()) {
            throw new IllegalSymbolException("Cleaveage residues must be from the PROTEIN alphabet");
        }
        if (notCleaveRes.getAlphabet() != ProteinTools.getAlphabet() && notCleaveRes.getAlphabet() != Alphabet.EMPTY_ALPHABET) {
            throw new IllegalSymbolException("Cleaveage residues must be from the PROTEIN alphabet or an EmptySymbolList");
        }
        this.cleavageResidues = cleaveRes;
        this.endoProtease = endoProtease;
        this.notCleaveResidues = notCleaveRes;
        this.name = name;
    }

    public Protease(SymbolList cleaveRes, boolean endoProtease, SymbolList notCleaveRes) throws IllegalSymbolException, BioException {
    }

    public Protease(String cleaveRes, boolean endoProtease, String notCleaveRes) throws IllegalSymbolException, BioException {
        this.cleavageResidues = this.createSymbolList(cleaveRes);
        this.endoProtease = endoProtease;
        this.notCleaveResidues = this.createSymbolList(notCleaveRes);
    }

    public Protease(String cleavageRes, boolean endoProtease) throws IllegalSymbolException, BioException {
        this.cleavageResidues = this.createSymbolList(cleavageRes);
        this.endoProtease = endoProtease;
        this.notCleaveResidues = this.createSymbolList("");
    }

    public SymbolList getCleaveageResidues() {
        return this.cleavageResidues;
    }

    public String getName() {
        return this.name;
    }

    public SymbolList getNotCleaveResidues() {
        return this.notCleaveResidues;
    }

    public boolean isEndoProtease() {
        return this.endoProtease;
    }

    public static String[] getProteaseList() {
        Set s = ProteaseManager.getNames();
        String[] names = new String[s.size()];
        return s.toArray(names);
    }

    public static final Protease getProteaseByName(String proteaseName) throws BioException {
        return ProteaseManager.getProteaseByName(proteaseName);
    }

    private SymbolList createSymbolList(String seq) throws IllegalSymbolException, BioException {
        if (seq == null || seq.trim().equals("")) {
            return SymbolList.EMPTY_LIST;
        }
        FiniteAlphabet prot = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
        SymbolTokenization tokenization = prot.getTokenization("token");
        SimpleSymbolList sList = new SimpleSymbolList(tokenization, seq);
        return sList;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            if (ProteaseManager.registered(this.getName())) {
                return ProteaseManager.getProteaseByName(this.getName());
            }
            ProteaseManager.registerProtease(this);
            return this;
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion Error: Cannot register Protease instance following de serialization");
        }
    }
}

