/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.seq.ByHierarchy;
import org.biojava.bio.seq.Down;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.Up;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;

public class FilterUtils {
    private static int depth = 0;

    public static boolean areProperSubset(FeatureFilter sub, FeatureFilter sup) {
        if (sub == null) {
            throw new NullPointerException("Null FeatureFilter: sub");
        }
        if (sup == null) {
            throw new NullPointerException("Null FeatureFilter: sup");
        }
        if (sub.equals(sup)) {
            return true;
        }
        if (sup == FilterUtils.all()) {
            return true;
        }
        if (sub == FilterUtils.none()) {
            return true;
        }
        if (sup instanceof FeatureFilter.And) {
            FeatureFilter.And and_sup = (FeatureFilter.And)sup;
            return FilterUtils.areProperSubset(sub, and_sup.getChild1()) && FilterUtils.areProperSubset(sub, and_sup.getChild2());
        }
        if (sub instanceof FeatureFilter.And) {
            FeatureFilter.And and_sub = (FeatureFilter.And)sub;
            return FilterUtils.areProperSubset(and_sub.getChild1(), sup) || FilterUtils.areProperSubset(and_sub.getChild2(), sup);
        }
        if (sub instanceof FeatureFilter.Or) {
            FeatureFilter.Or or_sub = (FeatureFilter.Or)sub;
            return FilterUtils.areProperSubset(or_sub.getChild1(), sup) && FilterUtils.areProperSubset(or_sub.getChild2(), sup);
        }
        if (sup instanceof FeatureFilter.Or) {
            FeatureFilter.Or or_sup = (FeatureFilter.Or)sup;
            return FilterUtils.areProperSubset(sub, or_sup.getChild1()) || FilterUtils.areProperSubset(sub, or_sup.getChild2());
        }
        if (sup instanceof FeatureFilter.Not) {
            FeatureFilter not_sup = ((FeatureFilter.Not)sup).getChild();
            return FilterUtils.areDisjoint(sub, not_sup);
        }
        if (sub instanceof FeatureFilter.Not) {
            return false;
        }
        if (sub instanceof OptimizableFilter) {
            return ((OptimizableFilter)sub).isProperSubset(sup);
        }
        return sup.equals(sub);
    }

    public static boolean areDisjoint(FeatureFilter a, FeatureFilter b) {
        if (a == null) {
            throw new NullPointerException("Null FeatureFilter: a");
        }
        if (b == null) {
            throw new NullPointerException("Null FeatureFilter: b");
        }
        if (a.equals(b)) {
            return false;
        }
        if (a == FilterUtils.none() || b == FilterUtils.none()) {
            return true;
        }
        if (a == FilterUtils.all()) {
            return FilterUtils.areProperSubset(b, FeatureFilter.none);
        }
        if (b == FilterUtils.all()) {
            return FilterUtils.areProperSubset(a, FeatureFilter.none);
        }
        if (a == FilterUtils.none() || b == FilterUtils.none()) {
            return true;
        }
        if (a instanceof FeatureFilter.And) {
            FeatureFilter.And and_a = (FeatureFilter.And)a;
            return FilterUtils.areDisjoint(and_a.getChild1(), b) || FilterUtils.areDisjoint(and_a.getChild2(), b);
        }
        if (b instanceof FeatureFilter.And) {
            FeatureFilter.And and_b = (FeatureFilter.And)b;
            return FilterUtils.areDisjoint(a, and_b.getChild1()) || FilterUtils.areDisjoint(a, and_b.getChild2());
        }
        if (a instanceof FeatureFilter.Or) {
            FeatureFilter.Or or_a = (FeatureFilter.Or)a;
            return FilterUtils.areDisjoint(or_a.getChild1(), b) && FilterUtils.areDisjoint(or_a.getChild2(), b);
        }
        if (b instanceof FeatureFilter.Or) {
            FeatureFilter.Or or_b = (FeatureFilter.Or)b;
            return FilterUtils.areDisjoint(a, or_b.getChild1()) && FilterUtils.areDisjoint(a, or_b.getChild2());
        }
        if (a instanceof FeatureFilter.Not) {
            FeatureFilter not_a = ((FeatureFilter.Not)a).getChild();
            return FilterUtils.areProperSubset(b, not_a);
        }
        if (b instanceof FeatureFilter.Not) {
            FeatureFilter not_b = ((FeatureFilter.Not)b).getChild();
            return FilterUtils.areProperSubset(a, not_b);
        }
        if (a instanceof FeatureFilter.ByFeature) {
            return ((FeatureFilter.ByFeature)a).isDisjoint(b);
        }
        if (b instanceof FeatureFilter.ByFeature) {
            return ((FeatureFilter.ByFeature)b).isDisjoint(a);
        }
        if (a instanceof FeatureFilter.ByAncestor) {
            return ((OptimizableFilter)a).isDisjoint(b);
        }
        if (b instanceof FeatureFilter.ByAncestor) {
            return ((OptimizableFilter)b).isDisjoint(a);
        }
        if (a instanceof FeatureFilter.ByParent) {
            return ((OptimizableFilter)a).isDisjoint(b);
        }
        if (b instanceof FeatureFilter.ByParent) {
            return ((OptimizableFilter)b).isDisjoint(a);
        }
        if (a instanceof OptimizableFilter) {
            return ((OptimizableFilter)a).isDisjoint(b);
        }
        if (b instanceof OptimizableFilter) {
            return ((OptimizableFilter)b).isDisjoint(a);
        }
        return false;
    }

    public static Location extractOverlappingLocation(FeatureFilter ff) {
        if (ff instanceof FeatureFilter.OverlapsLocation) {
            return ((FeatureFilter.OverlapsLocation)ff).getLocation();
        }
        if (ff instanceof FeatureFilter.ContainedByLocation) {
            return ((FeatureFilter.ContainedByLocation)ff).getLocation();
        }
        if (ff instanceof FeatureFilter.And) {
            FeatureFilter.And ffa = (FeatureFilter.And)ff;
            Location l1 = FilterUtils.extractOverlappingLocation(ffa.getChild1());
            Location l2 = FilterUtils.extractOverlappingLocation(ffa.getChild2());
            if (l1 != null) {
                if (l2 != null) {
                    return l1.intersection(l2);
                }
                return l1;
            }
            if (l2 != null) {
                return l2;
            }
            return null;
        }
        if (ff instanceof FeatureFilter.Or) {
            FeatureFilter.Or ffo = (FeatureFilter.Or)ff;
            Location l1 = FilterUtils.extractOverlappingLocation(ffo.getChild1());
            Location l2 = FilterUtils.extractOverlappingLocation(ffo.getChild2());
            if (l1 != null && l2 != null) {
                return LocationTools.union(l1, l2);
            }
        }
        return null;
    }

    public static final boolean areEqual(FeatureFilter f1, FeatureFilter f2) {
        if (f1 instanceof FeatureFilter.And && f2 instanceof FeatureFilter.And) {
            ArrayList f1f = new ArrayList();
            ArrayList f2f = new ArrayList();
            FilterUtils.expandAnd(f1, f1f);
            FilterUtils.expandAnd(f2, f2f);
            return new HashSet(f1f).equals(new HashSet(f2f));
        }
        if (f1 instanceof FeatureFilter.And || f2 instanceof FeatureFilter.And) {
            return false;
        }
        if (f1 instanceof FeatureFilter.Or && f2 instanceof FeatureFilter.Or) {
            ArrayList f1f = new ArrayList();
            ArrayList f2f = new ArrayList();
            FilterUtils.expandOr(f1, f1f);
            FilterUtils.expandOr(f2, f2f);
            return new HashSet(f1f).equals(new HashSet(f2f));
        }
        if (f1 instanceof FeatureFilter.Or || f2 instanceof FeatureFilter.Or) {
            return false;
        }
        return f1.equals(f2);
    }

    public static final FeatureFilter byType(String type) {
        return new FeatureFilter.ByType(type);
    }

    public static final FeatureFilter bySource(String source) {
        return new FeatureFilter.BySource(source);
    }

    public static final FeatureFilter byClass(Class clazz) throws ClassCastException {
        return new FeatureFilter.ByClass(clazz);
    }

    public static final FeatureFilter containedByLocation(Location loc) {
        return new FeatureFilter.ContainedByLocation(loc);
    }

    public static final FeatureFilter overlapsLocation(Location loc) {
        return new FeatureFilter.OverlapsLocation(loc);
    }

    public static final FeatureFilter bySequenceName(String name) {
        return new FeatureFilter.BySequenceName(name);
    }

    public static final FeatureFilter not(FeatureFilter filter) {
        return new FeatureFilter.Not(filter);
    }

    public static final FeatureFilter and(FeatureFilter c1, FeatureFilter c2) {
        return new FeatureFilter.And(c1, c2);
    }

    public static final FeatureFilter and(FeatureFilter[] filters) {
        if (filters.length == 0) {
            return FilterUtils.all();
        }
        if (filters.length == 1) {
            return filters[0];
        }
        FeatureFilter f = FilterUtils.and(filters[0], filters[1]);
        int i = 2;
        while (i < filters.length) {
            f = FilterUtils.and(f, filters[i]);
            ++i;
        }
        return f;
    }

    public static final FeatureFilter or(FeatureFilter c1, FeatureFilter c2) {
        return new FeatureFilter.Or(c1, c2);
    }

    public static final FeatureFilter or(FeatureFilter[] filters) {
        if (filters.length == 0) {
            return FilterUtils.none();
        }
        if (filters.length == 1) {
            return filters[0];
        }
        FeatureFilter f = FilterUtils.or(filters[0], filters[1]);
        int i = 2;
        while (i < filters.length) {
            f = FilterUtils.or(f, filters[i]);
            ++i;
        }
        return f;
    }

    public static final FeatureFilter byAnnotationType(AnnotationType type) {
        return new FeatureFilter.ByAnnotationType(type);
    }

    public static final FeatureFilter byAnnotation(Object key, Object value) {
        return new FeatureFilter.ByAnnotation(key, value);
    }

    public static final FeatureFilter byAnnotationType(Object key, Class valClass) {
        AnnotationType.Impl type = new AnnotationType.Impl();
        type.setConstraints(key, new PropertyConstraint.ByClass(valClass), CardinalityConstraint.ANY);
        return FilterUtils.byAnnotationType(type);
    }

    public static final FeatureFilter hasAnnotation(Object key) {
        return new FeatureFilter.HasAnnotation(key);
    }

    public static final FeatureFilter byStrand(StrandedFeature.Strand strand) {
        return new FeatureFilter.StrandFilter(strand);
    }

    public static final FeatureFilter byParent(FeatureFilter parentFilter) {
        return new FeatureFilter.ByParent(parentFilter);
    }

    public static final FeatureFilter byAncestor(FeatureFilter ancestorFilter) {
        return new FeatureFilter.ByAncestor(ancestorFilter);
    }

    public static final FeatureFilter byChild(FeatureFilter childFilter) {
        return new FeatureFilter.ByChild(childFilter);
    }

    public static final FeatureFilter byDescendant(FeatureFilter descFilter) {
        return new FeatureFilter.ByDescendant(descFilter);
    }

    public static final FeatureFilter byFrame(FramedFeature.ReadingFrame frame) {
        return new FeatureFilter.FrameFilter(frame);
    }

    public static final FeatureFilter byPairwiseScore(double minScore, double maxScore) {
        return new FeatureFilter.ByPairwiseScore(minScore, maxScore);
    }

    public static final FeatureFilter byComponentName(String compName) {
        return new FeatureFilter.ByComponentName(compName);
    }

    public static final FeatureFilter topLevel() {
        return FeatureFilter.top_level;
    }

    public static final FeatureFilter leaf() {
        return FeatureFilter.leaf;
    }

    public static final FeatureFilter all() {
        return FeatureFilter.all;
    }

    public static final FeatureFilter none() {
        return FeatureFilter.none;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final FeatureFilter optimize(FeatureFilter filter) {
        FeatureFilter featureFilter;
        block42: {
            FeatureFilter featureFilter2;
            block41: {
                ++depth;
                try {
                    if (filter instanceof FeatureFilter.And) {
                        FeatureFilter res;
                        FeatureFilter or;
                        ArrayList<FeatureFilter> ors;
                        ArrayList<FeatureFilter> filters;
                        block37: {
                            FeatureFilter andedOrs;
                            block38: {
                                FeatureFilter a;
                                filters = new ArrayList<FeatureFilter>();
                                FilterUtils.expandAnd(filter, filters);
                                int i = 0;
                                while (true) {
                                    if (i >= filters.size()) break;
                                    filters.set(i, FilterUtils.optimize((FeatureFilter)filters.get(i)));
                                    ++i;
                                }
                                ors = new ArrayList<FeatureFilter>();
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= filters.size()) break;
                                    FeatureFilter f = (FeatureFilter)filters.get(i2);
                                    if (f instanceof FeatureFilter.Or) {
                                        filters.remove(i2);
                                        ors.add(f);
                                        --i2;
                                    }
                                    ++i2;
                                }
                                int i3 = 1;
                                while (true) {
                                    if (i3 >= filters.size()) {
                                        if (!filters.isEmpty()) break block37;
                                        if (ors.isEmpty()) {
                                            break;
                                        }
                                        break block38;
                                    }
                                    a = (FeatureFilter)filters.get(i3);
                                    int j = 0;
                                    while (j < i3) {
                                        FeatureFilter b = (FeatureFilter)filters.get(j);
                                        if (FilterUtils.areDisjoint(a, b)) {
                                            FeatureFilter featureFilter3 = FilterUtils.none();
                                            Object var14_32 = null;
                                            --depth;
                                            return featureFilter3;
                                        }
                                        if (FilterUtils.areProperSubset(a, b)) {
                                            filters.remove(j);
                                            --j;
                                            --i3;
                                        } else {
                                            if (FilterUtils.areProperSubset(b, a)) {
                                                filters.remove(i3);
                                                --i3;
                                                break;
                                            }
                                            FeatureFilter intersect = FilterUtils.intersection(a, b);
                                            if (intersect != null) {
                                                filters.set(i3, intersect);
                                                filters.remove(j);
                                                --j;
                                                i3 -= 2;
                                            }
                                        }
                                        ++j;
                                    }
                                    ++i3;
                                }
                                a = FilterUtils.none();
                                Object var14_33 = null;
                                --depth;
                                return a;
                            }
                            FeatureFilter j = andedOrs = FilterUtils.and(filters.toArray(new FeatureFilter[0]));
                            Object var14_34 = null;
                            --depth;
                            return j;
                        }
                        FeatureFilter ands = FilterUtils.and(filters.toArray(new FeatureFilter[0]));
                        if (ors.isEmpty()) {
                            FeatureFilter j = ands;
                            Object var14_35 = null;
                            --depth;
                            return j;
                        }
                        ArrayList<FeatureFilter> combs = new ArrayList<FeatureFilter>();
                        combs.add(ands);
                        int i = 0;
                        block6: while (true) {
                            if (i >= ors.size()) break;
                            ArrayList<FeatureFilter> newCombs = new ArrayList<FeatureFilter>();
                            or = (FeatureFilter.Or)ors.get(i);
                            int j = 0;
                            while (true) {
                                if (j >= combs.size()) {
                                    combs = newCombs;
                                    ++i;
                                    continue block6;
                                }
                                FeatureFilter f = (FeatureFilter)combs.get(j);
                                newCombs.add(FilterUtils.and(f, ((FeatureFilter.Or)or).getChild1()));
                                newCombs.add(FilterUtils.and(f, ((FeatureFilter.Or)or).getChild2()));
                                ++j;
                            }
                            break;
                        }
                        or = res = FilterUtils.optimize(FilterUtils.or(combs.toArray(new FeatureFilter[0])));
                        Object var14_36 = null;
                        --depth;
                        return or;
                    }
                    if (filter instanceof FeatureFilter.Or) {
                        FeatureFilter val;
                        ArrayList<FeatureFilter> ands;
                        ArrayList<FeatureFilter> filters;
                        block39: {
                            FeatureFilter oredAnds;
                            block40: {
                                FeatureFilter a;
                                filters = new ArrayList<FeatureFilter>();
                                FilterUtils.expandOr(filter, filters);
                                int i = 0;
                                while (true) {
                                    if (i >= filters.size()) break;
                                    filters.set(i, FilterUtils.optimize((FeatureFilter)filters.get(i)));
                                    ++i;
                                }
                                ands = new ArrayList<FeatureFilter>();
                                int i4 = 0;
                                while (true) {
                                    if (i4 >= filters.size()) break;
                                    FeatureFilter f = (FeatureFilter)filters.get(i4);
                                    if (f instanceof FeatureFilter.And) {
                                        filters.remove(i4);
                                        ands.add(f);
                                        --i4;
                                    }
                                    ++i4;
                                }
                                int i5 = 1;
                                while (true) {
                                    if (i5 >= filters.size()) {
                                        if (!filters.isEmpty()) break block39;
                                        if (ands.isEmpty()) {
                                            break;
                                        }
                                        break block40;
                                    }
                                    a = (FeatureFilter)filters.get(i5);
                                    int j = 0;
                                    while (j < i5) {
                                        FeatureFilter b = (FeatureFilter)filters.get(j);
                                        if (a == FilterUtils.all() || b == FilterUtils.all()) {
                                            FeatureFilter res = FilterUtils.all();
                                            Object var14_37 = null;
                                            --depth;
                                            return res;
                                        }
                                        if (FilterUtils.areProperSubset(a, b)) {
                                            filters.remove(i5);
                                            --i5;
                                            break;
                                        }
                                        if (FilterUtils.areProperSubset(b, a)) {
                                            filters.remove(j);
                                            --j;
                                            i5 -= 2;
                                        } else {
                                            FeatureFilter union = FilterUtils.union(a, b);
                                            if (union != null) {
                                                filters.set(i5, union);
                                                filters.remove(j);
                                                --j;
                                                --i5;
                                            }
                                        }
                                        ++j;
                                    }
                                    ++i5;
                                }
                                a = FilterUtils.none();
                                Object var14_38 = null;
                                --depth;
                                return a;
                            }
                            FeatureFilter j = oredAnds = FilterUtils.or(ands.toArray(new FeatureFilter[0]));
                            Object var14_39 = null;
                            --depth;
                            return j;
                        }
                        FeatureFilter ors = FilterUtils.or(filters.toArray(new FeatureFilter[0]));
                        if (ands.isEmpty()) {
                            FeatureFilter j = ors;
                            Object var14_40 = null;
                            --depth;
                            return j;
                        }
                        ArrayList<FeatureFilter> combs = new ArrayList<FeatureFilter>();
                        combs.add(ors);
                        int i = 0;
                        block12: while (true) {
                            if (i >= ands.size()) break;
                            ArrayList<FeatureFilter> newCombs = new ArrayList<FeatureFilter>();
                            FeatureFilter.And and = (FeatureFilter.And)ands.get(i);
                            int j = 0;
                            while (true) {
                                if (j >= combs.size()) {
                                    combs = newCombs;
                                    ++i;
                                    continue block12;
                                }
                                FeatureFilter f = (FeatureFilter)combs.get(j);
                                newCombs.add(FilterUtils.or(f, and.getChild1()));
                                newCombs.add(FilterUtils.or(f, and.getChild2()));
                                ++j;
                            }
                            break;
                        }
                        FeatureFilter featureFilter4 = val = FilterUtils.optimize(FilterUtils.and(combs.toArray(new FeatureFilter[0])));
                        Object var14_41 = null;
                        --depth;
                        return featureFilter4;
                    }
                    if (filter instanceof FeatureFilter.Not) {
                        FeatureFilter.Not not = (FeatureFilter.Not)filter;
                        featureFilter2 = FilterUtils.not(FilterUtils.optimize(not.getChild()));
                        break block41;
                    }
                    featureFilter = filter;
                    break block42;
                }
                catch (Throwable throwable) {
                    Object var14_44 = null;
                    --depth;
                    throw throwable;
                }
            }
            Object var14_42 = null;
            --depth;
            return featureFilter2;
        }
        Object var14_43 = null;
        --depth;
        return featureFilter;
    }

    private static FeatureFilter intersection(FeatureFilter f1, FeatureFilter f2) {
        if (f1 instanceof FeatureFilter.ContainedByLocation && f2 instanceof FeatureFilter.ContainedByLocation) {
            Location loc = LocationTools.intersection(((FeatureFilter.ContainedByLocation)f1).getLocation(), ((FeatureFilter.ContainedByLocation)f2).getLocation());
            if (loc == Location.empty) {
                return FilterUtils.none();
            }
            return FilterUtils.containedByLocation(loc);
        }
        if (!(f1 instanceof FeatureFilter.OverlapsLocation) || !(f2 instanceof FeatureFilter.OverlapsLocation)) {
            if (f1 instanceof FeatureFilter.ByAnnotationType && f2 instanceof FeatureFilter.ByAnnotationType) {
                FeatureFilter.ByAnnotationType f1t = (FeatureFilter.ByAnnotationType)f1;
                FeatureFilter.ByAnnotationType f2t = (FeatureFilter.ByAnnotationType)f2;
                AnnotationType intersect = AnnotationTools.intersection(f1t.getType(), f2t.getType());
                if (intersect == AnnotationType.NONE) {
                    return FilterUtils.none();
                }
                return FilterUtils.byAnnotationType(intersect);
            }
            if (f1 instanceof ByHierarchy && f2 instanceof ByHierarchy) {
                ByHierarchy f1h = (ByHierarchy)f1;
                ByHierarchy f2h = (ByHierarchy)f2;
                if (f1 instanceof Up && f2 instanceof Up) {
                    FeatureFilter filt = FilterUtils.optimize(FilterUtils.or(f1h.getFilter(), f2h.getFilter()));
                    if (filt == FilterUtils.none()) {
                        return FilterUtils.none();
                    }
                    if (f1h instanceof FeatureFilter.ByParent || f2h instanceof FeatureFilter.ByParent) {
                        return FilterUtils.byParent(filt);
                    }
                    return FilterUtils.byAncestor(filt);
                }
                if (f1 instanceof Down && f2 instanceof Down) {
                    FeatureFilter filt = FilterUtils.optimize(FilterUtils.or(f1h.getFilter(), f2h.getFilter()));
                    if (filt == FilterUtils.none()) {
                        return FilterUtils.none();
                    }
                    if (f1h instanceof FeatureFilter.ByChild || f2h instanceof FeatureFilter.ByChild) {
                        return FilterUtils.byChild(filt);
                    }
                    return FilterUtils.byDescendant(filt);
                }
                return FilterUtils.none();
            }
        }
        return null;
    }

    private static FeatureFilter union(FeatureFilter f1, FeatureFilter f2) {
        if (f1 instanceof FeatureFilter.ContainedByLocation && f2 instanceof FeatureFilter.ContainedByLocation) {
            return FilterUtils.containedByLocation(LocationTools.union(((FeatureFilter.ContainedByLocation)f1).getLocation(), ((FeatureFilter.ContainedByLocation)f2).getLocation()));
        }
        if (f1 instanceof FeatureFilter.OverlapsLocation && f2 instanceof FeatureFilter.OverlapsLocation) {
            return FilterUtils.overlapsLocation(LocationTools.intersection(((FeatureFilter.OverlapsLocation)f1).getLocation(), ((FeatureFilter.OverlapsLocation)f2).getLocation()));
        }
        if (f1 instanceof FeatureFilter.ByAnnotationType && f2 instanceof FeatureFilter.ByAnnotationType) {
            FeatureFilter.ByAnnotationType f1t = (FeatureFilter.ByAnnotationType)f1;
            FeatureFilter.ByAnnotationType f2t = (FeatureFilter.ByAnnotationType)f2;
            AnnotationType union = AnnotationTools.union(f1t.getType(), f2t.getType());
            return FilterUtils.byAnnotationType(union);
        }
        if (f1 instanceof ByHierarchy && f2 instanceof ByHierarchy) {
            ByHierarchy f1h = (ByHierarchy)f1;
            ByHierarchy f2h = (ByHierarchy)f2;
            if (f1 instanceof Up && f2 instanceof Up) {
                FeatureFilter filt = FilterUtils.optimize(FilterUtils.or(f1h.getFilter(), f2h.getFilter()));
                if (filt == FilterUtils.none()) {
                    return FilterUtils.none();
                }
                if (f1h instanceof FeatureFilter.ByAncestor || f2h instanceof FeatureFilter.ByAncestor) {
                    return FilterUtils.byAncestor(filt);
                }
                return FilterUtils.byParent(filt);
            }
            if (f1 instanceof Down && f2 instanceof Down) {
                FeatureFilter filt = FilterUtils.optimize(FilterUtils.or(f1h.getFilter(), f2h.getFilter()));
                if (filt == FilterUtils.none()) {
                    return FilterUtils.none();
                }
                if (f1h instanceof FeatureFilter.ByDescendant || f2h instanceof FeatureFilter.ByDescendant) {
                    return FilterUtils.byDescendant(filt);
                }
                return FilterUtils.byChild(filt);
            }
            return FilterUtils.none();
        }
        return null;
    }

    private static void expandAnd(FeatureFilter filt, List filters) {
        if (filt instanceof FeatureFilter.And) {
            FeatureFilter.And and = (FeatureFilter.And)filt;
            FilterUtils.expandAnd(and.getChild1(), filters);
            FilterUtils.expandAnd(and.getChild2(), filters);
        } else {
            filters.add(filt);
        }
    }

    private static void expandOr(FeatureFilter filt, List filters) {
        if (filt instanceof FeatureFilter.Or) {
            FeatureFilter.Or or = (FeatureFilter.Or)filt;
            FilterUtils.expandOr(or.getChild1(), filters);
            FilterUtils.expandOr(or.getChild2(), filters);
        } else {
            filters.add(filt);
        }
    }

    public static FeatureFilter transformFilter(FeatureFilter ff, FilterTransformer trans) {
        if (ff == null) {
            throw new NullPointerException("Can't transform null filters");
        }
        if (ff instanceof FeatureFilter.And) {
            FeatureFilter.And and = (FeatureFilter.And)ff;
            return FilterUtils.and(FilterUtils.transformFilter(and.getChild1(), trans), FilterUtils.transformFilter(and.getChild2(), trans));
        }
        if (ff instanceof FeatureFilter.Or) {
            FeatureFilter.Or or = (FeatureFilter.Or)ff;
            return FilterUtils.or(FilterUtils.transformFilter(or.getChild1(), trans), FilterUtils.transformFilter(or.getChild2(), trans));
        }
        if (ff instanceof FeatureFilter.Not) {
            return FilterUtils.not(FilterUtils.transformFilter(((FeatureFilter.Not)ff).getChild(), trans));
        }
        FeatureFilter tf = trans.transform(ff);
        if (tf != null) {
            return tf;
        }
        return ff;
    }

    static FeatureFilter getOnlyDescendantsFilter(FeatureFilter ff) {
        if (ff instanceof FeatureFilter.OnlyDescendants) {
            return ((FeatureFilter.OnlyDescendants)ff).getFilter();
        }
        if (ff instanceof FeatureFilter.And) {
            FeatureFilter.And ffa = (FeatureFilter.And)ff;
            FeatureFilter ocf1 = FilterUtils.getOnlyDescendantsFilter(ffa.getChild1());
            FeatureFilter ocf2 = FilterUtils.getOnlyDescendantsFilter(ffa.getChild2());
            if (ocf1 == null) {
                return ocf2;
            }
            if (ocf2 == null) {
                return ocf1;
            }
            return new FeatureFilter.And(ocf1, ocf2);
        }
        if (ff instanceof FeatureFilter.Or) {
            FeatureFilter.Or ffa = (FeatureFilter.Or)ff;
            FeatureFilter ocf1 = FilterUtils.getOnlyDescendantsFilter(ffa.getChild1());
            FeatureFilter ocf2 = FilterUtils.getOnlyDescendantsFilter(ffa.getChild2());
            if (ocf1 == null) {
                return ocf2;
            }
            if (ocf2 == null) {
                return ocf1;
            }
            return new FeatureFilter.Or(ocf1, ocf2);
        }
        return null;
    }

    static FeatureFilter getOnlyChildrenFilter(FeatureFilter ff) {
        if (ff instanceof FeatureFilter.OnlyChildren) {
            return ((FeatureFilter.OnlyChildren)ff).getFilter();
        }
        if (ff instanceof FeatureFilter.OnlyDescendants) {
            return ((FeatureFilter.OnlyDescendants)ff).getFilter();
        }
        if (ff instanceof FeatureFilter.And) {
            FeatureFilter.And ffa = (FeatureFilter.And)ff;
            FeatureFilter ocf1 = FilterUtils.getOnlyChildrenFilter(ffa.getChild1());
            FeatureFilter ocf2 = FilterUtils.getOnlyChildrenFilter(ffa.getChild2());
            if (ocf1 == null) {
                return ocf2;
            }
            if (ocf2 == null) {
                return ocf1;
            }
            return new FeatureFilter.And(ocf1, ocf2);
        }
        if (ff instanceof FeatureFilter.Or) {
            FeatureFilter.Or ffa = (FeatureFilter.Or)ff;
            FeatureFilter ocf1 = FilterUtils.getOnlyChildrenFilter(ffa.getChild1());
            FeatureFilter ocf2 = FilterUtils.getOnlyChildrenFilter(ffa.getChild2());
            if (ocf1 == null) {
                return ocf2;
            }
            if (ocf2 == null) {
                return ocf1;
            }
            return new FeatureFilter.Or(ocf1, ocf2);
        }
        return null;
    }

    public class DelegatingTransformer
    implements FilterTransformer {
        FilterTransformer t1;
        FilterTransformer t2;

        public DelegatingTransformer(FilterTransformer t1, FilterTransformer t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public FeatureFilter transform(FeatureFilter ff) {
            FeatureFilter res = this.t1.transform(ff);
            if (res == null) {
                res = this.t2.transform(ff);
            }
            return res;
        }
    }

    public static interface FilterTransformer {
        public FeatureFilter transform(FeatureFilter var1);
    }
}

