/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SubSequence;
import org.biojava.bio.seq.ViewSequence;
import org.biojava.bio.seq.impl.RevCompSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public final class SequenceTools {
    public static Sequence createSequence(SymbolList syms, String uri, String name, Annotation ann) {
        return new SimpleSequence(syms, uri, name, ann);
    }

    public static Sequence subSequence(Sequence seq, int start, int end) throws IndexOutOfBoundsException {
        return new SubSequence(seq, start, end);
    }

    public static Sequence subSequence(Sequence seq, int start, int end, String name) throws IndexOutOfBoundsException {
        return new SubSequence(seq, start, end, name);
    }

    public static Sequence reverseComplement(Sequence seq) throws IllegalAlphabetException {
        return new RevCompSequence(seq);
    }

    public static Sequence view(Sequence seq) {
        return new ViewSequence(seq);
    }

    public static Sequence view(Sequence seq, String name) {
        return new ViewSequence(seq, name);
    }

    public static void addAllFeatures(Sequence seq, FeatureHolder fh) throws ChangeVetoException, BioException {
        SequenceTools.addFeatures(seq, fh);
    }

    private static void addFeatures(FeatureHolder toAddTo, FeatureHolder thingsToAdd) throws ChangeVetoException, BioException {
        Iterator i = thingsToAdd.features();
        while (i.hasNext()) {
            Feature f2add = (Feature)i.next();
            Feature added = toAddTo.createFeature(f2add.makeTemplate());
            SequenceTools.addFeatures(added, f2add);
        }
    }
}

