/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSequenceDB
extends AbstractChangeable
implements SequenceDB {
    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator pID;
            {
                this.pID = AbstractSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.pID.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return AbstractSequenceDB.this.getSequence((String)this.pID.next());
            }
        };
    }

    public FeatureHolder filter(FeatureFilter ff) {
        MergeFeatureHolder results = new MergeFeatureHolder();
        try {
            SequenceIterator si = this.sequenceIterator();
            while (si.hasNext()) {
                Sequence seq = si.nextSequence();
                FeatureHolder fh = seq.filter(ff);
                if (fh == FeatureHolder.EMPTY_FEATURE_HOLDER) continue;
                results.addFeatureHolder(fh);
            }
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion failed: couldn't modify newly created MergeFeatureHolder");
        }
        return results;
    }

    public void addSequence(Sequence seq) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }

    public void removeSequence(String id) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }
}

